/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.DictionaryBuilding;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.data.ComparableList;

public abstract class ArrayNumericGroupByColumnSelectorStrategy<T extends Comparable>
implements GroupByColumnSelectorStrategy {
    protected static final int GROUP_BY_MISSING_VALUE = -1;
    protected final List<List<T>> dictionary;
    protected final Object2IntMap<List<T>> reverseDictionary;
    protected long estimatedFootprint = 0L;
    private final int valueFootprint;

    public ArrayNumericGroupByColumnSelectorStrategy(int valueFootprint) {
        this.dictionary = DictionaryBuilding.createDictionary();
        this.reverseDictionary = DictionaryBuilding.createReverseDictionary();
        this.valueFootprint = valueFootprint;
    }

    @VisibleForTesting
    ArrayNumericGroupByColumnSelectorStrategy(List<List<T>> dictionary, Object2IntOpenHashMap<List<T>> reverseDictionary, int valueFootprint) {
        this.dictionary = dictionary;
        this.reverseDictionary = reverseDictionary;
        this.valueFootprint = valueFootprint;
    }

    @Override
    public int getGroupingKeySize() {
        return 4;
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, ResultRow resultRow, int keyBufferPosition) {
        int id = key.getInt(keyBufferPosition);
        if (id != -1) {
            List<T> value = this.dictionary.get(id);
            resultRow.set(selectorPlus.getResultRowPosition(), new ComparableList<T>(value));
        } else {
            resultRow.set(selectorPlus.getResultRowPosition(), null);
        }
    }

    @Override
    public int initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] valuess) {
        long priorFootprint = this.estimatedFootprint;
        valuess[columnIndex] = this.computeDictionaryId(selector);
        return (int)(this.estimatedFootprint - priorFootprint);
    }

    @Override
    public void initGroupingKeyColumnValue(int keyBufferPosition, int dimensionIndex, Object rowObj, ByteBuffer keyBuffer, int[] stack) {
        int groupingKey = (Integer)rowObj;
        this.writeToKeyBuffer(keyBufferPosition, groupingKey, keyBuffer);
        stack[dimensionIndex] = groupingKey == -1 ? 0 : 1;
    }

    @Override
    public boolean checkRowIndexAndAddValueToGroupingKey(int keyBufferPosition, Object rowObj, int rowValIdx, ByteBuffer keyBuffer) {
        return false;
    }

    protected abstract int computeDictionaryId(ColumnValueSelector var1);

    @Override
    public int writeToKeyBuffer(int keyBufferPosition, ColumnValueSelector selector, ByteBuffer keyBuffer) {
        long priorFootprint = this.estimatedFootprint;
        keyBuffer.putInt(keyBufferPosition, this.computeDictionaryId(selector));
        return (int)(this.estimatedFootprint - priorFootprint);
    }

    protected int addToIndexedDictionary(List<T> t) {
        int dictId = this.reverseDictionary.getInt(t);
        if (dictId < 0) {
            int size = this.dictionary.size();
            this.dictionary.add(t);
            this.reverseDictionary.put(t, size);
            this.estimatedFootprint += (long)DictionaryBuilding.estimateEntryFootprint(t.size() * (8 + this.valueFootprint));
            return size;
        }
        return dictId;
    }

    @Override
    public Grouper.BufferComparator bufferComparator(int keyBufferPosition, @Nullable StringComparator stringComparator) {
        StringComparator comparator = stringComparator == null ? StringComparators.NUMERIC : stringComparator;
        return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
            List<T> lhs = this.dictionary.get(lhsBuffer.getInt(lhsPosition + keyBufferPosition));
            List<T> rhs = this.dictionary.get(rhsBuffer.getInt(rhsPosition + keyBufferPosition));
            int minLength = Math.min(lhs.size(), rhs.size());
            if (lhs == rhs) {
                return 0;
            }
            for (int i = 0; i < minLength; ++i) {
                Comparable left = (Comparable)lhs.get(i);
                Comparable right = (Comparable)rhs.get(i);
                int cmp = left == null && right == null ? 0 : (left == null ? -1 : comparator.compare(String.valueOf(lhs.get(i)), String.valueOf(rhs.get(i))));
                if (cmp == 0) continue;
                return cmp;
            }
            if (lhs.size() == rhs.size()) {
                return 0;
            }
            if (lhs.size() < rhs.size()) {
                return -1;
            }
            return 1;
        };
    }

    @Override
    public void reset() {
        this.dictionary.clear();
        this.reverseDictionary.clear();
        this.estimatedFootprint = 0L;
    }

    @VisibleForTesting
    void writeToKeyBuffer(int keyBufferPosition, int groupingKey, ByteBuffer keyBuffer) {
        keyBuffer.putInt(keyBufferPosition, groupingKey);
    }
}

