/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.DictionaryBuilding;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.StringGroupByColumnSelectorStrategy;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.data.IndexedInts;

public class DictionaryBuildingStringGroupByColumnSelectorStrategy
extends StringGroupByColumnSelectorStrategy {
    private static final int GROUP_BY_MISSING_VALUE = -1;
    private final List<String> dictionary = DictionaryBuilding.createDictionary();
    private final Object2IntMap<String> reverseDictionary = DictionaryBuilding.createReverseDictionary();

    public DictionaryBuildingStringGroupByColumnSelectorStrategy() {
        super(null, null);
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, ResultRow resultRow, int keyBufferPosition) {
        int id = key.getInt(keyBufferPosition);
        if (id != -1) {
            String value = this.dictionary.get(id);
            resultRow.set(selectorPlus.getResultRowPosition(), value);
        } else {
            resultRow.set(selectorPlus.getResultRowPosition(), NullHandling.defaultStringValue());
        }
    }

    @Override
    public int initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] valuess) {
        DimensionSelector dimSelector = (DimensionSelector)selector;
        IndexedInts row = dimSelector.getRow();
        int stateFootprintIncrease = 0;
        ArrayBasedIndexedInts newRow = (ArrayBasedIndexedInts)valuess[columnIndex];
        if (newRow == null) {
            newRow = new ArrayBasedIndexedInts();
            valuess[columnIndex] = newRow;
        }
        int rowSize = row.size();
        newRow.ensureSize(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            String value = dimSelector.lookupName(row.get(i));
            int dictId = this.reverseDictionary.getInt((Object)value);
            if (dictId < 0) {
                int nextId = this.dictionary.size();
                this.dictionary.add(value);
                this.reverseDictionary.put((Object)value, nextId);
                newRow.setValue(i, nextId);
                stateFootprintIncrease += DictionaryBuilding.estimateEntryFootprint((value == null ? 0 : value.length()) * 2);
                continue;
            }
            newRow.setValue(i, dictId);
        }
        newRow.setSize(rowSize);
        return stateFootprintIncrease;
    }

    @Override
    public int writeToKeyBuffer(int keyBufferPosition, ColumnValueSelector selector, ByteBuffer keyBuffer) {
        DimensionSelector dimSelector = (DimensionSelector)selector;
        IndexedInts row = dimSelector.getRow();
        Preconditions.checkState((row.size() < 2 ? 1 : 0) != 0, (Object)"Not supported for multi-value dimensions");
        if (row.size() == 0) {
            this.writeToKeyBuffer(keyBufferPosition, -1, keyBuffer);
            return 0;
        }
        String value = dimSelector.lookupName(row.get(0));
        int dictId = this.reverseDictionary.getInt((Object)value);
        if (dictId == -1) {
            int nextId = this.dictionary.size();
            this.dictionary.add(value);
            this.reverseDictionary.put((Object)value, nextId);
            this.writeToKeyBuffer(keyBufferPosition, nextId, keyBuffer);
            return DictionaryBuilding.estimateEntryFootprint((value == null ? 0 : value.length()) * 2);
        }
        this.writeToKeyBuffer(keyBufferPosition, dictId, keyBuffer);
        return 0;
    }

    @Override
    public Grouper.BufferComparator bufferComparator(int keyBufferPosition, @Nullable StringComparator stringComparator) {
        StringComparator realComparator = stringComparator == null ? StringComparators.LEXICOGRAPHIC : stringComparator;
        return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
            String lhsStr = this.dictionary.get(lhsBuffer.getInt(lhsPosition + keyBufferPosition));
            String rhsStr = this.dictionary.get(rhsBuffer.getInt(rhsPosition + keyBufferPosition));
            return realComparator.compare(lhsStr, rhsStr);
        };
    }

    @Override
    public void reset() {
        this.dictionary.clear();
        this.reverseDictionary.clear();
    }
}

