/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Comparator;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.NestedDataColumnIndexer;
import org.apache.druid.segment.NestedDataColumnMerger;
import org.apache.druid.segment.NestedDataDimensionSchema;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableObjectColumnValueSelector;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class NestedDataDimensionHandler
implements DimensionHandler<StructuredData, StructuredData, StructuredData> {
    private static Comparator<ColumnValueSelector> COMPARATOR = (s1, s2) -> StructuredData.COMPARATOR.compare(StructuredData.wrap(s1.getObject()), StructuredData.wrap(s2.getObject()));
    private final String name;

    public NestedDataDimensionHandler(String name) {
        this.name = name;
    }

    @Override
    public String getDimensionName() {
        return this.name;
    }

    @Override
    public DimensionSpec getDimensionSpec() {
        return new DefaultDimensionSpec(this.name, this.name, NestedDataComplexTypeSerde.TYPE);
    }

    @Override
    public DimensionSchema getDimensionSchema(ColumnCapabilities capabilities) {
        return new NestedDataDimensionSchema(this.name);
    }

    @Override
    public DimensionIndexer<StructuredData, StructuredData, StructuredData> makeIndexer(boolean useMaxMemoryEstimates) {
        return new NestedDataColumnIndexer();
    }

    @Override
    public DimensionMergerV9 makeMerger(IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ColumnCapabilities capabilities, ProgressIndicator progress, Closer closer) {
        return new NestedDataColumnMerger(this.name, indexSpec, segmentWriteOutMedium, progress, closer);
    }

    @Override
    public int getLengthOfEncodedKeyComponent(StructuredData dimVals) {
        return 1;
    }

    @Override
    public Comparator<ColumnValueSelector> getEncodedValueSelectorComparator() {
        return COMPARATOR;
    }

    @Override
    public SettableColumnValueSelector makeNewSettableEncodedValueSelector() {
        return new SettableObjectColumnValueSelector();
    }
}

