/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.ColumnSelectorColumnIndexSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DeprecatedQueryableIndexColumnSelector;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorSequenceBuilder;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.vector.VectorCursor;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class QueryableIndexStorageAdapter
implements StorageAdapter {
    public static final int DEFAULT_VECTOR_SIZE = 512;
    private final QueryableIndex index;
    @Nullable
    private volatile DateTime minTime;
    @Nullable
    private volatile DateTime maxTime;

    public QueryableIndexStorageAdapter(QueryableIndex index) {
        this.index = index;
    }

    @Override
    public Interval getInterval() {
        return this.index.getDataInterval();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return this.index.getAvailableDimensions();
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        LinkedHashSet<String> columnNames = new LinkedHashSet<String>(this.index.getColumnNames());
        for (String dimension : this.index.getAvailableDimensions()) {
            columnNames.remove(dimension);
        }
        return columnNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDimensionCardinality(String dimension) {
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder == null) {
            return 1;
        }
        try (BaseColumn col = columnHolder.getColumn();){
            if (!(col instanceof DictionaryEncodedColumn)) {
                int n = -1;
                return n;
            }
            int n = ((DictionaryEncodedColumn)col).getCardinality();
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int getNumRows() {
        return this.index.getNumRows();
    }

    @Override
    public DateTime getMinTime() {
        if (this.minTime == null) {
            this.populateMinMaxTime();
        }
        return this.minTime;
    }

    @Override
    public DateTime getMaxTime() {
        if (this.maxTime == null) {
            this.populateMinMaxTime();
        }
        return this.maxTime;
    }

    @Override
    @Nullable
    public Comparable getMinValue(String dimension) {
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder != null && columnHolder.getCapabilities().hasBitmapIndexes()) {
            ColumnIndexSupplier indexSupplier = columnHolder.getIndexSupplier();
            DictionaryEncodedStringValueIndex index = indexSupplier.as(DictionaryEncodedStringValueIndex.class);
            return index.getCardinality() > 0 ? index.getValue(0) : null;
        }
        return null;
    }

    @Override
    @Nullable
    public Comparable getMaxValue(String dimension) {
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder != null && columnHolder.getCapabilities().hasBitmapIndexes()) {
            ColumnIndexSupplier indexSupplier = columnHolder.getIndexSupplier();
            DictionaryEncodedStringValueIndex index = indexSupplier.as(DictionaryEncodedStringValueIndex.class);
            return index.getCardinality() > 0 ? index.getValue(index.getCardinality() - 1) : null;
        }
        return null;
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.index.getColumnCapabilities(column);
    }

    @Override
    public DateTime getMaxIngestedEventTime() {
        return this.getMaxTime();
    }

    @Override
    public boolean canVectorize(@Nullable Filter filter, VirtualColumns virtualColumns, boolean descending) {
        if (filter != null) {
            boolean filterCanVectorize;
            boolean bl = filterCanVectorize = filter.getBitmapColumnIndex(this.makeBitmapIndexSelector(virtualColumns)) != null || filter.canVectorizeMatcher(this);
            if (!filterCanVectorize) {
                return false;
            }
        }
        return !descending;
    }

    @Override
    @Nullable
    public VectorCursor makeVectorCursor(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, boolean descending, int vectorSize, @Nullable QueryMetrics<?> queryMetrics) {
        Interval actualInterval;
        if (!this.canVectorize(filter, virtualColumns, descending)) {
            throw new ISE("Cannot vectorize. Check 'canVectorize' before calling 'makeVectorCursor'.", new Object[0]);
        }
        if (queryMetrics != null) {
            queryMetrics.vectorized(true);
        }
        if ((actualInterval = this.computeCursorInterval(Granularities.ALL, interval)) == null) {
            return null;
        }
        return new QueryableIndexCursorSequenceBuilder(this.index, actualInterval, virtualColumns, filter, queryMetrics, this.getMinTime().getMillis(), this.getMaxTime().getMillis(), descending).buildVectorized(vectorSize > 0 ? vectorSize : 512);
    }

    @Override
    public Sequence<Cursor> makeCursors(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, Granularity gran, boolean descending, @Nullable QueryMetrics<?> queryMetrics) {
        Interval actualInterval;
        if (queryMetrics != null) {
            queryMetrics.vectorized(false);
        }
        if ((actualInterval = this.computeCursorInterval(gran, interval)) == null) {
            return Sequences.empty();
        }
        return Sequences.filter(new QueryableIndexCursorSequenceBuilder(this.index, actualInterval, virtualColumns, filter, queryMetrics, this.getMinTime().getMillis(), this.getMaxTime().getMillis(), descending).build(gran), Objects::nonNull);
    }

    @Override
    public Metadata getMetadata() {
        return this.index.getMetadata();
    }

    private void populateMinMaxTime() {
        ColumnHolder columnHolder = this.index.getColumnHolder("__time");
        try (NumericColumn column = (NumericColumn)columnHolder.getColumn();){
            this.minTime = DateTimes.utc((long)column.getLongSingleValueRow(0));
            this.maxTime = DateTimes.utc((long)column.getLongSingleValueRow(column.length() - 1));
        }
    }

    @Nullable
    private Interval computeCursorInterval(Granularity gran, Interval interval) {
        DateTime maxTime;
        DateTime minTime = this.getMinTime();
        Interval dataInterval = new Interval((ReadableInstant)minTime, (ReadableInstant)gran.bucketEnd(maxTime = this.getMaxTime()));
        if (!interval.overlaps((ReadableInterval)dataInterval)) {
            return null;
        }
        return interval.overlap((ReadableInterval)dataInterval);
    }

    @VisibleForTesting
    public ColumnSelectorColumnIndexSelector makeBitmapIndexSelector(VirtualColumns virtualColumns) {
        return new ColumnSelectorColumnIndexSelector(this.index.getBitmapFactoryForDimensions(), virtualColumns, new DeprecatedQueryableIndexColumnSelector(this.index));
    }
}

