/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.segment.data.ColumnarFloats;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.DecompressingByteBufferObjectStrategy;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;

public class BlockLayoutColumnarFloatsSupplier
implements Supplier<ColumnarFloats> {
    private final GenericIndexed<ResourceHolder<ByteBuffer>> baseFloatBuffers;
    private final int totalSize;
    private final int sizePer;

    public BlockLayoutColumnarFloatsSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder byteOrder, CompressionStrategy strategy) {
        this.baseFloatBuffers = GenericIndexed.read(fromBuffer, new DecompressingByteBufferObjectStrategy(byteOrder, strategy));
        this.totalSize = totalSize;
        this.sizePer = sizePer;
    }

    public ColumnarFloats get() {
        boolean isPowerOf2;
        final int div = Integer.numberOfTrailingZeros(this.sizePer);
        final int rem = this.sizePer - 1;
        boolean bl = isPowerOf2 = this.sizePer == 1 << div;
        if (isPowerOf2) {
            return new BlockLayoutColumnarFloats(){

                @Override
                public float get(int index) {
                    int bufferNum = index >> div;
                    if (bufferNum != this.currBufferNum) {
                        this.loadBuffer(bufferNum);
                    }
                    int bufferIndex = index & rem;
                    return this.floatBuffer.get(bufferIndex);
                }
            };
        }
        return new BlockLayoutColumnarFloats();
    }

    private class BlockLayoutColumnarFloats
    implements ColumnarFloats {
        final Indexed<ResourceHolder<ByteBuffer>> singleThreadedFloatBuffers;
        int currBufferNum;
        ResourceHolder<ByteBuffer> holder;
        FloatBuffer floatBuffer;

        private BlockLayoutColumnarFloats() {
            this.singleThreadedFloatBuffers = BlockLayoutColumnarFloatsSupplier.this.baseFloatBuffers.singleThreaded();
            this.currBufferNum = -1;
        }

        @Override
        public int size() {
            return BlockLayoutColumnarFloatsSupplier.this.totalSize;
        }

        @Override
        public float get(int index) {
            int bufferNum = index / BlockLayoutColumnarFloatsSupplier.this.sizePer;
            int bufferIndex = index % BlockLayoutColumnarFloatsSupplier.this.sizePer;
            if (bufferNum != this.currBufferNum) {
                this.loadBuffer(bufferNum);
            }
            return this.floatBuffer.get(bufferIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void get(float[] out, int start, int length) {
            int bufferNum = start / BlockLayoutColumnarFloatsSupplier.this.sizePer;
            int bufferIndex = start % BlockLayoutColumnarFloatsSupplier.this.sizePer;
            int p = 0;
            while (p < length) {
                if (bufferNum != this.currBufferNum) {
                    this.loadBuffer(bufferNum);
                }
                int limit = Math.min(length - p, BlockLayoutColumnarFloatsSupplier.this.sizePer - bufferIndex);
                int oldPosition = this.floatBuffer.position();
                try {
                    this.floatBuffer.position(bufferIndex);
                    this.floatBuffer.get(out, p, limit);
                }
                finally {
                    this.floatBuffer.position(oldPosition);
                }
                p += limit;
                ++bufferNum;
                bufferIndex = 0;
            }
        }

        @Override
        public void get(float[] out, int[] indexes, int length) {
            int p = 0;
            while (p < length) {
                int index;
                int i;
                int bufferNum = indexes[p] / BlockLayoutColumnarFloatsSupplier.this.sizePer;
                if (bufferNum != this.currBufferNum) {
                    this.loadBuffer(bufferNum);
                }
                int indexOffset = bufferNum * BlockLayoutColumnarFloatsSupplier.this.sizePer;
                for (i = p; i < length && (index = indexes[i] - indexOffset) < BlockLayoutColumnarFloatsSupplier.this.sizePer; ++i) {
                    out[i] = this.floatBuffer.get(index);
                }
                assert (i > p);
                p = i;
            }
        }

        protected void loadBuffer(int bufferNum) {
            if (this.holder != null) {
                this.holder.close();
            }
            this.holder = this.singleThreadedFloatBuffers.get(bufferNum);
            this.floatBuffer = ((ByteBuffer)this.holder.get()).asFloatBuffer();
            this.currBufferNum = bufferNum;
        }

        @Override
        public void close() {
            if (this.holder != null) {
                this.holder.close();
            }
        }

        public String toString() {
            return "BlockCompressedColumnarFloats_Anonymous{currBufferNum=" + this.currBufferNum + ", sizePer=" + BlockLayoutColumnarFloatsSupplier.this.sizePer + ", numChunks=" + this.singleThreadedFloatBuffers.size() + ", totalSize=" + BlockLayoutColumnarFloatsSupplier.this.totalSize + '}';
        }
    }
}

