/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.BooleanVectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.AllTrueBitmapColumnIndex;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class TrueFilter
implements Filter {
    private static final TrueFilter INSTANCE = new TrueFilter();

    public static TrueFilter instance() {
        return INSTANCE;
    }

    private TrueFilter() {
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        return new AllTrueBitmapColumnIndex(selector);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return BooleanValueMatcher.of(true);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return BooleanVectorValueMatcher.of(factory.getReadableVectorInspector(), true);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, ColumnIndexSelector indexSelector) {
        return true;
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return true;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return Collections.emptySet();
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        return this;
    }

    @Override
    public double estimateSelectivity(ColumnIndexSelector indexSelector) {
        return 1.0;
    }

    public String toString() {
        return "true";
    }

    public final int hashCode() {
        return TrueFilter.class.hashCode();
    }

    public final boolean equals(Object obj) {
        return obj instanceof TrueFilter;
    }
}

