/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.Expr;

public class JoinFilterColumnCorrelationAnalysis {
    private final String joinColumn;
    @Nonnull
    private final List<String> baseColumns;
    @Nonnull
    private final List<Expr> baseExpressions;
    private final Map<Pair<String, String>, Optional<Set<String>>> correlatedValuesMap;

    public JoinFilterColumnCorrelationAnalysis(String joinColumn, Set<String> baseColumns, Set<Expr> baseExpressions) {
        this.joinColumn = joinColumn;
        this.baseColumns = new ArrayList<String>(baseColumns);
        this.baseExpressions = new ArrayList<Expr>(baseExpressions);
        this.baseColumns.sort(String.CASE_INSENSITIVE_ORDER);
        this.correlatedValuesMap = new HashMap<Pair<String, String>, Optional<Set<String>>>();
    }

    public String getJoinColumn() {
        return this.joinColumn;
    }

    @Nonnull
    public List<String> getBaseColumns() {
        return this.baseColumns;
    }

    @Nonnull
    public List<Expr> getBaseExpressions() {
        return this.baseExpressions;
    }

    public Map<Pair<String, String>, Optional<Set<String>>> getCorrelatedValuesMap() {
        return this.correlatedValuesMap;
    }

    public boolean supportsPushDown() {
        return !this.baseColumns.isEmpty() || !this.baseExpressions.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinFilterColumnCorrelationAnalysis that = (JoinFilterColumnCorrelationAnalysis)o;
        return Objects.equals(this.joinColumn, that.joinColumn) && this.baseColumns.equals(that.baseColumns) && this.baseExpressions.equals(that.baseExpressions) && Objects.equals(this.correlatedValuesMap, that.correlatedValuesMap);
    }

    public int hashCode() {
        return Objects.hash(this.joinColumn, this.baseColumns, this.baseExpressions, this.correlatedValuesMap);
    }
}

