/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableJoinMatcher;
import org.apache.druid.segment.join.table.RowBasedIndexBuilder;

public class RowBasedIndexedTable<RowType>
implements IndexedTable {
    private final List<RowType> table;
    private final List<IndexedTable.Index> indexes;
    private final RowSignature rowSignature;
    private final List<Function<RowType, Object>> columnFunctions;
    private final Set<String> keyColumns;
    private final String version;
    @Nullable
    private final byte[] cacheKey;

    public RowBasedIndexedTable(List<RowType> table, RowAdapter<RowType> rowAdapter, RowSignature rowSignature, Set<String> keyColumns, String version) {
        this(table, rowAdapter, rowSignature, keyColumns, version, null);
    }

    public RowBasedIndexedTable(List<RowType> table, RowAdapter<RowType> rowAdapter, RowSignature rowSignature, Set<String> keyColumns, String version, @Nullable byte[] cacheKey) {
        this.table = table;
        this.rowSignature = rowSignature;
        this.columnFunctions = rowSignature.getColumnNames().stream().map(rowAdapter::columnFunction).collect(Collectors.toList());
        this.keyColumns = keyColumns;
        this.version = version;
        this.cacheKey = cacheKey;
        if (!ImmutableSet.copyOf(rowSignature.getColumnNames()).containsAll(keyColumns)) {
            throw new ISE("keyColumns[%s] must all be contained in rowSignature[%s]", new Object[]{String.join((CharSequence)", ", keyColumns), rowSignature});
        }
        this.indexes = new ArrayList<IndexedTable.Index>(rowSignature.size());
        for (int i = 0; i < rowSignature.size(); ++i) {
            IndexedTable.Index m;
            String column = rowSignature.getColumnName(i);
            if (keyColumns.contains(column)) {
                ColumnType keyType = rowSignature.getColumnType(column).orElse(IndexedTableJoinMatcher.DEFAULT_KEY_TYPE);
                RowBasedIndexBuilder builder = new RowBasedIndexBuilder(keyType);
                Function<RowType, Object> columnFunction = this.columnFunctions.get(i);
                for (RowType row : table) {
                    builder.add(columnFunction.apply(row));
                }
                m = builder.build();
            } else {
                m = null;
            }
            this.indexes.add(m);
        }
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public Set<String> keyColumns() {
        return this.keyColumns;
    }

    @Override
    public RowSignature rowSignature() {
        return this.rowSignature;
    }

    @Override
    public IndexedTable.Index columnIndex(int column) {
        return RowBasedIndexedTable.getKeyColumnIndex(column, this.indexes);
    }

    @Override
    public IndexedTable.Reader columnReader(int column) {
        Function<RowType, Object> columnFn = this.columnFunctions.get(column);
        if (columnFn == null) {
            throw new IAE("Column[%d] is not a valid column", new Object[]{column});
        }
        return row -> columnFn.apply(this.table.get(row));
    }

    @Override
    public byte[] computeCacheKey() {
        return (byte[])Preconditions.checkNotNull((Object)this.cacheKey, (Object)"Cache key can't be null");
    }

    @Override
    public boolean isCacheable() {
        return null != this.cacheKey;
    }

    @Override
    public int numRows() {
        return this.table.size();
    }

    @Override
    public Optional<Closeable> acquireReferences() {
        return Optional.of(() -> {});
    }

    @Override
    public void close() {
    }

    static IndexedTable.Index getKeyColumnIndex(int column, List<IndexedTable.Index> indexes) {
        IndexedTable.Index index = indexes.get(column);
        if (index == null) {
            throw new IAE("Column[%d] is not a key column", new Object[]{column});
        }
        return index;
    }
}

