/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class SortedIntIntersectionIterator
implements IntIterator {
    private static final int NIL = -1;
    private final IntIterator[] iterators;
    private final int[] currents;
    private int next = -1;

    SortedIntIntersectionIterator(IntIterator[] iterators) {
        Preconditions.checkArgument((iterators.length > 0 ? 1 : 0) != 0, (Object)"iterators.length > 0");
        this.iterators = iterators;
        this.currents = new int[iterators.length];
        Arrays.fill(this.currents, -1);
        this.advance();
    }

    public int nextInt() {
        if (this.next == -1) {
            throw new NoSuchElementException();
        }
        int retVal = this.next;
        this.advance();
        return retVal;
    }

    public boolean hasNext() {
        return this.next != -1;
    }

    private void advance() {
        ++this.next;
        boolean foundNext = false;
        while (!foundNext) {
            foundNext = true;
            for (int i = 0; i < this.iterators.length; ++i) {
                while (this.currents[i] < this.next && this.iterators[i].hasNext()) {
                    this.currents[i] = this.iterators[i].nextInt();
                }
                if (this.currents[i] < this.next && !this.iterators[i].hasNext()) {
                    this.next = -1;
                    return;
                }
                if (this.currents[i] <= this.next) continue;
                this.next = this.currents[i];
                foundNext = false;
            }
        }
        assert (Arrays.stream(this.currents).allMatch(x -> x == this.next));
    }
}

