/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;

public class StructuredData
implements Comparable<StructuredData> {
    private static final XXHash64 HASH_FUNCTION = XXHashFactory.fastestInstance().hash64();
    private static int SEED = -1756908916;
    public static final Comparator<StructuredData> COMPARATOR = Comparators.naturalNullsFirst();
    private final Object value;
    private volatile boolean hashInitialized = false;
    private volatile long hashValue;
    private final LongSupplier hash = () -> {
        if (!this.hashInitialized) {
            this.hashValue = StructuredData.computeHash(this);
            this.hashInitialized = true;
        }
        return this.hashValue;
    };

    private static long computeHash(StructuredData data) {
        try {
            byte[] bytes = NestedDataComplexTypeSerde.OBJECT_MAPPER.writeValueAsBytes(data.value);
            return HASH_FUNCTION.hash(bytes, 0, bytes.length, (long)SEED);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static StructuredData wrap(@Nullable Object value) {
        if (value == null || value instanceof StructuredData) {
            return (StructuredData)value;
        }
        return new StructuredData(value);
    }

    @Nullable
    public static Object unwrap(@Nullable Object value) {
        if (value instanceof StructuredData) {
            return ((StructuredData)value).getValue();
        }
        return value;
    }

    @JsonCreator
    public static StructuredData create(Object value) {
        return new StructuredData(value);
    }

    public StructuredData(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    private boolean isNull() {
        return this.value == null;
    }

    private boolean isString() {
        return this.value instanceof String;
    }

    private boolean isNumber() {
        return this.value instanceof Number;
    }

    private String asString() {
        return (String)this.value;
    }

    private Number asNumber() {
        return (Number)this.value;
    }

    @Override
    public int compareTo(StructuredData o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.isNull()) {
            return -1;
        }
        if (o.isNull()) {
            return 1;
        }
        if (this.isString()) {
            if (o.isString()) {
                return TypeStrategies.STRING.compare(this.asString(), o.asString());
            }
            return -1;
        }
        if (o.isString()) {
            return 1;
        }
        if (this.isNumber()) {
            if (o.isNumber()) {
                return TypeStrategies.DOUBLE.compare(Double.valueOf(this.asNumber().doubleValue()), Double.valueOf(o.asNumber().doubleValue()));
            }
            return -1;
        }
        if (o.isNumber()) {
            return 1;
        }
        return Long.compare(this.hash.getAsLong(), o.hash.getAsLong());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructuredData that = (StructuredData)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "StructuredData{value=" + this.value + '}';
    }
}

