/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.frame.key.KeyTestUtils;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.key.RowKeyComparator;
import org.apache.druid.frame.key.SortColumn;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class RowKeyComparatorTest
extends InitializedNullHandlingTest {
    static final RowSignature SIGNATURE = RowSignature.builder().add("1", ColumnType.LONG).add("2", ColumnType.STRING).add("3", ColumnType.LONG).add("4", ColumnType.DOUBLE).build();
    private static final Object[] OBJECTS1 = new Object[]{-1L, "foo", 2L, -1.2};
    private static final Object[] OBJECTS2 = new Object[]{-1L, null, 2L, 1.2};
    private static final Object[] OBJECTS3 = new Object[]{-1L, "bar", 2L, 1.2};
    private static final Object[] OBJECTS4 = new Object[]{-1L, "foo", 2L, 1.2};
    private static final Object[] OBJECTS5 = new Object[]{-1L, "foo", 3L, 1.2};
    private static final Object[] OBJECTS6 = new Object[]{-1L, "foo", 2L, 1.3};
    private static final Object[] OBJECTS7 = new Object[]{1L, "foo", 2L, -1.2};
    static final List<Object[]> ALL_KEY_OBJECTS = Arrays.asList(OBJECTS1, OBJECTS2, OBJECTS3, OBJECTS4, OBJECTS5, OBJECTS6, OBJECTS7);

    @Test
    public void test_compare_AAAA() {
        ImmutableList sortColumns = ImmutableList.of((Object)new SortColumn("1", true), (Object)new SortColumn("2", true), (Object)new SortColumn("3", true), (Object)new SortColumn("4", true));
        Assert.assertEquals(this.sortUsingObjectComparator((List<SortColumn>)sortColumns, ALL_KEY_OBJECTS), this.sortUsingKeyComparator((List<SortColumn>)sortColumns, ALL_KEY_OBJECTS));
    }

    @Test
    public void test_compare_DDDD() {
        ImmutableList sortColumns = ImmutableList.of((Object)new SortColumn("1", false), (Object)new SortColumn("2", false), (Object)new SortColumn("3", false), (Object)new SortColumn("4", false));
        Assert.assertEquals(this.sortUsingObjectComparator((List<SortColumn>)sortColumns, ALL_KEY_OBJECTS), this.sortUsingKeyComparator((List<SortColumn>)sortColumns, ALL_KEY_OBJECTS));
    }

    @Test
    public void test_compare_DAAD() {
        ImmutableList sortColumns = ImmutableList.of((Object)new SortColumn("1", false), (Object)new SortColumn("2", true), (Object)new SortColumn("3", true), (Object)new SortColumn("4", false));
        Assert.assertEquals(this.sortUsingObjectComparator((List<SortColumn>)sortColumns, ALL_KEY_OBJECTS), this.sortUsingKeyComparator((List<SortColumn>)sortColumns, ALL_KEY_OBJECTS));
    }

    @Test
    public void test_compare_ADDA() {
        ImmutableList sortColumns = ImmutableList.of((Object)new SortColumn("1", true), (Object)new SortColumn("2", false), (Object)new SortColumn("3", false), (Object)new SortColumn("4", true));
        Assert.assertEquals(this.sortUsingObjectComparator((List<SortColumn>)sortColumns, ALL_KEY_OBJECTS), this.sortUsingKeyComparator((List<SortColumn>)sortColumns, ALL_KEY_OBJECTS));
    }

    @Test
    public void test_compare_DADA() {
        ImmutableList sortColumns = ImmutableList.of((Object)new SortColumn("1", true), (Object)new SortColumn("2", false), (Object)new SortColumn("3", true), (Object)new SortColumn("4", false));
        Assert.assertEquals(this.sortUsingObjectComparator((List<SortColumn>)sortColumns, ALL_KEY_OBJECTS), this.sortUsingKeyComparator((List<SortColumn>)sortColumns, ALL_KEY_OBJECTS));
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(RowKeyComparator.class).withNonnullFields(new String[]{"byteRowKeyComparatorDelegate"}).usingGetClass().verify();
    }

    private List<RowKey> sortUsingKeyComparator(List<SortColumn> sortColumns, List<Object[]> objectss) {
        ArrayList<RowKey> sortedKeys = new ArrayList<RowKey>();
        for (Object[] objects : objectss) {
            sortedKeys.add(KeyTestUtils.createKey(SIGNATURE, objects));
        }
        sortedKeys.sort((Comparator<RowKey>)RowKeyComparator.create(sortColumns));
        return sortedKeys;
    }

    private List<RowKey> sortUsingObjectComparator(List<SortColumn> sortColumns, List<Object[]> objectss) {
        List sortedObjectssCopy = objectss.stream().sorted((o1, o2) -> {
            for (int i = 0; i < sortColumns.size(); ++i) {
                SortColumn sortColumn = (SortColumn)sortColumns.get(i);
                int cmp = Comparators.naturalNullsFirst().compare((Object)((Comparable)o1[i]), (Object)((Comparable)o2[i]));
                if (cmp == 0) continue;
                return sortColumn.descending() ? -cmp : cmp;
            }
            return 0;
        }).collect(Collectors.toList());
        ArrayList<RowKey> sortedKeys = new ArrayList<RowKey>();
        for (Object[] objects : sortedObjectssCopy) {
            sortedKeys.add(KeyTestUtils.createKey(SIGNATURE, objects));
        }
        return sortedKeys;
    }
}

