/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.key.KeyTestUtils;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.key.RowKeyReader;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class RowKeyReaderTest
extends InitializedNullHandlingTest {
    private final RowSignature signature = RowSignature.builder().add("long", ColumnType.LONG).add("longDefault", ColumnType.LONG).add("float", ColumnType.FLOAT).add("floatDefault", ColumnType.FLOAT).add("string", ColumnType.STRING).add("stringNull", ColumnType.STRING).add("multiValueString", ColumnType.STRING).add("double", ColumnType.DOUBLE).add("doubleDefault", ColumnType.DOUBLE).add("stringArray", ColumnType.STRING_ARRAY).build();
    private final List<Object> objects = Arrays.asList(5L, NullHandling.defaultLongValue(), Float.valueOf(6.0f), NullHandling.defaultFloatValue(), "foo", null, Arrays.asList("bar", "qux"), 7.0, NullHandling.defaultDoubleValue(), Arrays.asList("abc", "xyz"));
    private final RowKey key = KeyTestUtils.createKey(this.signature, this.objects.toArray());
    private final RowKeyReader keyReader = RowKeyReader.create((RowSignature)this.signature);

    @Test
    public void test_read_all() {
        Assert.assertEquals(this.objects, (Object)this.keyReader.read(this.key));
    }

    @Test
    public void test_read_oneField() {
        for (int i = 0; i < this.signature.size(); ++i) {
            Assert.assertEquals((String)("read: " + this.signature.getColumnName(i)), (Object)this.objects.get(i), (Object)this.keyReader.read(this.key, i));
        }
    }

    @Test
    public void test_hasMultipleValues() {
        for (int i = 0; i < this.signature.size(); ++i) {
            Assert.assertEquals((String)("hasMultipleValues: " + this.signature.getColumnName(i)), (Object)(this.objects.get(i) instanceof List), (Object)this.keyReader.hasMultipleValues(this.key, i));
        }
    }

    @Test
    public void test_trim_zero() {
        Assert.assertEquals((Object)RowKey.empty(), (Object)this.keyReader.trim(this.key, 0));
    }

    @Test
    public void test_trim_one() {
        Assert.assertEquals((Object)KeyTestUtils.createKey(RowSignature.builder().add(this.signature.getColumnName(0), (ColumnType)this.signature.getColumnType(0).get()).build(), this.objects.get(0)), (Object)this.keyReader.trim(this.key, 1));
    }

    @Test
    public void test_trim_oneLessThanFullLength() {
        int numFields = this.signature.size() - 1;
        RowSignature.Builder trimmedSignature = RowSignature.builder();
        IntStream.range(0, numFields).forEach(i -> trimmedSignature.add(this.signature.getColumnName(i), (ColumnType)this.signature.getColumnType(i).get()));
        Assert.assertEquals((Object)KeyTestUtils.createKey(trimmedSignature.build(), this.objects.subList(0, numFields).toArray()), (Object)this.keyReader.trim(this.key, numFields));
    }

    @Test
    public void test_trim_fullLength() {
        Assert.assertEquals((Object)this.key, (Object)this.keyReader.trim(this.key, this.signature.size()));
    }

    @Test
    public void test_trim_beyondFullLength() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.keyReader.trim(this.key, this.signature.size() + 1));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Cannot trim")));
    }

    @Test
    public void test_trimmedKeyReader_zero() {
        RowKey trimmedKey = this.keyReader.trim(this.key, 0);
        RowKeyReader trimmedKeyReader = this.keyReader.trimmedKeyReader(0);
        Assert.assertEquals(Collections.emptyList(), (Object)trimmedKeyReader.read(trimmedKey));
    }

    @Test
    public void test_trimmedKeyReader_one() {
        RowKey trimmedKey = this.keyReader.trim(this.key, 1);
        RowKeyReader trimmedKeyReader = this.keyReader.trimmedKeyReader(1);
        Assert.assertEquals(this.objects.subList(0, 1), (Object)trimmedKeyReader.read(trimmedKey));
    }

    @Test
    public void test_trimmedKeyReader_oneLessThanFullLength() {
        int numFields = this.signature.size() - 1;
        RowKey trimmedKey = this.keyReader.trim(this.key, numFields);
        RowKeyReader trimmedKeyReader = this.keyReader.trimmedKeyReader(numFields);
        Assert.assertEquals(this.objects.subList(0, numFields), (Object)trimmedKeyReader.read(trimmedKey));
    }
}

