/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import org.apache.druid.frame.key.KeyTestUtils;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class RowKeyTest
extends InitializedNullHandlingTest {
    @Test
    public void testEqualsAndHashCode() {
        RowSignature signatureLong = RowSignature.builder().add("1", ColumnType.LONG).build();
        RowSignature signatureLongString = RowSignature.builder().add("1", ColumnType.LONG).add("2", ColumnType.STRING).build();
        Assert.assertNotEquals((Object)"not a key", (Object)KeyTestUtils.createKey(signatureLong, 1L));
        Assert.assertEquals((Object)KeyTestUtils.createKey(signatureLong, 1L), (Object)KeyTestUtils.createKey(signatureLong, 1L));
        Assert.assertEquals((Object)KeyTestUtils.createKey(RowSignature.empty(), new Object[0]), (Object)KeyTestUtils.createKey(RowSignature.empty(), new Object[0]));
        Assert.assertNotEquals((Object)KeyTestUtils.createKey(RowSignature.empty(), new Object[0]), (Object)KeyTestUtils.createKey(signatureLong, 2L));
        Assert.assertNotEquals((Object)KeyTestUtils.createKey(signatureLong, 1L), (Object)KeyTestUtils.createKey(signatureLong, 2L));
        Assert.assertEquals((Object)KeyTestUtils.createKey(signatureLongString, 1L, "abc"), (Object)KeyTestUtils.createKey(signatureLongString, 1L, "abc"));
        Assert.assertNotEquals((Object)KeyTestUtils.createKey(signatureLongString, 1L, "abc"), (Object)KeyTestUtils.createKey(signatureLongString, 1L, "def"));
        Assert.assertEquals((long)KeyTestUtils.createKey(signatureLong, 1L).hashCode(), (long)KeyTestUtils.createKey(signatureLong, 1L).hashCode());
        Assert.assertNotEquals((long)KeyTestUtils.createKey(signatureLong, 1L).hashCode(), (long)KeyTestUtils.createKey(signatureLong, 2L).hashCode());
        Assert.assertEquals((long)KeyTestUtils.createKey(signatureLongString, 1L, "abc").hashCode(), (long)KeyTestUtils.createKey(signatureLongString, 1L, "abc").hashCode());
        Assert.assertNotEquals((long)KeyTestUtils.createKey(signatureLongString, 1L, "abc").hashCode(), (long)KeyTestUtils.createKey(signatureLongString, 1L, "def").hashCode());
    }

    @Test
    public void testGetNumberOfBytes() {
        RowSignature signatureLong = RowSignature.builder().add("1", ColumnType.LONG).build();
        RowKey longKey = KeyTestUtils.createKey(signatureLong, 1L, "abc");
        Assert.assertEquals((long)(24 + longKey.array().length), (long)longKey.estimatedObjectSizeBytes());
        RowSignature signatureLongString = RowSignature.builder().add("1", ColumnType.LONG).add("2", ColumnType.STRING).build();
        RowKey longStringKey = KeyTestUtils.createKey(signatureLongString, 1L, "abc");
        Assert.assertEquals((long)(24 + longStringKey.array().length), (long)longStringKey.estimatedObjectSizeBytes());
    }
}

