/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.testutil;

import org.apache.druid.frame.util.SettableLongVirtualColumn;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.joda.time.DateTime;

public class RowNumberUpdatingCursor
implements Cursor {
    private final Cursor baseCursor;
    private final SettableLongVirtualColumn rowNumberVirtualColumn;

    RowNumberUpdatingCursor(Cursor baseCursor, SettableLongVirtualColumn rowNumberVirtualColumn) {
        this.baseCursor = baseCursor;
        this.rowNumberVirtualColumn = rowNumberVirtualColumn;
    }

    public ColumnSelectorFactory getColumnSelectorFactory() {
        return this.baseCursor.getColumnSelectorFactory();
    }

    public DateTime getTime() {
        return this.baseCursor.getTime();
    }

    public void advance() {
        this.rowNumberVirtualColumn.setValue(this.rowNumberVirtualColumn.getValue() + 1L);
        this.baseCursor.advance();
    }

    public void advanceUninterruptibly() {
        this.rowNumberVirtualColumn.setValue(this.rowNumberVirtualColumn.getValue() + 1L);
        this.baseCursor.advanceUninterruptibly();
    }

    public boolean isDone() {
        return this.baseCursor.isDone();
    }

    public boolean isDoneOrInterrupted() {
        return this.baseCursor.isDoneOrInterrupted();
    }

    public void reset() {
        this.rowNumberVirtualColumn.setValue(0L);
        this.baseCursor.reset();
    }
}

