/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.jackson;

import com.fasterxml.jackson.databind.util.LinkedNode;
import java.util.Properties;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.jackson.JacksonModule;
import org.junit.Assert;
import org.junit.Test;

public class JacksonModuleTest {
    @Test
    public void testNullServiceNameInProperties() {
        JacksonModule module = new JacksonModule();
        this.verifyUnknownServiceName((DefaultObjectMapper)module.jsonMapper(new Properties()));
        this.verifyUnknownServiceName((DefaultObjectMapper)module.smileMapper(new Properties()));
        this.verifyUnknownServiceName((DefaultObjectMapper)module.jsonMapperOnlyNonNullValue(new Properties()));
    }

    @Test
    public void testNullProperties() {
        JacksonModule module = new JacksonModule();
        this.verifyUnknownServiceName((DefaultObjectMapper)module.jsonMapper(null));
        this.verifyUnknownServiceName((DefaultObjectMapper)module.smileMapper(null));
        this.verifyUnknownServiceName((DefaultObjectMapper)module.jsonMapperOnlyNonNullValue(null));
    }

    @Test
    public void testServiceNameInProperties() {
        JacksonModule module = new JacksonModule();
        Properties properties = new Properties();
        properties.setProperty("druid.service", "myService_1");
        this.verifyServiceName((DefaultObjectMapper)module.jsonMapper(properties), "myService_1");
        properties.setProperty("druid.service", "myService_2");
        this.verifyServiceName((DefaultObjectMapper)module.smileMapper(properties), "myService_2");
        properties.setProperty("druid.service", "myService_3");
        this.verifyServiceName((DefaultObjectMapper)module.jsonMapperOnlyNonNullValue(properties), "myService_3");
    }

    private void verifyUnknownServiceName(DefaultObjectMapper objectMapper) {
        this.verifyServiceName(objectMapper, null);
    }

    private void verifyServiceName(DefaultObjectMapper objectMapper, String expectedServiceName) {
        LinkedNode handlers = objectMapper.getDeserializationConfig().getProblemHandlers();
        Assert.assertNull((Object)handlers.next());
        DefaultObjectMapper.DefaultDeserializationProblemHandler handler = (DefaultObjectMapper.DefaultDeserializationProblemHandler)handlers.value();
        Assert.assertEquals((Object)expectedServiceName, (Object)handler.getServiceName());
    }
}

