/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.segment.join.NoopJoinableFactory;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class JoinDataSourceTest {
    public static final JoinableFactoryWrapper NOOP_JOINABLE_FACTORY_WRAPPER = new JoinableFactoryWrapper((JoinableFactory)NoopJoinableFactory.INSTANCE);
    private final TableDataSource fooTable = new TableDataSource("foo");
    private final TableDataSource barTable = new TableDataSource("bar");
    private final LookupDataSource lookylooLookup = new LookupDataSource("lookyloo");
    private final JoinDataSource joinTableToLookup = JoinDataSource.create((DataSource)this.fooTable, (DataSource)this.lookylooLookup, (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), null);
    private final JoinDataSource joinTableToTable = JoinDataSource.create((DataSource)this.fooTable, (DataSource)this.barTable, (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), null);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private JoinableFactoryWrapper joinableFactoryWrapper;

    @Test
    public void test_getTableNames_tableToTable() {
        Assert.assertEquals((Object)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)this.joinTableToTable.getTableNames());
    }

    @Test
    public void test_getTableNames_tableToLookup() {
        Assert.assertEquals(Collections.singleton("foo"), (Object)this.joinTableToLookup.getTableNames());
    }

    @Test
    public void test_getChildren_tableToTable() {
        Assert.assertEquals((Object)ImmutableList.of((Object)this.fooTable, (Object)this.barTable), (Object)this.joinTableToTable.getChildren());
    }

    @Test
    public void test_getChildren_tableToLookup() {
        Assert.assertEquals((Object)ImmutableList.of((Object)this.fooTable, (Object)this.lookylooLookup), (Object)this.joinTableToLookup.getChildren());
    }

    @Test
    public void test_isCacheable_tableToTable() {
        Assert.assertTrue((boolean)this.joinTableToTable.isCacheable(true));
        Assert.assertTrue((boolean)this.joinTableToTable.isCacheable(false));
    }

    @Test
    public void test_isCacheable_lookup() {
        Assert.assertFalse((boolean)this.joinTableToLookup.isCacheable(true));
        Assert.assertFalse((boolean)this.joinTableToLookup.isCacheable(false));
    }

    @Test
    public void test_isConcrete_tableToTable() {
        Assert.assertFalse((boolean)this.joinTableToTable.isConcrete());
    }

    @Test
    public void test_isConcrete_tableToLookup() {
        Assert.assertFalse((boolean)this.joinTableToLookup.isConcrete());
    }

    @Test
    public void test_isGlobal_tableToTable() {
        Assert.assertFalse((boolean)this.joinTableToTable.isGlobal());
    }

    @Test
    public void test_isGlobal_tableToLookup() {
        Assert.assertFalse((boolean)this.joinTableToLookup.isGlobal());
    }

    @Test
    public void test_withChildren_empty() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Expected [2] children, got [0]");
        this.joinTableToTable.withChildren(Collections.emptyList());
    }

    @Test
    public void test_withChildren_two() {
        DataSource transformed = this.joinTableToTable.withChildren((List)ImmutableList.of((Object)this.fooTable, (Object)this.lookylooLookup));
        Assert.assertEquals((Object)this.joinTableToLookup, (Object)transformed);
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(JoinDataSource.class).usingGetClass().withNonnullFields(new String[]{"left", "right", "rightPrefix", "conditionAnalysis", "joinType"}).withIgnoredFields(new String[]{"joinableFactoryWrapper", "analysis"}).verify();
    }

    @Test
    public void test_serde() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapperForJoinable(this.joinableFactoryWrapper);
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, (DimFilter)TrueDimFilter.instance(), (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)this.joinableFactoryWrapper);
        JoinDataSource deserialized = (JoinDataSource)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)joinDataSource), DataSource.class);
        Assert.assertEquals((Object)joinDataSource, (Object)deserialized);
    }

    @Test
    public void testException_leftFilterOnNonTableSource() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("left filter is only supported if left data source is direct table access");
        JoinDataSource.create((DataSource)new QueryDataSource((Query)Mockito.mock(Query.class)), (DataSource)new TableDataSource("table"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, (DimFilter)TrueDimFilter.instance(), (ExprMacroTable)ExprMacroTable.nil(), null);
    }

    @Test
    public void testLeftFilter() {
        JoinDataSource dataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, (DimFilter)TrueDimFilter.instance(), (ExprMacroTable)ExprMacroTable.nil(), null);
        Assert.assertEquals((Object)TrueDimFilter.instance(), (Object)dataSource.getLeftFilter());
    }

    @Test
    public void testVirtualColumnCandidates() {
        JoinDataSource dataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), null);
        Assert.assertEquals((Object)dataSource.getVirtualColumnCandidates(), (Object)ImmutableSet.of((Object)"x"));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_noHashJoin() {
        JoinDataSource dataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)NOOP_JOINABLE_FACTORY_WRAPPER);
        Optional<byte[]> cacheKey = Optional.ofNullable(dataSource.getCacheKey());
        Assert.assertTrue((boolean)cacheKey.isPresent());
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_sameKeyForSameJoin() {
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper);
        JoinDataSource joinDataSource1 = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper);
        byte[] cacheKey1 = joinDataSource.getCacheKey();
        byte[] cacheKey2 = joinDataSource1.getCacheKey();
        Assert.assertNotEquals((long)cacheKey1.length, (long)0L);
        Assert.assertNotEquals((long)cacheKey2.length, (long)0L);
        Assert.assertTrue((boolean)Arrays.equals(cacheKey1, cacheKey2));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_keyChangesWithTables() {
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper);
        JoinDataSource joinDataSource1 = JoinDataSource.create((DataSource)new TableDataSource("table11"), (DataSource)new TableDataSource("table12"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper);
        byte[] cacheKey1 = joinDataSource.getCacheKey();
        byte[] cacheKey2 = joinDataSource1.getCacheKey();
        Assert.assertNotEquals((long)cacheKey1.length, (long)0L);
        Assert.assertNotEquals((long)cacheKey2.length, (long)0L);
        Assert.assertFalse((boolean)Arrays.equals(cacheKey1, cacheKey2));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_keyChangesWithExpressions() {
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper);
        JoinDataSource joinDataSource1 = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"y == \"j.y\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper);
        byte[] cacheKey1 = joinDataSource.getCacheKey();
        byte[] cacheKey2 = joinDataSource1.getCacheKey();
        Assert.assertNotEquals((long)cacheKey1.length, (long)0L);
        Assert.assertNotEquals((long)cacheKey2.length, (long)0L);
        Assert.assertFalse((boolean)Arrays.equals(cacheKey1, cacheKey2));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_keyChangesWithJoinType() {
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper);
        JoinDataSource joinDataSource1 = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper);
        byte[] cacheKey1 = joinDataSource.getCacheKey();
        byte[] cacheKey2 = joinDataSource1.getCacheKey();
        Assert.assertNotEquals((long)cacheKey1.length, (long)0L);
        Assert.assertNotEquals((long)cacheKey2.length, (long)0L);
        Assert.assertFalse((boolean)Arrays.equals(cacheKey1, cacheKey2));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_keyChangesWithPrefix() {
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper);
        JoinDataSource joinDataSource1 = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"ab.", (String)"x == \"ab.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper);
        byte[] cacheKey1 = joinDataSource.getCacheKey();
        byte[] cacheKey2 = joinDataSource1.getCacheKey();
        Assert.assertNotEquals((long)cacheKey1.length, (long)0L);
        Assert.assertNotEquals((long)cacheKey2.length, (long)0L);
        Assert.assertFalse((boolean)Arrays.equals(cacheKey1, cacheKey2));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_keyChangesWithBaseFilter() {
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        NullHandling.initializeForTests();
        InDimFilter expectedInDimFilter = new InDimFilter("dimTest", Arrays.asList("good", "bad"), null);
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, (DimFilter)expectedInDimFilter, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper);
        JoinDataSource joinDataSource1 = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper);
        byte[] cacheKey1 = joinDataSource.getCacheKey();
        byte[] cacheKey2 = joinDataSource1.getCacheKey();
        Assert.assertNotEquals((long)cacheKey1.length, (long)0L);
        Assert.assertNotEquals((long)cacheKey2.length, (long)0L);
        Assert.assertFalse((boolean)Arrays.equals(cacheKey1, cacheKey2));
    }

    @Test
    public void test_computeJoinDataSourceCacheKey_cachingUnsupported() {
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)new JoinableFactoryWithCacheKey());
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new LookupDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)joinableFactoryWrapper);
        byte[] cacheKey1 = joinDataSource.getCacheKey();
        Assert.assertEquals((long)cacheKey1.length, (long)0L);
    }

    private static class JoinableFactoryWithCacheKey
    extends NoopJoinableFactory {
        private JoinableFactoryWithCacheKey() {
        }

        public Optional<byte[]> computeJoinCacheKey(DataSource dataSource, JoinConditionAnalysis condition) {
            if (dataSource.isCacheable(false) && condition.canHashJoin()) {
                String tableName = (String)Iterators.getOnlyElement(dataSource.getTableNames().iterator());
                return Optional.of(StringUtils.toUtf8((String)tableName));
            }
            return Optional.empty();
        }
    }
}

