/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.BadQueryContextException;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.TestQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class QueryContextsTest {
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void testDefaultQueryTimeout() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, new HashMap());
        Assert.assertEquals((long)300000L, (long)query.context().getDefaultTimeout());
    }

    @Test
    public void testEmptyQueryTimeout() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, new HashMap());
        Assert.assertEquals((long)300000L, (long)query.context().getTimeout());
        query = Queries.withDefaultTimeout((Query)query, (long)60000L);
        Assert.assertEquals((long)60000L, (long)query.context().getTimeout());
    }

    @Test
    public void testQueryTimeout() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, (Map)ImmutableMap.of((Object)"timeout", (Object)1000));
        Assert.assertEquals((long)1000L, (long)query.context().getTimeout());
        query = Queries.withDefaultTimeout((Query)query, (long)1000000L);
        Assert.assertEquals((long)1000L, (long)query.context().getTimeout());
    }

    @Test
    public void testQueryMaxTimeout() {
        this.exception.expect(BadQueryContextException.class);
        this.exception.expectMessage("Configured timeout = 1000 is more than enforced limit of 100.");
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, (Map)ImmutableMap.of((Object)"timeout", (Object)1000));
        query.context().verifyMaxQueryTimeout(100L);
    }

    @Test
    public void testMaxScatterGatherBytes() {
        this.exception.expect(BadQueryContextException.class);
        this.exception.expectMessage("Configured maxScatterGatherBytes = 1000 is more than enforced limit of 100.");
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, (Map)ImmutableMap.of((Object)"maxScatterGatherBytes", (Object)1000));
        Queries.withMaxScatterGatherBytes((Query)query, (long)100L);
    }

    @Test
    public void testDisableSegmentPruning() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, (Map)ImmutableMap.of((Object)"secondaryPartitionPruning", (Object)false));
        Assert.assertFalse((boolean)query.context().isSecondaryPartitionPruningEnabled());
    }

    @Test
    public void testDefaultSegmentPruning() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, (Map)ImmutableMap.of());
        Assert.assertTrue((boolean)query.context().isSecondaryPartitionPruningEnabled());
    }

    @Test
    public void testDefaultInSubQueryThreshold() {
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)QueryContext.empty().getInSubQueryThreshold());
    }

    @Test
    public void testDefaultPlanTimeBoundarySql() {
        Assert.assertEquals((Object)false, (Object)QueryContext.empty().isTimeBoundaryPlanningEnabled());
    }

    @Test
    public void testGetEnableJoinLeftScanDirect() {
        Assert.assertFalse((boolean)QueryContext.empty().getEnableJoinLeftScanDirect());
        Assert.assertTrue((boolean)QueryContext.of((Map)ImmutableMap.of((Object)"enableJoinLeftTableScanDirect", (Object)true)).getEnableJoinLeftScanDirect());
        Assert.assertFalse((boolean)QueryContext.of((Map)ImmutableMap.of((Object)"enableJoinLeftTableScanDirect", (Object)false)).getEnableJoinLeftScanDirect());
    }

    @Test
    public void testGetBrokerServiceName() {
        HashMap<String, String> queryContext = new HashMap<String, String>();
        Assert.assertNull((Object)QueryContext.of(queryContext).getBrokerServiceName());
        queryContext.put("brokerService", "hotBroker");
        Assert.assertEquals((Object)"hotBroker", (Object)QueryContext.of(queryContext).getBrokerServiceName());
    }

    @Test
    public void testGetBrokerServiceName_withNonStringValue() {
        HashMap<String, Integer> queryContext = new HashMap<String, Integer>();
        queryContext.put("brokerService", 100);
        this.exception.expect(BadQueryContextException.class);
        QueryContext.of(queryContext).getBrokerServiceName();
    }

    @Test
    public void testGetTimeout_withNonNumericValue() {
        HashMap<String, String> queryContext = new HashMap<String, String>();
        queryContext.put("timeout", "2000'");
        this.exception.expect(BadQueryContextException.class);
        new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, queryContext).context().getTimeout();
    }

    @Test
    public void testGetAs() {
        Assert.assertNull((Object)QueryContexts.getAsString((String)"foo", null, null));
        Assert.assertEquals((Object)"default", (Object)QueryContexts.getAsString((String)"foo", null, (String)"default"));
        Assert.assertEquals((Object)"value", (Object)QueryContexts.getAsString((String)"foo", (Object)"value", (String)"default"));
        try {
            QueryContexts.getAsString((String)"foo", (Object)10, null);
            Assert.fail();
        }
        catch (BadQueryContextException badQueryContextException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)QueryContexts.getAsBoolean((String)"foo", null, (boolean)false));
        Assert.assertTrue((boolean)QueryContexts.getAsBoolean((String)"foo", null, (boolean)true));
        Assert.assertTrue((boolean)QueryContexts.getAsBoolean((String)"foo", (Object)"true", (boolean)false));
        Assert.assertTrue((boolean)QueryContexts.getAsBoolean((String)"foo", (Object)true, (boolean)false));
        try {
            QueryContexts.getAsBoolean((String)"foo", (Object)10, (boolean)false);
            Assert.fail();
        }
        catch (BadQueryContextException badQueryContextException) {
            // empty catch block
        }
        Assert.assertEquals((long)10L, (long)QueryContexts.getAsInt((String)"foo", null, (int)10));
        Assert.assertEquals((long)20L, (long)QueryContexts.getAsInt((String)"foo", (Object)"20", (int)10));
        Assert.assertEquals((long)20L, (long)QueryContexts.getAsInt((String)"foo", (Object)20, (int)10));
        Assert.assertEquals((long)20L, (long)QueryContexts.getAsInt((String)"foo", (Object)20L, (int)10));
        Assert.assertEquals((long)20L, (long)QueryContexts.getAsInt((String)"foo", (Object)20.0, (int)10));
        try {
            QueryContexts.getAsInt((String)"foo", (Object)true, (int)20);
            Assert.fail();
        }
        catch (BadQueryContextException badQueryContextException) {
            // empty catch block
        }
        Assert.assertEquals((long)10L, (long)QueryContexts.getAsLong((String)"foo", null, (long)10L));
        Assert.assertEquals((long)20L, (long)QueryContexts.getAsLong((String)"foo", (Object)"20", (long)10L));
        Assert.assertEquals((long)20L, (long)QueryContexts.getAsLong((String)"foo", (Object)20, (long)10L));
        Assert.assertEquals((long)20L, (long)QueryContexts.getAsLong((String)"foo", (Object)20L, (long)10L));
        Assert.assertEquals((long)20L, (long)QueryContexts.getAsLong((String)"foo", (Object)20.0, (long)10L));
        try {
            QueryContexts.getAsLong((String)"foo", (Object)true, (long)20L);
            Assert.fail();
        }
        catch (BadQueryContextException badQueryContextException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAsHumanReadableBytes() {
        Assert.assertEquals((long)new HumanReadableBytes("500M").getBytes(), (long)QueryContexts.getAsHumanReadableBytes((String)"maxOnDiskStorage", (Object)500000000, (HumanReadableBytes)HumanReadableBytes.ZERO).getBytes());
        Assert.assertEquals((long)new HumanReadableBytes("500M").getBytes(), (long)QueryContexts.getAsHumanReadableBytes((String)"maxOnDiskStorage", (Object)"500000000", (HumanReadableBytes)HumanReadableBytes.ZERO).getBytes());
        Assert.assertEquals((long)new HumanReadableBytes("500M").getBytes(), (long)QueryContexts.getAsHumanReadableBytes((String)"maxOnDiskStorage", (Object)"500M", (HumanReadableBytes)HumanReadableBytes.ZERO).getBytes());
    }

    @Test
    public void testGetEnum() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, (Map)ImmutableMap.of((Object)"e1", (Object)"FORCE", (Object)"e2", (Object)"INVALID_ENUM"));
        Assert.assertEquals((Object)QueryContexts.Vectorize.FORCE, (Object)query.context().getEnum("e1", QueryContexts.Vectorize.class, (Enum)QueryContexts.Vectorize.FALSE));
        Assert.assertThrows(BadQueryContextException.class, () -> QueryContextsTest.lambda$testGetEnum$0((Query)query));
    }

    private static /* synthetic */ void lambda$testGetEnum$0(Query query) throws Throwable {
        QueryContexts.Vectorize cfr_ignored_0 = (QueryContexts.Vectorize)query.context().getEnum("e2", QueryContexts.Vectorize.class, (Enum)QueryContexts.Vectorize.FALSE);
    }
}

