/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.SerializablePairLongStringDeltaEncodedStagedSerde;
import org.apache.druid.segment.serde.cell.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;

public class SerializablePairLongStringDeltaEncodedStagedSerdeTest {
    private static final SerializablePairLongStringDeltaEncodedStagedSerde INTEGER_SERDE = new SerializablePairLongStringDeltaEncodedStagedSerde(0L, true);
    private static final SerializablePairLongStringDeltaEncodedStagedSerde LONG_SERDE = new SerializablePairLongStringDeltaEncodedStagedSerde(0L, false);
    private final RandomStringUtils randomStringUtils = new RandomStringUtils();

    @Test
    public void testNull() {
        SerializablePairLongStringDeltaEncodedStagedSerdeTest.assertValueEquals(null, 0, INTEGER_SERDE);
    }

    @Test
    public void testSimpleInteger() {
        SerializablePairLongStringDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongString(Long.valueOf(100L), "fuu"), 11, INTEGER_SERDE);
    }

    @Test
    public void testNullStringInteger() {
        SerializablePairLongStringDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongString(Long.valueOf(100L), null), 8, INTEGER_SERDE);
    }

    @Test
    public void testLargeStringInteger() {
        SerializablePairLongStringDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongString(Long.valueOf(100L), this.randomStringUtils.randomAlphanumeric(0x100000)), 0x100008, INTEGER_SERDE);
    }

    @Test
    public void testSimpleLong() {
        SerializablePairLongStringDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongString(Long.valueOf(100L), "fuu"), 15, LONG_SERDE);
    }

    @Test
    public void testNullStringLong() {
        SerializablePairLongStringDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongString(Long.valueOf(100L), null), 12, LONG_SERDE);
    }

    @Test
    public void testLargeStringLong() {
        SerializablePairLongStringDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongString(Long.valueOf(100L), this.randomStringUtils.randomAlphanumeric(0xA00000)), 0xA0000C, LONG_SERDE);
    }

    private static void assertValueEquals(@Nullable SerializablePairLongString value, int size, SerializablePairLongStringDeltaEncodedStagedSerde serde) {
        byte[] bytes = serde.serialize((Object)value);
        Assert.assertEquals((long)size, (long)bytes.length);
        SerializablePairLongString deserialized = (SerializablePairLongString)serde.deserialize(bytes);
        Assert.assertEquals((Object)value, (Object)deserialized);
    }
}

