/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.util.Random;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.SerializablePairLongStringSimpleStagedSerde;
import org.apache.druid.segment.serde.cell.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;

public class SerializablePairLongStringSimpleStagedSerdeTest {
    private static final SerializablePairLongStringSimpleStagedSerde SERDE = new SerializablePairLongStringSimpleStagedSerde();
    private final RandomStringUtils randomStringUtils = new RandomStringUtils(new Random(0L));

    @Test
    public void testSimple() {
        SerializablePairLongStringSimpleStagedSerdeTest.assertValueEquals(new SerializablePairLongString(Long.valueOf(Long.MAX_VALUE), "fuu"), 15);
    }

    @Test
    public void testNull() {
        SerializablePairLongStringSimpleStagedSerdeTest.assertValueEquals(null, 0);
    }

    @Test
    public void testNullString() {
        SerializablePairLongStringSimpleStagedSerdeTest.assertValueEquals(new SerializablePairLongString(Long.valueOf(Long.MAX_VALUE), null), 12);
    }

    @Test
    public void testLargeString() {
        SerializablePairLongStringSimpleStagedSerdeTest.assertValueEquals(new SerializablePairLongString(Long.valueOf(Long.MAX_VALUE), this.randomStringUtils.randomAlphanumeric(0x100000)), 0x10000C);
    }

    private static void assertValueEquals(@Nullable SerializablePairLongString value, int size) {
        byte[] bytes = SERDE.serialize((Object)value);
        Assert.assertEquals((long)size, (long)bytes.length);
        SerializablePairLongString deserialized = (SerializablePairLongString)SERDE.deserialize(bytes);
        Assert.assertEquals((Object)value, (Object)deserialized);
    }
}

