/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.TestFloatColumnSelector;
import org.apache.druid.query.aggregation.TestLongColumnSelector;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.last.FloatLastAggregatorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FloatLastAggregationTest
extends InitializedNullHandlingTest {
    private FloatLastAggregatorFactory floatLastAggregatorFactory;
    private FloatLastAggregatorFactory combiningAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestLongColumnSelector timeSelector;
    private TestLongColumnSelector customTimeSelector;
    private TestFloatColumnSelector valueSelector;
    private TestObjectColumnSelector objectSelector;
    private float[] floats = new float[]{1.1897f, 0.001f, 86.23f, 166.228f};
    private long[] times = new long[]{8224L, 6879L, 2436L, 7888L};
    private long[] customTimes = new long[]{1L, 4L, 3L, 2L};
    private SerializablePair[] pairs = new SerializablePair[]{new SerializablePair((Object)52782L, (Object)Float.valueOf(134.3f)), new SerializablePair((Object)65492L, (Object)Float.valueOf(1232.212f)), new SerializablePair((Object)69134L, (Object)Float.valueOf(18.1233f)), new SerializablePair((Object)11111L, (Object)Float.valueOf(233.5232f))};

    @Before
    public void setup() {
        this.floatLastAggregatorFactory = new FloatLastAggregatorFactory("billy", "nilly", null);
        this.combiningAggFactory = (FloatLastAggregatorFactory)this.floatLastAggregatorFactory.getCombiningFactory();
        this.timeSelector = new TestLongColumnSelector(this.times);
        this.customTimeSelector = new TestLongColumnSelector(this.customTimes);
        this.valueSelector = new TestFloatColumnSelector(this.floats);
        this.objectSelector = new TestObjectColumnSelector<SerializablePair>(this.pairs);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("__time")).andReturn((Object)this.timeSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("customTime")).andReturn((Object)this.customTimeSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn((Object)this.valueSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("billy")).andReturn((Object)this.objectSelector);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testFloatLastAggregator() {
        Aggregator agg = this.floatLastAggregatorFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        Assert.assertEquals((long)this.times[0], (long)((Long)result.lhs));
        Assert.assertEquals((double)this.floats[0], (double)((Float)result.rhs).floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.floats[0]), (long)agg.getLong());
        Assert.assertEquals((double)this.floats[0], (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testFloatLastAggregatorWithTimeColumn() {
        Aggregator agg = new FloatLastAggregatorFactory("billy", "nilly", "customTime").factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        Assert.assertEquals((long)this.customTimes[1], (long)((Long)result.lhs));
        Assert.assertEquals((double)this.floats[1], (double)((Float)result.rhs).floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.floats[1]), (long)agg.getLong());
        Assert.assertEquals((double)this.floats[1], (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testFloatLastBufferAggregator() {
        BufferAggregator agg = this.floatLastAggregatorFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.floatLastAggregatorFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        Assert.assertEquals((long)this.times[0], (long)((Long)result.lhs));
        Assert.assertEquals((double)this.floats[0], (double)((Float)result.rhs).floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.floats[0]), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.floats[0], (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testFloatLastBufferAggregatorWithTimeColumn() {
        BufferAggregator agg = new FloatLastAggregatorFactory("billy", "nilly", "customTime").factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.floatLastAggregatorFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        Assert.assertEquals((long)this.customTimes[1], (long)((Long)result.lhs));
        Assert.assertEquals((double)this.floats[1], (double)((Float)result.rhs).floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.floats[1]), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.floats[1], (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testCombine() {
        SerializablePair pair1 = new SerializablePair((Object)1467225000L, (Object)Float.valueOf(3.621f));
        SerializablePair pair2 = new SerializablePair((Object)1467240000L, (Object)Float.valueOf(785.4f));
        Assert.assertEquals((Object)pair2, (Object)this.floatLastAggregatorFactory.combine((Object)pair1, (Object)pair2));
    }

    @Test
    public void testComparatorWithNulls() {
        SerializablePair pair1 = new SerializablePair((Object)1467225000L, (Object)Float.valueOf(3.621f));
        SerializablePair pair2 = new SerializablePair((Object)1467240000L, null);
        Comparator comparator = this.floatLastAggregatorFactory.getComparator();
        Assert.assertEquals((long)1L, (long)comparator.compare(pair1, pair2));
        Assert.assertEquals((long)0L, (long)comparator.compare(pair1, pair1));
        Assert.assertEquals((long)0L, (long)comparator.compare(pair2, pair2));
        Assert.assertEquals((long)-1L, (long)comparator.compare(pair2, pair1));
    }

    @Test
    public void testFloatLastCombiningAggregator() {
        Aggregator agg = this.combiningAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        SerializablePair expected = this.pairs[2];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((double)((Float)expected.rhs).floatValue(), (double)((Float)result.rhs).floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)((Float)expected.rhs).longValue(), (long)agg.getLong());
        Assert.assertEquals((double)((Float)expected.rhs).floatValue(), (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testFloatLastCombiningBufferAggregator() {
        BufferAggregator agg = this.combiningAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.floatLastAggregatorFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        SerializablePair expected = this.pairs[2];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((double)((Float)expected.rhs).floatValue(), (double)((Float)result.rhs).floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)((Float)expected.rhs).longValue(), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)((Float)expected.rhs).floatValue(), (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String floatSpecJson = "{\"type\":\"floatLast\",\"name\":\"billy\",\"fieldName\":\"nilly\"}";
        AggregatorFactory deserialized = (AggregatorFactory)mapper.readValue(floatSpecJson, AggregatorFactory.class);
        Assert.assertEquals((Object)this.floatLastAggregatorFactory, (Object)deserialized);
        Assert.assertArrayEquals((byte[])this.floatLastAggregatorFactory.getCacheKey(), (byte[])deserialized.getCacheKey());
    }

    private void aggregate(Aggregator agg) {
        agg.aggregate();
        this.timeSelector.increment();
        this.customTimeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }

    private void aggregate(BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        this.timeSelector.increment();
        this.customTimeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }
}

