/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.last.StringLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.StringLastVectorAggregator;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class StringLastVectorAggregatorTest
extends InitializedNullHandlingTest {
    private static final double EPSILON = 1.0E-5;
    private static final String[] VALUES = new String[]{"a", "b", null, "c"};
    private static final boolean[] NULLS = new boolean[]{false, false, true, false};
    private static final String NAME = "NAME";
    private static final String FIELD_NAME = "FIELD_NAME";
    private static final String TIME_COL = "__time";
    private long[] times = new long[]{2436L, 6879L, 7888L, 8224L};
    private long[] timesSame = new long[]{2436L, 2436L};
    private SerializablePairLongString[] pairs = new SerializablePairLongString[]{new SerializablePairLongString(Long.valueOf(2345100L), "last"), new SerializablePairLongString(Long.valueOf(2345001L), "notLast")};
    @Mock
    private VectorObjectSelector selector;
    @Mock
    private VectorObjectSelector selectorForPairs;
    @Mock
    private BaseLongVectorValueSelector timeSelector;
    @Mock
    private BaseLongVectorValueSelector timeSelectorForPairs;
    private ByteBuffer buf;
    private StringLastVectorAggregator target;
    private StringLastVectorAggregator targetWithPairs;
    private StringLastAggregatorFactory stringLastAggregatorFactory;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private VectorColumnSelectorFactory selectorFactory;

    @Before
    public void setup() {
        byte[] randomBytes = new byte[1024];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        this.buf = ByteBuffer.wrap(randomBytes);
        ((VectorObjectSelector)Mockito.doReturn((Object)VALUES).when((Object)this.selector)).getObjectVector();
        ((BaseLongVectorValueSelector)Mockito.doReturn((Object)this.times).when((Object)this.timeSelector)).getLongVector();
        ((BaseLongVectorValueSelector)Mockito.doReturn((Object)this.timesSame).when((Object)this.timeSelectorForPairs)).getLongVector();
        ((VectorObjectSelector)Mockito.doReturn((Object)this.pairs).when((Object)this.selectorForPairs)).getObjectVector();
        this.target = new StringLastVectorAggregator(this.timeSelector, this.selector, 10);
        this.targetWithPairs = new StringLastVectorAggregator(this.timeSelectorForPairs, this.selectorForPairs, 10);
        this.clearBufferForPositions(0, 0);
        ((VectorColumnSelectorFactory)Mockito.doReturn((Object)this.selector).when((Object)this.selectorFactory)).makeObjectSelector(FIELD_NAME);
        ((VectorColumnSelectorFactory)Mockito.doReturn((Object)this.timeSelector).when((Object)this.selectorFactory)).makeValueSelector(TIME_COL);
        this.stringLastAggregatorFactory = new StringLastAggregatorFactory(NAME, FIELD_NAME, TIME_COL, Integer.valueOf(10));
    }

    @Test
    public void testAggregateWithPairs() {
        this.targetWithPairs.aggregate(this.buf, 0, 0, this.pairs.length);
        Pair result = (Pair)this.targetWithPairs.get(this.buf, 0);
        Assert.assertEquals((long)((Long)this.pairs[0].lhs), (long)((Long)result.lhs));
        Assert.assertEquals((Object)this.pairs[0].rhs, (Object)result.rhs);
    }

    @Test
    public void testFactory() {
        Assert.assertTrue((boolean)this.stringLastAggregatorFactory.canVectorize((ColumnInspector)this.selectorFactory));
        VectorAggregator vectorAggregator = this.stringLastAggregatorFactory.factorizeVector(this.selectorFactory);
        Assert.assertNotNull((Object)vectorAggregator);
        Assert.assertEquals(StringLastVectorAggregator.class, vectorAggregator.getClass());
    }

    @Test
    public void initValueShouldBeMinDate() {
        this.target.init(this.buf, 0);
        long initVal = this.buf.getLong(0);
        Assert.assertEquals((long)DateTimes.MIN.getMillis(), (long)initVal);
    }

    @Test
    public void aggregate() {
        this.target.aggregate(this.buf, 0, 0, VALUES.length);
        Pair result = (Pair)this.target.get(this.buf, 0);
        Assert.assertEquals((long)this.times[3], (long)((Long)result.lhs));
        Assert.assertEquals((Object)VALUES[3], (Object)result.rhs);
    }

    @Test
    public void aggregateBatchWithoutRows() {
        int[] positions = new int[]{0, 43, 70};
        int positionOffset = 2;
        this.clearBufferForPositions(positionOffset, positions);
        this.target.aggregate(this.buf, 3, positions, null, positionOffset);
        for (int i = 0; i < positions.length; ++i) {
            Pair result = (Pair)this.target.get(this.buf, positions[i] + positionOffset);
            Assert.assertEquals((long)this.times[i], (long)((Long)result.lhs));
            Assert.assertEquals((Object)VALUES[i], (Object)result.rhs);
        }
    }

    @Test
    public void aggregateBatchWithRows() {
        int[] positions = new int[]{0, 43, 70};
        int[] rows = new int[]{3, 2, 0};
        int positionOffset = 2;
        this.clearBufferForPositions(positionOffset, positions);
        this.target.aggregate(this.buf, 3, positions, rows, positionOffset);
        for (int i = 0; i < positions.length; ++i) {
            Pair result = (Pair)this.target.get(this.buf, positions[i] + positionOffset);
            Assert.assertEquals((long)this.times[rows[i]], (long)((Long)result.lhs));
            Assert.assertEquals((Object)VALUES[rows[i]], (Object)result.rhs);
        }
    }

    private void clearBufferForPositions(int offset, int ... positions) {
        for (int position : positions) {
            this.target.init(this.buf, offset + position);
        }
    }
}

