/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleLists;
import java.util.List;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.expression.ArrayQuantileExprMacro;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class ArrayQuantileExprMacroTest
extends InitializedNullHandlingTest {
    @Test
    public void test_apply_longArray() {
        Expr result = new ArrayQuantileExprMacro().apply((List)ImmutableList.of((Object)ExprEval.ofLongArray((Object[])new Object[]{1L, 3L, 2L}).toExpr(), (Object)ExprEval.ofDouble((Number)0.5).toExpr()));
        Assert.assertEquals((double)2.0, (double)result.eval(InputBindings.nilBindings()).asDouble(), (double)0.0);
    }

    @Test
    public void test_apply_longArrayWithNulls() {
        Expr result = new ArrayQuantileExprMacro().apply((List)ImmutableList.of((Object)ExprEval.ofLongArray((Object[])new Object[]{1L, 3L, null, null, null, 2L}).toExpr(), (Object)ExprEval.ofDouble((Number)0.5).toExpr()));
        Assert.assertEquals((double)2.0, (double)result.eval(InputBindings.nilBindings()).asDouble(), (double)0.0);
    }

    @Test
    public void test_apply_doubleArray() {
        Expr result = new ArrayQuantileExprMacro().apply((List)ImmutableList.of((Object)ExprEval.ofDoubleArray((Object[])new Object[]{1.0, 3.0, 2.0}).toExpr(), (Object)ExprEval.ofDouble((Number)0.5).toExpr()));
        Assert.assertEquals((double)2.0, (double)result.eval(InputBindings.nilBindings()).asDouble(), (double)0.0);
    }

    @Test
    public void test_apply_doubleArrayWithNulls() {
        Expr result = new ArrayQuantileExprMacro().apply((List)ImmutableList.of((Object)ExprEval.ofDoubleArray((Object[])new Object[]{1.0, null, null, null, 3.0, 2.0}).toExpr(), (Object)ExprEval.ofDouble((Number)0.5).toExpr()));
        Assert.assertEquals((double)2.0, (double)result.eval(InputBindings.nilBindings()).asDouble(), (double)0.0);
    }

    @Test
    public void test_apply_stringArray() {
        Expr result = new ArrayQuantileExprMacro().apply((List)ImmutableList.of((Object)ExprEval.ofStringArray((Object[])new Object[]{"1.0", "3.0", "2.0"}).toExpr(), (Object)ExprEval.ofDouble((Number)0.5).toExpr()));
        if (NullHandling.sqlCompatible()) {
            Assert.assertTrue((boolean)result.eval(InputBindings.nilBindings()).isNumericNull());
        } else {
            Assert.assertFalse((boolean)result.eval(InputBindings.nilBindings()).isNumericNull());
            Assert.assertEquals((double)0.0, (double)result.eval(InputBindings.nilBindings()).asDouble(), (double)0.0);
        }
    }

    @Test
    public void test_apply_null() {
        Expr result = new ArrayQuantileExprMacro().apply((List)ImmutableList.of((Object)ExprEval.ofLongArray(null).toExpr(), (Object)ExprEval.ofDouble((Number)0.5).toExpr()));
        if (NullHandling.sqlCompatible()) {
            Assert.assertTrue((boolean)result.eval(InputBindings.nilBindings()).isNumericNull());
        } else {
            Assert.assertFalse((boolean)result.eval(InputBindings.nilBindings()).isNumericNull());
            Assert.assertEquals((double)0.0, (double)result.eval(InputBindings.nilBindings()).asDouble(), (double)0.0);
        }
    }

    @Test
    public void test_quantileFromSortedArray() {
        DoubleList doubles = DoubleList.of((double[])new double[]{1.74894566717352, 2.45877596678213, 6.84501873459025, 18.0554157240096, 18.4655290878664, 21.6757745054299, 28.2750214890592, 29.3815065629455, 31.5177760709153, 35.0717678940787, 35.4433781364011, 36.0028545885968, 38.0293013880748, 38.9119328166599, 39.1044818090053, 41.7399575122699, 44.0979668505793, 44.9745714847969, 69.5289605785605, 74.7768333191133, 77.969554532491, 80.7998322103957, 83.3269645392449, 87.7191508726612, 90.1834351217178, 96.8420215958868});
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)-0.1), (double)1.0E-7);
        Assert.assertEquals((double)1.748945667, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.0), (double)1.0E-7);
        Assert.assertEquals((double)1.748963413, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)1.0E-6), (double)1.0E-7);
        Assert.assertEquals((double)12.45021723, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.1), (double)1.0E-7);
        Assert.assertEquals((double)21.67577451, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.2), (double)1.0E-7);
        Assert.assertEquals((double)30.44964132, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.3), (double)1.0E-7);
        Assert.assertEquals((double)35.44337814, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.4), (double)1.0E-7);
        Assert.assertEquals((double)38.4706171, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.5), (double)1.0E-7);
        Assert.assertEquals((double)41.73995751, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.6), (double)1.0E-7);
        Assert.assertEquals((double)57.25176603, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.7), (double)1.0E-7);
        Assert.assertEquals((double)77.96955453, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.8), (double)1.0E-7);
        Assert.assertEquals((double)85.52305771, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.9), (double)1.0E-7);
        Assert.assertEquals((double)96.84185513, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.999999), (double)1.0E-7);
        Assert.assertEquals((double)96.8420216, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)1.0), (double)1.0E-7);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)1.1), (double)1.0E-7);
    }

    @Test
    public void test_quantileFromSortedArray_singleElement() {
        DoubleList doubles = DoubleList.of((double)1.748945667);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)-0.1), (double)0.0);
        Assert.assertEquals((double)1.748945667, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.0), (double)0.0);
        Assert.assertEquals((double)1.748945667, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)1.0E-6), (double)0.0);
        Assert.assertEquals((double)1.748945667, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.1), (double)0.0);
        Assert.assertEquals((double)1.748945667, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.2), (double)0.0);
        Assert.assertEquals((double)1.748945667, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.3), (double)0.0);
        Assert.assertEquals((double)1.748945667, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.4), (double)0.0);
        Assert.assertEquals((double)1.748945667, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.5), (double)0.0);
        Assert.assertEquals((double)1.748945667, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.6), (double)0.0);
        Assert.assertEquals((double)1.748945667, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.7), (double)0.0);
        Assert.assertEquals((double)1.748945667, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.8), (double)0.0);
        Assert.assertEquals((double)1.748945667, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.9), (double)0.0);
        Assert.assertEquals((double)1.748945667, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.999999), (double)0.0);
        Assert.assertEquals((double)1.748945667, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)1.0), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)1.1), (double)0.0);
    }

    @Test
    public void test_quantileFromSortedArray_noElements() {
        DoubleList doubles = DoubleLists.emptyList();
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)-0.1), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.0), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)1.0E-6), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.1), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.2), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.3), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.4), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.5), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.6), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.7), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.8), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.9), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)0.999999), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)1.0), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)ArrayQuantileExprMacro.quantileFromSortedArray((DoubleList)doubles, (double)1.1), (double)0.0);
    }
}

