/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.BySegmentQueryRunner;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.TestBufferPool;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryEngine;
import org.apache.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.having.GreaterThanHavingSpec;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.groupby.strategy.GroupByStrategySelector;
import org.apache.druid.query.groupby.strategy.GroupByStrategyV1;
import org.apache.druid.query.groupby.strategy.GroupByStrategyV2;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.SegmentId;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GroupByMultiSegmentTest {
    public static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private static final IndexMergerV9 INDEX_MERGER_V9;
    private static final IndexIO INDEX_IO;
    private File tmpDir;
    private QueryRunnerFactory<ResultRow, GroupByQuery> groupByFactory;
    private List<IncrementalIndex> incrementalIndices = new ArrayList<IncrementalIndex>();
    private List<QueryableIndex> groupByIndices = new ArrayList<QueryableIndex>();
    private ExecutorService executorService;
    private Closer resourceCloser;
    public static final QueryWatcher NOOP_QUERYWATCHER;

    private IncrementalIndex makeIncIndex(boolean withRollup) {
        return new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withDimensionsSpec(new DimensionsSpec(Arrays.asList(new StringDimensionSchema("dimA"), new LongDimensionSchema("metA")))).withRollup(withRollup).build()).setConcurrentEventAdd(true).setMaxRowCount(1000).build();
    }

    @Before
    public void setup() throws Exception {
        this.tmpDir = FileUtils.createTempDir();
        List<String> dimNames = Arrays.asList("dimA", "metA");
        IncrementalIndex indexA = this.makeIncIndex(false);
        this.incrementalIndices.add(indexA);
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("dimA", "hello");
        event.put("metA", 100);
        MapBasedInputRow row = new MapBasedInputRow(1000L, dimNames, event);
        indexA.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "world");
        event.put("metA", 75);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexA.add((InputRow)row);
        File fileA = INDEX_MERGER_V9.persist(indexA, new File(this.tmpDir, "A"), new IndexSpec(), null);
        QueryableIndex qindexA = INDEX_IO.loadIndex(fileA);
        IncrementalIndex indexB = this.makeIncIndex(false);
        this.incrementalIndices.add(indexB);
        event = new HashMap();
        event.put("dimA", "foo");
        event.put("metA", 100);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexB.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "world");
        event.put("metA", 75);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexB.add((InputRow)row);
        File fileB = INDEX_MERGER_V9.persist(indexB, new File(this.tmpDir, "B"), new IndexSpec(), null);
        QueryableIndex qindexB = INDEX_IO.loadIndex(fileB);
        this.groupByIndices = Arrays.asList(qindexA, qindexB);
        this.resourceCloser = Closer.create();
        this.setupGroupByFactory();
    }

    private void setupGroupByFactory() {
        this.executorService = Execs.multiThreaded((int)2, (String)"GroupByThreadPool[%d]");
        TestBufferPool bufferPool = TestBufferPool.offHeap(10000000, Integer.MAX_VALUE);
        TestBufferPool mergePool = TestBufferPool.offHeap(10000000, 2);
        this.resourceCloser.register(() -> {
            Assert.assertEquals((long)0L, (long)bufferPool.getOutstandingObjectCount());
            Assert.assertEquals((long)0L, (long)mergePool.getOutstandingObjectCount());
        });
        GroupByQueryConfig config = new GroupByQueryConfig(){

            public String getDefaultStrategy() {
                return "v2";
            }

            public int getBufferGrouperInitialBuckets() {
                return -1;
            }

            public HumanReadableBytes getMaxOnDiskStorage() {
                return HumanReadableBytes.valueOf((long)1000000000L);
            }
        };
        config.setSingleThreaded(false);
        config.setMaxIntermediateRows(Integer.MAX_VALUE);
        config.setMaxResults(Integer.MAX_VALUE);
        DruidProcessingConfig druidProcessingConfig = new DruidProcessingConfig(){

            public int getNumThreads() {
                return 2;
            }

            public String getFormatString() {
                return null;
            }
        };
        Supplier configSupplier = Suppliers.ofInstance((Object)config);
        GroupByStrategySelector strategySelector = new GroupByStrategySelector(configSupplier, new GroupByStrategyV1(configSupplier, new GroupByQueryEngine(configSupplier, (NonBlockingPool)bufferPool), NOOP_QUERYWATCHER), new GroupByStrategyV2(druidProcessingConfig, configSupplier, (NonBlockingPool)bufferPool, (BlockingPool)mergePool, TestHelper.makeJsonMapper(), new ObjectMapper((JsonFactory)new SmileFactory()), NOOP_QUERYWATCHER));
        this.groupByFactory = new GroupByQueryRunnerFactory(strategySelector, new GroupByQueryQueryToolChest(strategySelector));
    }

    @After
    public void tearDown() throws Exception {
        for (IncrementalIndex incrementalIndex : this.incrementalIndices) {
            incrementalIndex.close();
        }
        for (QueryableIndex queryableIndex : this.groupByIndices) {
            queryableIndex.close();
        }
        this.resourceCloser.close();
        if (this.tmpDir != null) {
            FileUtils.deleteDirectory((File)this.tmpDir);
        }
    }

    @Test
    public void testHavingAndNoLimitPushDown() {
        QueryToolChest toolChest = this.groupByFactory.getToolchest();
        FinalizeResultsQueryRunner theRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.groupByFactory.mergeRunners(this.executorService, this.makeGroupByMultiRunners())), toolChest);
        MultipleIntervalSegmentSpec intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.utc((long)0L, (long)1000000L)));
        GroupByQuery query = GroupByQuery.builder().setDataSource("blah").setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimA", null)}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("metA", "metA")}).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("dimA", OrderByColumnSpec.Direction.ASCENDING)), Integer.valueOf(1))).setHavingSpec((HavingSpec)new GreaterThanHavingSpec("metA", (Number)110)).setGranularity(Granularities.ALL).build();
        Sequence queryResult = theRunner.run(QueryPlus.wrap((Query)query), ResponseContext.createEmpty());
        List results = queryResult.toList();
        ResultRow expectedRow = GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970-01-01T00:00:00.000Z", "dimA", "world", "metA", 150L);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)expectedRow, results.get(0));
    }

    private List<QueryRunner<ResultRow>> makeGroupByMultiRunners() {
        ArrayList<QueryRunner<ResultRow>> runners = new ArrayList<QueryRunner<ResultRow>>();
        for (QueryableIndex qindex : this.groupByIndices) {
            QueryRunner<ResultRow> runner = GroupByMultiSegmentTest.makeQueryRunner(this.groupByFactory, SegmentId.dummy((String)qindex.toString()), (Segment)new QueryableIndexSegment(qindex, SegmentId.dummy((String)qindex.toString())));
            runners.add((QueryRunner<ResultRow>)this.groupByFactory.getToolchest().preMergeQueryDecoration(runner));
        }
        return runners;
    }

    public static <T, QueryType extends Query<T>> QueryRunner<T> makeQueryRunner(QueryRunnerFactory<T, QueryType> factory, SegmentId segmentId, Segment adapter) {
        return new FinalizeResultsQueryRunner((QueryRunner)new BySegmentQueryRunner(segmentId, adapter.getDataInterval().getStart(), factory.createRunner(adapter)), factory.getToolchest());
    }

    static {
        JSON_MAPPER.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class, (Object)ExprMacroTable.nil()));
        INDEX_IO = new IndexIO(JSON_MAPPER, new ColumnConfig(){

            public int columnCacheSizeBytes() {
                return 0;
            }
        });
        INDEX_MERGER_V9 = new IndexMergerV9(JSON_MAPPER, INDEX_IO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        NOOP_QUERYWATCHER = new QueryWatcher(){

            public void registerQueryFuture(Query query, ListenableFuture future) {
            }
        };
    }
}

