/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.CloseableDefaultBlockingPool;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryEngine;
import org.apache.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.strategy.GroupByStrategySelector;
import org.apache.druid.query.groupby.strategy.GroupByStrategyV1;
import org.apache.druid.query.groupby.strategy.GroupByStrategyV2;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupByQueryMergeBufferTest
extends InitializedNullHandlingTest {
    private static final long TIMEOUT = 5000L;
    private static final DruidProcessingConfig PROCESSING_CONFIG = new DruidProcessingConfig(){

        public String getFormatString() {
            return null;
        }

        public int intermediateComputeSizeBytes() {
            return 0xA00000;
        }

        public int getNumMergeBuffers() {
            return 4;
        }

        public int getNumThreads() {
            return 1;
        }
    };
    private static final CloseableStupidPool<ByteBuffer> BUFFER_POOL = new CloseableStupidPool("GroupByQueryEngine-bufferPool", () -> ByteBuffer.allocate(PROCESSING_CONFIG.intermediateComputeSizeBytes()));
    private static final TestBlockingPool MERGE_BUFFER_POOL = new TestBlockingPool((Supplier<ByteBuffer>)((Supplier)() -> ByteBuffer.allocate(PROCESSING_CONFIG.intermediateComputeSizeBytes())), PROCESSING_CONFIG.getNumMergeBuffers());
    private static final GroupByQueryRunnerFactory FACTORY = GroupByQueryMergeBufferTest.makeQueryRunnerFactory(GroupByQueryRunnerTest.DEFAULT_MAPPER, new GroupByQueryConfig(){

        public String getDefaultStrategy() {
            return "v2";
        }
    });
    private final QueryRunner<ResultRow> runner;

    private static GroupByQueryRunnerFactory makeQueryRunnerFactory(ObjectMapper mapper, GroupByQueryConfig config) {
        Supplier configSupplier = Suppliers.ofInstance((Object)config);
        GroupByStrategySelector strategySelector = new GroupByStrategySelector(configSupplier, new GroupByStrategyV1(configSupplier, new GroupByQueryEngine(configSupplier, BUFFER_POOL), QueryRunnerTestHelper.NOOP_QUERYWATCHER), new GroupByStrategyV2(PROCESSING_CONFIG, configSupplier, BUFFER_POOL, (BlockingPool)MERGE_BUFFER_POOL, TestHelper.makeJsonMapper(), mapper, QueryRunnerTestHelper.NOOP_QUERYWATCHER));
        GroupByQueryQueryToolChest toolChest = new GroupByQueryQueryToolChest(strategySelector);
        return new GroupByQueryRunnerFactory(strategySelector, toolChest);
    }

    @AfterClass
    public static void teardownClass() {
        BUFFER_POOL.close();
        MERGE_BUFFER_POOL.close();
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> constructorFeeder() {
        ArrayList<Object[]> args = new ArrayList<Object[]>();
        for (QueryRunner runner : QueryRunnerTestHelper.makeQueryRunners(FACTORY)) {
            args.add(new Object[]{runner});
        }
        return args;
    }

    public GroupByQueryMergeBufferTest(QueryRunner<ResultRow> runner) {
        this.runner = FACTORY.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)ImmutableList.of(runner));
    }

    @Before
    public void setup() {
        MERGE_BUFFER_POOL.resetMinRemainBufferNum();
    }

    @Test
    public void testSimpleGroupBy() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")}).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)5000L)).build();
        Assert.assertEquals((long)0L, (long)GroupByStrategyV2.countRequiredMergeBufferNum((GroupByQuery)query));
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)FACTORY, this.runner, query);
        Assert.assertEquals((long)3L, (long)MERGE_BUFFER_POOL.getMinRemainBufferNum());
        Assert.assertEquals((long)4L, (long)MERGE_BUFFER_POOL.getPoolSize());
    }

    @Test
    public void testNestedGroupBy() {
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT)).build())).setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")}).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)5000L)).build();
        Assert.assertEquals((long)1L, (long)GroupByStrategyV2.countRequiredMergeBufferNum((GroupByQuery)query));
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)FACTORY, this.runner, query);
        Assert.assertEquals((long)2L, (long)MERGE_BUFFER_POOL.getMinRemainBufferNum());
        Assert.assertEquals((long)4L, (long)MERGE_BUFFER_POOL.getPoolSize());
    }

    @Test
    public void testDoubleNestedGroupBy() {
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", null)}).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT)).build()).setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT)).build())).setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")}).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)5000L)).build();
        Assert.assertEquals((long)2L, (long)GroupByStrategyV2.countRequiredMergeBufferNum((GroupByQuery)query));
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)FACTORY, this.runner, query);
        Assert.assertEquals((long)1L, (long)MERGE_BUFFER_POOL.getMinRemainBufferNum());
        Assert.assertEquals((long)4L, (long)MERGE_BUFFER_POOL.getPoolSize());
    }

    @Test
    public void testTripleNestedGroupBy() {
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setGranularity(Granularities.ALL).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", null), new DefaultDimensionSpec("placement", null)})).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT)).build()).setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", null)}).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT)).build()).setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT)).build())).setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")}).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)5000L)).build();
        Assert.assertEquals((long)2L, (long)GroupByStrategyV2.countRequiredMergeBufferNum((GroupByQuery)query));
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)FACTORY, this.runner, query);
        Assert.assertEquals((long)1L, (long)MERGE_BUFFER_POOL.getMinRemainBufferNum());
        Assert.assertEquals((long)4L, (long)MERGE_BUFFER_POOL.getPoolSize());
    }

    @Test
    public void testSimpleGroupByWithSubtotals() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setDimensions(Arrays.asList(DefaultDimensionSpec.of((String)"market"), DefaultDimensionSpec.of((String)"placement"), DefaultDimensionSpec.of((String)"quality"))).setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")}).setSubtotalsSpec(Arrays.asList(Arrays.asList("market", "placement"), Arrays.asList("market", "placement", "quality"))).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)5000L)).build();
        Assert.assertEquals((long)1L, (long)GroupByStrategyV2.countRequiredMergeBufferNum((GroupByQuery)query));
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)FACTORY, this.runner, query);
        Assert.assertEquals((long)2L, (long)MERGE_BUFFER_POOL.getMinRemainBufferNum());
        Assert.assertEquals((long)4L, (long)MERGE_BUFFER_POOL.getPoolSize());
    }

    @Test
    public void testSimpleGroupByWithSubtotalsWithoutPrefixMatch() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setDimensions(Arrays.asList(DefaultDimensionSpec.of((String)"market"), DefaultDimensionSpec.of((String)"placement"), DefaultDimensionSpec.of((String)"quality"))).setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")}).setSubtotalsSpec(Arrays.asList(Arrays.asList("market", "placement"), Arrays.asList("market", "quality"))).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)5000L)).build();
        Assert.assertEquals((long)2L, (long)GroupByStrategyV2.countRequiredMergeBufferNum((GroupByQuery)query));
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)FACTORY, this.runner, query);
        Assert.assertEquals((long)1L, (long)MERGE_BUFFER_POOL.getMinRemainBufferNum());
        Assert.assertEquals((long)4L, (long)MERGE_BUFFER_POOL.getPoolSize());
    }

    @Test
    public void testNestedGroupByWithSubtotals() {
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setGranularity(Granularities.ALL).setDimensions(Arrays.asList(DefaultDimensionSpec.of((String)"quality"), DefaultDimensionSpec.of((String)"market"), DefaultDimensionSpec.of((String)"placement"))).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT)).build())).setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(Arrays.asList(DefaultDimensionSpec.of((String)"quality"), DefaultDimensionSpec.of((String)"market"))).setSubtotalsSpec(Arrays.asList(Collections.singletonList("quality"), Collections.singletonList("market"))).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")}).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)5000L)).build();
        Assert.assertEquals((long)3L, (long)GroupByStrategyV2.countRequiredMergeBufferNum((GroupByQuery)query));
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)FACTORY, this.runner, query);
        Assert.assertEquals((long)0L, (long)MERGE_BUFFER_POOL.getMinRemainBufferNum());
        Assert.assertEquals((long)4L, (long)MERGE_BUFFER_POOL.getPoolSize());
    }

    @Test
    public void testNestedGroupByWithNestedSubtotals() {
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setGranularity(Granularities.ALL).setDimensions(Arrays.asList(DefaultDimensionSpec.of((String)"quality"), DefaultDimensionSpec.of((String)"market"), DefaultDimensionSpec.of((String)"placement"))).setSubtotalsSpec(Arrays.asList(Collections.singletonList("quality"), Collections.singletonList("market"))).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.ROWS_COUNT)).build())).setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(Arrays.asList(DefaultDimensionSpec.of((String)"quality"), DefaultDimensionSpec.of((String)"market"))).setSubtotalsSpec(Arrays.asList(Collections.singletonList("quality"), Collections.singletonList("market"))).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")}).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)5000L)).build();
        Assert.assertEquals((long)3L, (long)GroupByStrategyV2.countRequiredMergeBufferNum((GroupByQuery)query));
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)FACTORY, this.runner, query);
        Assert.assertEquals((long)0L, (long)MERGE_BUFFER_POOL.getMinRemainBufferNum());
        Assert.assertEquals((long)4L, (long)MERGE_BUFFER_POOL.getPoolSize());
    }

    private static class TestBlockingPool
    extends CloseableDefaultBlockingPool<ByteBuffer> {
        private int minRemainBufferNum;

        TestBlockingPool(Supplier<ByteBuffer> generator, int limit) {
            super(generator, limit);
            this.minRemainBufferNum = limit;
        }

        public List<ReferenceCountingResourceHolder<ByteBuffer>> takeBatch(int maxElements, long timeout) {
            List holder = super.takeBatch(maxElements, timeout);
            int poolSize = this.getPoolSize();
            if (this.minRemainBufferNum > poolSize) {
                this.minRemainBufferNum = poolSize;
            }
            return holder;
        }

        void resetMinRemainBufferNum() {
            this.minRemainBufferNum = PROCESSING_CONFIG.getNumMergeBuffers();
        }

        int getMinRemainBufferNum() {
            return this.minRemainBufferNum;
        }
    }
}

