/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.guice.DruidSecondaryModule;
import org.apache.druid.guice.GuiceAnnotationIntrospector;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.Result;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.data.ComparableList;
import org.apache.druid.segment.data.ComparableStringArray;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;

public class TestHelper {
    public static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();
    public static final ColumnConfig NO_CACHE_COLUMN_CONFIG = () -> 0;

    public static IndexMergerV9 getTestIndexMergerV9(SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        return new IndexMergerV9(JSON_MAPPER, TestHelper.getTestIndexIO(), segmentWriteOutMediumFactory, true);
    }

    public static IndexIO getTestIndexIO() {
        return TestHelper.getTestIndexIO(NO_CACHE_COLUMN_CONFIG);
    }

    public static IndexIO getTestIndexIO(ColumnConfig columnConfig) {
        return new IndexIO(JSON_MAPPER, columnConfig);
    }

    public static AnnotationIntrospector makeAnnotationIntrospector() {
        return new GuiceAnnotationIntrospector(){

            public Object findInjectableValueId(AnnotatedMember m) {
                return null;
            }
        };
    }

    public static ObjectMapper makeJsonMapper() {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        AnnotationIntrospector introspector = TestHelper.makeAnnotationIntrospector();
        DruidSecondaryModule.setupAnnotationIntrospector((ObjectMapper)mapper, (AnnotationIntrospector)introspector);
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class.getName(), (Object)TestExprMacroTable.INSTANCE).addValue(ObjectMapper.class.getName(), (Object)mapper).addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT));
        return mapper;
    }

    public static ObjectMapper makeJsonMapperForJoinable(JoinableFactoryWrapper joinableFactoryWrapper) {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        AnnotationIntrospector introspector = TestHelper.makeAnnotationIntrospector();
        DruidSecondaryModule.setupAnnotationIntrospector((ObjectMapper)mapper, (AnnotationIntrospector)introspector);
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class.getName(), (Object)TestExprMacroTable.INSTANCE).addValue(ObjectMapper.class.getName(), (Object)mapper).addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT).addValue(JoinableFactoryWrapper.class, (Object)joinableFactoryWrapper));
        return mapper;
    }

    public static ObjectMapper makeSmileMapper() {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        DruidSecondaryModule.setupAnnotationIntrospector((ObjectMapper)mapper, (AnnotationIntrospector)TestHelper.makeAnnotationIntrospector());
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class.getName(), (Object)TestExprMacroTable.INSTANCE).addValue(ObjectMapper.class.getName(), (Object)mapper));
        return mapper;
    }

    public static <T> Iterable<T> revert(Iterable<T> input) {
        return Lists.reverse((List)Lists.newArrayList(input));
    }

    public static <T> void assertExpectedResults(Iterable<Result<T>> expectedResults, Sequence<Result<T>> results) {
        TestHelper.assertResults(expectedResults, results.toList(), "");
    }

    public static <T> void assertExpectedResults(Iterable<Result<T>> expectedResults, Iterable<Result<T>> results) {
        TestHelper.assertResults(expectedResults, results, "");
    }

    public static <T> void assertExpectedResults(Iterable<Result<T>> expectedResults, Iterable<Result<T>> results, String failMsg) {
        TestHelper.assertResults(expectedResults, results, failMsg);
    }

    public static <T> void assertExpectedObjects(Iterable<T> expectedResults, Iterable<T> results, String failMsg) {
        TestHelper.assertObjects(expectedResults, results, failMsg);
    }

    public static <T> void assertExpectedObjects(Iterable<T> expectedResults, Sequence<T> results, String failMsg) {
        TestHelper.assertObjects(expectedResults, results.toList(), failMsg);
    }

    private static <T> void assertResults(Iterable<Result<T>> expectedResults, Iterable<Result<T>> actualResults, String failMsg) {
        Iterator<Result<T>> resultsIter = actualResults.iterator();
        Iterator<Result<T>> resultsIter2 = actualResults.iterator();
        Iterator<Result<T>> expectedResultsIter = expectedResults.iterator();
        while (resultsIter.hasNext() && resultsIter2.hasNext() && expectedResultsIter.hasNext()) {
            Result<T> expectedNext = expectedResultsIter.next();
            Result<T> next = resultsIter.next();
            Result<T> next2 = resultsIter2.next();
            if (expectedNext instanceof ResultRow) {
                TestHelper.assertRow(failMsg, (ResultRow)expectedNext, (ResultRow)next);
                TestHelper.assertRow(failMsg, (ResultRow)expectedNext, (ResultRow)next2);
                continue;
            }
            if (expectedNext instanceof Result && expectedNext.getValue() instanceof TimeseriesResultValue) {
                TestHelper.assertTimeseriesResultValue(failMsg, expectedNext, next);
                TestHelper.assertTimeseriesResultValue(StringUtils.format((String)"%s: Second iterator bad, multiple calls to iterator() should be safe", (Object[])new Object[]{failMsg}), expectedNext, next2);
                continue;
            }
            if (expectedNext instanceof Result && expectedNext.getValue() instanceof TopNResultValue) {
                TestHelper.assertTopNResultValue(failMsg, expectedNext, next);
                TestHelper.assertTopNResultValue(StringUtils.format((String)"%s: Second iterator bad, multiple calls to iterator() should be safe", (Object[])new Object[]{failMsg}), expectedNext, next2);
                continue;
            }
            TestHelper.assertResult(failMsg, expectedNext, next);
            TestHelper.assertResult(StringUtils.format((String)"%s: Second iterator bad, multiple calls to iterator() should be safe", (Object[])new Object[]{failMsg}), expectedNext, next2);
        }
        if (resultsIter.hasNext()) {
            Assert.fail((String)StringUtils.format((String)"%s: Expected resultsIter to be exhausted, next element was %s", (Object[])new Object[]{failMsg, resultsIter.next()}));
        }
        if (resultsIter2.hasNext()) {
            Assert.fail((String)StringUtils.format((String)"%s: Expected resultsIter2 to be exhausted, next element was %s", (Object[])new Object[]{failMsg, resultsIter.next()}));
        }
        if (expectedResultsIter.hasNext()) {
            Assert.fail((String)StringUtils.format((String)"%s: Expected expectedResultsIter to be exhausted, next element was %s", (Object[])new Object[]{failMsg, expectedResultsIter.next()}));
        }
    }

    private static <T> void assertObjects(Iterable<T> expectedResults, Iterable<T> actualResults, String msg) {
        Iterator<T> resultsIter = actualResults.iterator();
        Iterator<T> resultsIter2 = actualResults.iterator();
        Iterator<T> expectedResultsIter = expectedResults.iterator();
        int index = 0;
        while (resultsIter.hasNext() && resultsIter2.hasNext() && expectedResultsIter.hasNext()) {
            T expectedNext = expectedResultsIter.next();
            T next = resultsIter.next();
            T next2 = resultsIter2.next();
            String failMsg = msg + "-" + index++;
            String failMsg2 = StringUtils.format((String)"%s: Second iterator bad, multiple calls to iterator() should be safe", (Object[])new Object[]{failMsg});
            if (expectedNext instanceof ResultRow) {
                TestHelper.assertRow(failMsg, (ResultRow)expectedNext, (ResultRow)next);
                TestHelper.assertRow(failMsg2, (ResultRow)expectedNext, (ResultRow)next2);
                continue;
            }
            Assert.assertEquals((String)failMsg, expectedNext, next);
            Assert.assertEquals((String)failMsg2, expectedNext, next2);
        }
        if (resultsIter.hasNext()) {
            Assert.fail((String)StringUtils.format((String)"%s: Expected resultsIter to be exhausted, next element was %s", (Object[])new Object[]{msg, resultsIter.next()}));
        }
        if (resultsIter2.hasNext()) {
            Assert.fail((String)StringUtils.format((String)"%s: Expected resultsIter2 to be exhausted, next element was %s", (Object[])new Object[]{msg, resultsIter.next()}));
        }
        if (expectedResultsIter.hasNext()) {
            Assert.fail((String)StringUtils.format((String)"%s: Expected expectedResultsIter to be exhausted, next element was %s", (Object[])new Object[]{msg, expectedResultsIter.next()}));
        }
    }

    private static void assertResult(String msg, Result<?> expected, Result actual) {
        Assert.assertEquals((String)msg, expected, (Object)actual);
    }

    private static void assertTimeseriesResultValue(String msg, Result expected, Result actual) {
        Assert.assertEquals((String)StringUtils.format((String)"%s: timestamp", (Object[])new Object[]{msg}), (Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        TimeseriesResultValue expectedVal = (TimeseriesResultValue)expected.getValue();
        TimeseriesResultValue actualVal = (TimeseriesResultValue)actual.getValue();
        Map expectedMap = expectedVal.getBaseObject();
        Map actualMap = actualVal.getBaseObject();
        TestHelper.assertRow(msg, (Row)new MapBasedRow(expected.getTimestamp(), expectedMap), (Row)new MapBasedRow(actual.getTimestamp(), actualMap));
    }

    private static void assertTopNResultValue(String msg, Result expected, Result actual) {
        TopNResultValue expectedVal = (TopNResultValue)expected.getValue();
        TopNResultValue actualVal = (TopNResultValue)actual.getValue();
        List listExpectedRows = expectedVal.getValue().stream().map(dimensionAndMetricValueExtractor -> new MapBasedRow(expected.getTimestamp(), dimensionAndMetricValueExtractor.getBaseObject())).collect(Collectors.toList());
        List listActualRows = actualVal.getValue().stream().map(dimensionAndMetricValueExtractor -> new MapBasedRow(actual.getTimestamp(), dimensionAndMetricValueExtractor.getBaseObject())).collect(Collectors.toList());
        Assert.assertEquals((String)"Size of list must match", (long)listExpectedRows.size(), (long)listActualRows.size());
        IntStream.range(0, listExpectedRows.size()).forEach(value -> TestHelper.assertRow(StringUtils.format((String)"%s, on value number [%s]", (Object[])new Object[]{msg, value}), (Row)listExpectedRows.get(value), (Row)listActualRows.get(value)));
    }

    private static void assertRow(String msg, Row expected, Row actual) {
        Assert.assertEquals((String)StringUtils.format((String)"%s: timestamp", (Object[])new Object[]{msg}), (Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        Map expectedMap = ((MapBasedRow)expected).getEvent();
        Map actualMap = ((MapBasedRow)actual).getEvent();
        Assert.assertEquals((String)StringUtils.format((String)"%s: map keys", (Object[])new Object[]{msg}), expectedMap.keySet(), actualMap.keySet());
        for (String key : expectedMap.keySet()) {
            Object expectedValue = expectedMap.get(key);
            Object actualValue = actualMap.get(key);
            if (expectedValue != null && expectedValue.getClass().isArray()) {
                Assert.assertArrayEquals((Object[])((Object[])expectedValue), (Object[])((Object[])actualValue));
                continue;
            }
            if (expectedValue instanceof Float || expectedValue instanceof Double) {
                Assert.assertEquals((String)StringUtils.format((String)"%s: key[%s]", (Object[])new Object[]{msg, key}), (double)((Number)expectedValue).doubleValue(), (double)((Number)actualValue).doubleValue(), (double)Math.abs(((Number)expectedValue).doubleValue() * 1.0E-6));
                continue;
            }
            Assert.assertEquals((String)StringUtils.format((String)"%s: key[%s]", (Object[])new Object[]{msg, key}), expectedValue, actualValue);
        }
    }

    public static void assertRow(String msg, ResultRow expected, ResultRow actual) {
        Assert.assertEquals((String)StringUtils.format((String)"%s: row length", (Object[])new Object[]{msg}), (long)expected.length(), (long)actual.length());
        for (int i = 0; i < expected.length(); ++i) {
            String message = StringUtils.format((String)"%s: idx[%d]", (Object[])new Object[]{msg, i});
            Object expectedValue = expected.get(i);
            Object actualValue = actual.get(i);
            if (expectedValue != null && expectedValue.getClass().isArray()) {
                if (actualValue instanceof List) {
                    Assert.assertEquals((String)message, (Object[])((Object[])expectedValue), (Object[])((Object[])ExprEval.coerceListToArray((List)((List)actualValue), (boolean)true).rhs));
                    continue;
                }
                Assert.assertArrayEquals((String)message, (Object[])((Object[])expectedValue), (Object[])((Object[])actualValue));
                continue;
            }
            if (expectedValue instanceof Float || expectedValue instanceof Double) {
                Assert.assertEquals((String)message, (double)((Number)expectedValue).doubleValue(), (double)((Number)actualValue).doubleValue(), (double)Math.abs(((Number)expectedValue).doubleValue() * 1.0E-6));
                continue;
            }
            if (expectedValue instanceof ComparableStringArray && actualValue instanceof List) {
                Assert.assertArrayEquals((Object[])((ComparableStringArray)expectedValue).getDelegate(), (Object[])((Object[])ExprEval.coerceListToArray((List)((List)actualValue), (boolean)true).rhs));
                continue;
            }
            if (expectedValue instanceof ComparableList && actualValue instanceof List) {
                Assert.assertArrayEquals((Object[])((ComparableList)expectedValue).getDelegate().toArray(new Object[0]), (Object[])((Object[])ExprEval.coerceListToArray((List)((List)actualValue), (boolean)true).rhs));
                continue;
            }
            Assert.assertEquals((String)message, (Object)expectedValue, (Object)actualValue);
        }
    }

    public static Map<String, Object> createExpectedMap(Object ... vals) {
        Preconditions.checkArgument((vals.length % 2 == 0 ? 1 : 0) != 0);
        HashMap<String, Object> theVals = new HashMap<String, Object>();
        for (int i = 0; i < vals.length; i += 2) {
            theVals.put(vals[i].toString(), vals[i + 1]);
        }
        return theVals;
    }

    public static void testSerializesDeserializes(Object object) {
        TestHelper.testSerializesDeserializes(JSON_MAPPER, object);
    }

    public static void testSerializesDeserializes(ObjectMapper objectMapper, Object object) {
        try {
            String serialized = objectMapper.writeValueAsString(object);
            Object deserialized = objectMapper.readValue(serialized, object.getClass());
            Assert.assertEquals((Object)serialized, (Object)objectMapper.writeValueAsString(deserialized));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

