/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.data.input.impl.DelimitedParseSpec;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMaxAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMinAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Interval;

public class TestIndex {
    public static final String[] COLUMNS = new String[]{"ts", "market", "quality", "qualityLong", "qualityFloat", "qualityDouble", "qualityNumericString", "longNumericNull", "floatNumericNull", "doubleNumericNull", "placement", "placementish", "index", "partial_null_column", "null_column", "quality_uniques", "indexMin", "indexMaxPlusTen"};
    public static final List<DimensionSchema> DIMENSION_SCHEMAS = Arrays.asList(new StringDimensionSchema("market"), new StringDimensionSchema("quality"), new LongDimensionSchema("qualityLong"), new FloatDimensionSchema("qualityFloat"), new DoubleDimensionSchema("qualityDouble"), new StringDimensionSchema("qualityNumericString"), new LongDimensionSchema("longNumericNull"), new FloatDimensionSchema("floatNumericNull"), new DoubleDimensionSchema("doubleNumericNull"), new StringDimensionSchema("placement"), new StringDimensionSchema("placementish"), new StringDimensionSchema("partial_null_column"), new StringDimensionSchema("null_column"));
    public static final List<DimensionSchema> DIMENSION_SCHEMAS_NO_BITMAP = Arrays.asList(new StringDimensionSchema("market", null, Boolean.valueOf(false)), new StringDimensionSchema("quality", null, Boolean.valueOf(false)), new LongDimensionSchema("qualityLong"), new FloatDimensionSchema("qualityFloat"), new DoubleDimensionSchema("qualityDouble"), new StringDimensionSchema("qualityNumericString", null, Boolean.valueOf(false)), new LongDimensionSchema("longNumericNull"), new FloatDimensionSchema("floatNumericNull"), new DoubleDimensionSchema("doubleNumericNull"), new StringDimensionSchema("placement", null, Boolean.valueOf(false)), new StringDimensionSchema("placementish", null, Boolean.valueOf(false)), new StringDimensionSchema("partial_null_column", null, Boolean.valueOf(false)), new StringDimensionSchema("null_column", null, Boolean.valueOf(false)));
    public static final DimensionsSpec DIMENSIONS_SPEC = new DimensionsSpec(DIMENSION_SCHEMAS);
    public static final DimensionsSpec DIMENSIONS_SPEC_NO_BITMAPS = new DimensionsSpec(DIMENSION_SCHEMAS_NO_BITMAP);
    public static final String[] DOUBLE_METRICS = new String[]{"index", "indexMin", "indexMaxPlusTen"};
    public static final String[] FLOAT_METRICS = new String[]{"indexFloat", "indexMinFloat", "indexMaxFloat"};
    public static final Interval DATA_INTERVAL = Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-05-01T00:00:00.000Z");
    private static final Logger log = new Logger(TestIndex.class);
    private static final VirtualColumns VIRTUAL_COLUMNS = VirtualColumns.create(Collections.singletonList(new ExpressionVirtualColumn("expr", "index + 10", ColumnType.FLOAT, TestExprMacroTable.INSTANCE)));
    public static final AggregatorFactory[] METRIC_AGGS = new AggregatorFactory[]{new DoubleSumAggregatorFactory(DOUBLE_METRICS[0], "index"), new FloatSumAggregatorFactory(FLOAT_METRICS[0], "index"), new DoubleMinAggregatorFactory(DOUBLE_METRICS[1], "index"), new FloatMinAggregatorFactory(FLOAT_METRICS[1], "index"), new FloatMaxAggregatorFactory(FLOAT_METRICS[2], "index"), new DoubleMaxAggregatorFactory(DOUBLE_METRICS[2], VIRTUAL_COLUMNS.getVirtualColumns()[0].getOutputName()), new HyperUniquesAggregatorFactory("quality_uniques", "quality")};
    public static final IndexSpec INDEX_SPEC = new IndexSpec();
    public static final IndexMerger INDEX_MERGER = TestHelper.getTestIndexMergerV9((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
    public static final IndexIO INDEX_IO = TestHelper.getTestIndexIO();
    private static Supplier<IncrementalIndex> realtimeIndex;
    private static Supplier<IncrementalIndex> noRollupRealtimeIndex;
    private static Supplier<IncrementalIndex> noBitmapRealtimeIndex;
    private static Supplier<QueryableIndex> mmappedIndex;
    private static Supplier<QueryableIndex> noRollupMmappedIndex;
    private static Supplier<QueryableIndex> noBitmapMmappedIndex;
    private static Supplier<QueryableIndex> mergedRealtime;
    private static Supplier<QueryableIndex> frontCodedMmappedIndex;

    public static IncrementalIndex getIncrementalTestIndex() {
        return (IncrementalIndex)realtimeIndex.get();
    }

    public static IncrementalIndex getNoRollupIncrementalTestIndex() {
        return (IncrementalIndex)noRollupRealtimeIndex.get();
    }

    public static IncrementalIndex getNoBitmapIncrementalTestIndex() {
        return (IncrementalIndex)noBitmapRealtimeIndex.get();
    }

    public static QueryableIndex getMMappedTestIndex() {
        return (QueryableIndex)mmappedIndex.get();
    }

    public static QueryableIndex getNoRollupMMappedTestIndex() {
        return (QueryableIndex)noRollupMmappedIndex.get();
    }

    public static QueryableIndex getNoBitmapMMappedTestIndex() {
        return (QueryableIndex)noBitmapMmappedIndex.get();
    }

    public static QueryableIndex mergedRealtimeIndex() {
        return (QueryableIndex)mergedRealtime.get();
    }

    public static QueryableIndex getFrontCodedMMappedTestIndex() {
        return (QueryableIndex)frontCodedMmappedIndex.get();
    }

    public static IncrementalIndex makeRealtimeIndex(String resourceFilename) {
        return TestIndex.makeRealtimeIndex(resourceFilename, true);
    }

    public static IncrementalIndex makeRealtimeIndex(String resourceFilename, boolean rollup) {
        return TestIndex.makeRealtimeIndex(resourceFilename, rollup, true);
    }

    public static IncrementalIndex makeRealtimeIndex(String resourceFilename, boolean rollup, boolean bitmap) {
        CharSource stream = TestIndex.getResourceCharSource(resourceFilename);
        return TestIndex.makeRealtimeIndex(stream, rollup, bitmap);
    }

    public static CharSource getResourceCharSource(String resourceFilename) {
        URL resource = TestIndex.class.getClassLoader().getResource(resourceFilename);
        if (resource == null) {
            throw new IllegalArgumentException("cannot find resource " + resourceFilename);
        }
        log.info("Realtime loading index file[%s]", new Object[]{resource});
        return Resources.asByteSource((URL)resource).asCharSource(StandardCharsets.UTF_8);
    }

    public static IncrementalIndex makeRealtimeIndex(CharSource source) {
        return TestIndex.makeRealtimeIndex(source, true, true);
    }

    public static IncrementalIndex makeRealtimeIndex(CharSource source, boolean rollup, boolean bitmap) {
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withMinTimestamp(DateTimes.of((String)"2011-01-12T00:00:00.000Z").getMillis()).withTimestampSpec(new TimestampSpec("ds", "auto", null)).withDimensionsSpec(bitmap ? DIMENSIONS_SPEC : DIMENSIONS_SPEC_NO_BITMAPS).withVirtualColumns(VIRTUAL_COLUMNS).withMetrics(METRIC_AGGS).withRollup(rollup).build();
        IncrementalIndex retVal = new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(10000).build();
        try {
            return TestIndex.loadIncrementalIndex(retVal, source);
        }
        catch (Exception e) {
            if (rollup) {
                realtimeIndex = null;
            } else {
                noRollupRealtimeIndex = null;
            }
            throw new RuntimeException(e);
        }
    }

    public static IncrementalIndex loadIncrementalIndex(IncrementalIndex retVal, CharSource source) throws IOException {
        StringInputRowParser parser = new StringInputRowParser((ParseSpec)new DelimitedParseSpec(new TimestampSpec("ts", "iso", null), DIMENSIONS_SPEC, "\t", "\u0001", Arrays.asList(COLUMNS), false, 0), "utf8");
        return TestIndex.loadIncrementalIndex((Supplier<IncrementalIndex>)((Supplier)() -> retVal), source, parser);
    }

    public static IncrementalIndex loadIncrementalIndex(Supplier<IncrementalIndex> indexSupplier, CharSource source, final StringInputRowParser parser) throws IOException {
        final IncrementalIndex retVal = (IncrementalIndex)indexSupplier.get();
        final AtomicLong startTime = new AtomicLong();
        int lineCount = (Integer)source.readLines((LineProcessor)new LineProcessor<Integer>(){
            boolean runOnce = false;
            int lineCount = 0;

            public boolean processLine(String line) throws IOException {
                if (!this.runOnce) {
                    startTime.set(System.currentTimeMillis());
                    this.runOnce = true;
                }
                retVal.add(parser.parse(line));
                ++this.lineCount;
                return true;
            }

            public Integer getResult() {
                return this.lineCount;
            }
        });
        log.info("Loaded %,d lines in %,d millis.", new Object[]{lineCount, System.currentTimeMillis() - startTime.get()});
        return retVal;
    }

    public static QueryableIndex persistRealtimeAndLoadMMapped(IncrementalIndex index) {
        return TestIndex.persistRealtimeAndLoadMMapped(index, INDEX_SPEC);
    }

    public static QueryableIndex persistRealtimeAndLoadMMapped(IncrementalIndex index, IndexSpec indexSpec) {
        try {
            File someTmpFile = File.createTempFile("billy", "yay");
            someTmpFile.delete();
            FileUtils.mkdirp((File)someTmpFile);
            someTmpFile.deleteOnExit();
            INDEX_MERGER.persist(index, someTmpFile, indexSpec, null);
            return INDEX_IO.loadIndex(someTmpFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
        realtimeIndex = Suppliers.memoize(() -> TestIndex.makeRealtimeIndex("druid.sample.numeric.tsv"));
        noRollupRealtimeIndex = Suppliers.memoize(() -> TestIndex.makeRealtimeIndex("druid.sample.numeric.tsv", false));
        noBitmapRealtimeIndex = Suppliers.memoize(() -> TestIndex.makeRealtimeIndex("druid.sample.numeric.tsv", false, false));
        mmappedIndex = Suppliers.memoize(() -> TestIndex.persistRealtimeAndLoadMMapped((IncrementalIndex)realtimeIndex.get()));
        noRollupMmappedIndex = Suppliers.memoize(() -> TestIndex.persistRealtimeAndLoadMMapped((IncrementalIndex)noRollupRealtimeIndex.get()));
        noBitmapMmappedIndex = Suppliers.memoize(() -> TestIndex.persistRealtimeAndLoadMMapped((IncrementalIndex)noBitmapRealtimeIndex.get()));
        mergedRealtime = Suppliers.memoize(() -> {
            try {
                IncrementalIndex top = TestIndex.makeRealtimeIndex("druid.sample.numeric.tsv.top");
                IncrementalIndex bottom = TestIndex.makeRealtimeIndex("druid.sample.numeric.tsv.bottom");
                File tmpFile = File.createTempFile("yay", "who");
                tmpFile.delete();
                File topFile = new File(tmpFile, "top");
                File bottomFile = new File(tmpFile, "bottom");
                File mergedFile = new File(tmpFile, "merged");
                FileUtils.mkdirp((File)topFile);
                FileUtils.mkdirp((File)bottomFile);
                FileUtils.mkdirp((File)mergedFile);
                topFile.deleteOnExit();
                bottomFile.deleteOnExit();
                mergedFile.deleteOnExit();
                INDEX_MERGER.persist(top, DATA_INTERVAL, topFile, INDEX_SPEC, null);
                INDEX_MERGER.persist(bottom, DATA_INTERVAL, bottomFile, INDEX_SPEC, null);
                return INDEX_IO.loadIndex(INDEX_MERGER.mergeQueryableIndex(Arrays.asList(INDEX_IO.loadIndex(topFile), INDEX_IO.loadIndex(bottomFile)), true, METRIC_AGGS, mergedFile, INDEX_SPEC, null, -1));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        frontCodedMmappedIndex = Suppliers.memoize(() -> TestIndex.persistRealtimeAndLoadMMapped((IncrementalIndex)realtimeIndex.get(), new IndexSpec(null, null, (StringEncodingStrategy)new StringEncodingStrategy.FrontCoded(Integer.valueOf(4)), null, null, null, null)));
    }
}

