/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.InlineJoinableFactory;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.table.IndexedTableJoinable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class InlineJoinableFactoryTest {
    private static final String PREFIX = "j.";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final InlineJoinableFactory factory = new InlineJoinableFactory();
    private final InlineDataSource inlineDataSource = InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{"foo", 1L}, (Object)new Object[]{"bar", 2L}), (RowSignature)RowSignature.builder().add("str", ColumnType.STRING).add("long", ColumnType.LONG).build());

    @Test
    public void testBuildNonInline() {
        this.expectedException.expect(ClassCastException.class);
        this.expectedException.expectMessage("TableDataSource cannot be cast");
        Optional ignored = this.factory.build((DataSource)new TableDataSource("foo"), InlineJoinableFactoryTest.makeCondition("x == \"j.y\""));
    }

    @Test
    public void testBuildNonHashJoin() {
        Assert.assertEquals(Optional.empty(), (Object)this.factory.build((DataSource)this.inlineDataSource, InlineJoinableFactoryTest.makeCondition("x > \"j.y\"")));
    }

    @Test
    public void testBuild() {
        Joinable joinable = (Joinable)this.factory.build((DataSource)this.inlineDataSource, InlineJoinableFactoryTest.makeCondition("x == \"j.long\"")).get();
        Assert.assertThat((Object)joinable, (Matcher)CoreMatchers.instanceOf(IndexedTableJoinable.class));
        Assert.assertEquals((Object)ImmutableList.of((Object)"str", (Object)"long"), (Object)joinable.getAvailableColumns());
        Assert.assertEquals((long)3L, (long)joinable.getCardinality("str"));
        Assert.assertEquals((long)3L, (long)joinable.getCardinality("long"));
    }

    @Test
    public void testIsDirectlyJoinable() {
        Assert.assertTrue((boolean)this.factory.isDirectlyJoinable((DataSource)this.inlineDataSource));
        Assert.assertFalse((boolean)this.factory.isDirectlyJoinable((DataSource)new TableDataSource("foo")));
    }

    private static JoinConditionAnalysis makeCondition(String condition) {
        return JoinConditionAnalysis.forExpression((String)condition, (String)PREFIX, (ExprMacroTable)ExprMacroTable.nil());
    }
}

