/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.TreeSet;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.serde.DictionaryEncodedStringIndexSupplier;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;
import org.roaringbitmap.IntIterator;

public class DictionaryEncodedStringIndexSupplierTest
extends InitializedNullHandlingTest {
    BitmapSerdeFactory roaringFactory = new RoaringBitmapSerdeFactory(null);
    BitmapResultFactory<ImmutableBitmap> bitmapResultFactory = new DefaultBitmapResultFactory(this.roaringFactory.getBitmapFactory());

    @Test
    public void testStringColumnWithNullValueSetIndex() throws IOException {
        DictionaryEncodedStringIndexSupplier indexSupplier = this.makeStringWithNullsSupplier();
        StringValueSetIndex valueSetIndex = (StringValueSetIndex)indexSupplier.as(StringValueSetIndex.class);
        Assert.assertNotNull((Object)valueSetIndex);
        BitmapColumnIndex columnIndex = valueSetIndex.forValue("b");
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.1, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        ImmutableBitmap bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 3);
        columnIndex = valueSetIndex.forValue("fo");
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.0, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, new int[0]);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"b", (Object)"fooo", (Object)"z")));
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.5, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 2, 3, 4, 5, 6);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"foo")));
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.2, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, 0, 9);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"a", (Object)"aa", (Object)"aaa")));
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.0, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, new int[0]);
        columnIndex = valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)"zz", (Object)"zzz", (Object)"zzzz")));
        Assert.assertNotNull((Object)columnIndex);
        Assert.assertEquals((double)0.0, (double)columnIndex.estimateSelectivity(10), (double)0.0);
        bitmap = (ImmutableBitmap)columnIndex.computeBitmapResult(this.bitmapResultFactory);
        this.checkBitmap(bitmap, new int[0]);
    }

    private DictionaryEncodedStringIndexSupplier makeStringWithNullsSupplier() throws IOException {
        ByteBuffer stringBuffer = ByteBuffer.allocate(4096);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
        GenericIndexedWriter stringWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "strings", GenericIndexed.STRING_STRATEGY);
        GenericIndexedWriter byteBufferWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "byteBuffers", GenericIndexed.UTF8_STRATEGY);
        stringWriter.open();
        byteBufferWriter.open();
        ByteBuffer bitmapsBuffer = ByteBuffer.allocate(4096);
        GenericIndexedWriter bitmapWriter = new GenericIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), "bitmaps", this.roaringFactory.getObjectStrategy());
        bitmapWriter.setObjectsNotSorted();
        bitmapWriter.open();
        stringWriter.write(null);
        byteBufferWriter.write(null);
        bitmapWriter.write((Object)this.fillBitmap(1, 7, 8));
        stringWriter.write((Object)"b");
        byteBufferWriter.write((Object)ByteBuffer.wrap("b".getBytes(StandardCharsets.UTF_8)));
        bitmapWriter.write((Object)this.fillBitmap(3));
        stringWriter.write((Object)"foo");
        byteBufferWriter.write((Object)ByteBuffer.wrap("foo".getBytes(StandardCharsets.UTF_8)));
        bitmapWriter.write((Object)this.fillBitmap(0, 9));
        stringWriter.write((Object)"fooo");
        byteBufferWriter.write((Object)ByteBuffer.wrap("fooo".getBytes(StandardCharsets.UTF_8)));
        bitmapWriter.write((Object)this.fillBitmap(2, 5));
        stringWriter.write((Object)"z");
        byteBufferWriter.write((Object)ByteBuffer.wrap("z".getBytes(StandardCharsets.UTF_8)));
        bitmapWriter.write((Object)this.fillBitmap(4, 6));
        DictionaryEncodedStringIndexSupplierTest.writeToBuffer(stringBuffer, (Serializer)stringWriter);
        DictionaryEncodedStringIndexSupplierTest.writeToBuffer(byteBuffer, (Serializer)stringWriter);
        DictionaryEncodedStringIndexSupplierTest.writeToBuffer(bitmapsBuffer, (Serializer)bitmapWriter);
        GenericIndexed bitmaps = GenericIndexed.read((ByteBuffer)bitmapsBuffer, (ObjectStrategy)this.roaringFactory.getObjectStrategy());
        return new DictionaryEncodedStringIndexSupplier(this.roaringFactory.getBitmapFactory(), GenericIndexed.read((ByteBuffer)stringBuffer, (ObjectStrategy)GenericIndexed.STRING_STRATEGY), GenericIndexed.read((ByteBuffer)byteBuffer, (ObjectStrategy)GenericIndexed.UTF8_STRATEGY), bitmaps, null);
    }

    static void writeToBuffer(final ByteBuffer buffer, Serializer serializer) throws IOException {
        WritableByteChannel channel = new WritableByteChannel(){

            @Override
            public int write(ByteBuffer src) {
                int size = src.remaining();
                buffer.put(src);
                return size;
            }

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() {
            }
        };
        serializer.writeTo(channel, null);
        buffer.position(0);
    }

    private ImmutableBitmap fillBitmap(int ... rows) {
        MutableBitmap bitmap = this.roaringFactory.getBitmapFactory().makeEmptyMutableBitmap();
        for (int i : rows) {
            bitmap.add(i);
        }
        return this.roaringFactory.getBitmapFactory().makeImmutableBitmap(bitmap);
    }

    private void checkBitmap(ImmutableBitmap bitmap, int ... expectedRows) {
        IntIterator iterator = bitmap.iterator();
        for (int i : expectedRows) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((long)i, (long)iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

