/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.extraction.BucketExtractionFn;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestLongColumnSelector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ZeroIndexedInts;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

public class VirtualColumnsTest
extends InitializedNullHandlingTest {
    private static final String REAL_COLUMN_NAME = "real_column";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    public ColumnSelectorFactory baseColumnSelectorFactory;

    @Test
    public void testExists() {
        VirtualColumns virtualColumns = this.makeVirtualColumns();
        Assert.assertTrue((boolean)virtualColumns.exists("expr"));
        Assert.assertTrue((boolean)virtualColumns.exists("foo"));
        Assert.assertTrue((boolean)virtualColumns.exists("foo.5"));
        Assert.assertFalse((boolean)virtualColumns.exists("bar"));
    }

    @Test
    public void testGetColumnCapabilitiesNilBase() {
        VirtualColumns virtualColumns = this.makeVirtualColumns();
        ColumnInspector baseInspector = column -> null;
        Assert.assertEquals((Object)ValueType.FLOAT, (Object)virtualColumns.getColumnCapabilities(baseInspector, "expr").getType());
        Assert.assertEquals((Object)ValueType.LONG, (Object)virtualColumns.getColumnCapabilities(baseInspector, "expr2").getType());
        Assert.assertNull((Object)virtualColumns.getColumnCapabilities(baseInspector, REAL_COLUMN_NAME));
    }

    @Test
    public void testGetColumnCapabilitiesDoubleBase() {
        VirtualColumns virtualColumns = this.makeVirtualColumns();
        ColumnInspector baseInspector = column -> {
            if (REAL_COLUMN_NAME.equals(column)) {
                return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.DOUBLE);
            }
            return null;
        };
        Assert.assertEquals((Object)ValueType.FLOAT, (Object)virtualColumns.getColumnCapabilities(baseInspector, "expr").getType());
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)virtualColumns.getColumnCapabilities(baseInspector, "expr2").getType());
        Assert.assertNull((Object)virtualColumns.getColumnCapabilities(baseInspector, REAL_COLUMN_NAME));
    }

    @Test
    public void testGetColumnCapabilitiesWithFallbackNilBase() {
        VirtualColumns virtualColumns = this.makeVirtualColumns();
        ColumnInspector baseInspector = column -> null;
        Assert.assertEquals((Object)ValueType.FLOAT, (Object)virtualColumns.getColumnCapabilitiesWithFallback(baseInspector, "expr").getType());
        Assert.assertEquals((Object)ValueType.LONG, (Object)virtualColumns.getColumnCapabilitiesWithFallback(baseInspector, "expr2").getType());
        Assert.assertNull((Object)virtualColumns.getColumnCapabilitiesWithFallback(baseInspector, REAL_COLUMN_NAME));
    }

    @Test
    public void testGetColumnCapabilitiesWithFallbackDoubleBase() {
        VirtualColumns virtualColumns = this.makeVirtualColumns();
        ColumnInspector baseInspector = column -> {
            if (REAL_COLUMN_NAME.equals(column)) {
                return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.DOUBLE);
            }
            return null;
        };
        Assert.assertEquals((Object)ValueType.FLOAT, (Object)virtualColumns.getColumnCapabilitiesWithFallback(baseInspector, "expr").getType());
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)virtualColumns.getColumnCapabilitiesWithFallback(baseInspector, "expr2").getType());
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)virtualColumns.getColumnCapabilitiesWithFallback(baseInspector, REAL_COLUMN_NAME).getType());
    }

    @Test
    public void testWrapInspectorNilBase() {
        VirtualColumns virtualColumns = this.makeVirtualColumns();
        ColumnInspector baseInspector = column -> null;
        ColumnInspector wrappedInspector = virtualColumns.wrapInspector(baseInspector);
        Assert.assertEquals((Object)ValueType.FLOAT, (Object)wrappedInspector.getColumnCapabilities("expr").getType());
        Assert.assertEquals((Object)ValueType.LONG, (Object)wrappedInspector.getColumnCapabilities("expr2").getType());
        Assert.assertNull((Object)wrappedInspector.getColumnCapabilities(REAL_COLUMN_NAME));
    }

    @Test
    public void testWrapInspectorDoubleBase() {
        VirtualColumns virtualColumns = this.makeVirtualColumns();
        ColumnInspector baseInspector = column -> {
            if (REAL_COLUMN_NAME.equals(column)) {
                return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.DOUBLE);
            }
            return null;
        };
        ColumnInspector wrappedInspector = virtualColumns.wrapInspector(baseInspector);
        Assert.assertEquals((Object)ValueType.FLOAT, (Object)wrappedInspector.getColumnCapabilities("expr").getType());
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)wrappedInspector.getColumnCapabilities("expr2").getType());
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)wrappedInspector.getColumnCapabilities(REAL_COLUMN_NAME).getType());
    }

    @Test
    public void testNonExistentSelector() {
        VirtualColumns virtualColumns = this.makeVirtualColumns();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("No such virtual column[bar]");
        virtualColumns.makeColumnValueSelector("bar", this.baseColumnSelectorFactory);
    }

    @Test
    public void testMakeSelectors() {
        Mockito.when((Object)this.baseColumnSelectorFactory.getRowIdSupplier()).thenReturn(null);
        VirtualColumns virtualColumns = this.makeVirtualColumns();
        ColumnValueSelector objectSelector = virtualColumns.makeColumnValueSelector("expr", this.baseColumnSelectorFactory);
        DimensionSelector dimensionSelector = virtualColumns.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("expr", "x"), this.baseColumnSelectorFactory);
        DimensionSelector extractionDimensionSelector = virtualColumns.makeDimensionSelector((DimensionSpec)new ExtractionDimensionSpec("expr", "x", (ExtractionFn)new BucketExtractionFn(Double.valueOf(1.0), Double.valueOf(0.5))), this.baseColumnSelectorFactory);
        ColumnValueSelector floatSelector = virtualColumns.makeColumnValueSelector("expr", this.baseColumnSelectorFactory);
        ColumnValueSelector longSelector = virtualColumns.makeColumnValueSelector("expr", this.baseColumnSelectorFactory);
        Assert.assertEquals((Object)1L, (Object)objectSelector.getObject());
        Assert.assertEquals((Object)"1", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertEquals((Object)"0.5", (Object)extractionDimensionSelector.lookupName(extractionDimensionSelector.getRow().get(0)));
        Assert.assertEquals((float)1.0f, (float)floatSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((long)1L, (long)longSelector.getLong());
    }

    @Test
    public void testMakeSelectorsWithDotSupport() {
        VirtualColumns virtualColumns = this.makeVirtualColumns();
        ColumnValueSelector objectSelector = virtualColumns.makeColumnValueSelector("foo.5", this.baseColumnSelectorFactory);
        DimensionSelector dimensionSelector = virtualColumns.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("foo.5", "x"), this.baseColumnSelectorFactory);
        ColumnValueSelector floatSelector = virtualColumns.makeColumnValueSelector("foo.5", this.baseColumnSelectorFactory);
        ColumnValueSelector longSelector = virtualColumns.makeColumnValueSelector("foo.5", this.baseColumnSelectorFactory);
        Assert.assertEquals((Object)5L, (Object)objectSelector.getObject());
        Assert.assertEquals((Object)"5", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertEquals((float)5.0f, (float)floatSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((long)5L, (long)longSelector.getLong());
    }

    @Test
    public void testMakeSelectorsWithDotSupportBaseNameOnly() {
        VirtualColumns virtualColumns = this.makeVirtualColumns();
        ColumnValueSelector objectSelector = virtualColumns.makeColumnValueSelector("foo", this.baseColumnSelectorFactory);
        DimensionSelector dimensionSelector = virtualColumns.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("foo", "x"), this.baseColumnSelectorFactory);
        ColumnValueSelector floatSelector = virtualColumns.makeColumnValueSelector("foo", this.baseColumnSelectorFactory);
        ColumnValueSelector longSelector = virtualColumns.makeColumnValueSelector("foo", this.baseColumnSelectorFactory);
        Assert.assertEquals((Object)-1L, (Object)objectSelector.getObject());
        Assert.assertEquals((Object)"-1", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertEquals((float)-1.0f, (float)floatSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((long)-1L, (long)longSelector.getLong());
    }

    @Test
    public void testTimeNotAllowed() {
        ExpressionVirtualColumn expr = new ExpressionVirtualColumn("__time", "x + y", ColumnType.FLOAT, TestExprMacroTable.INSTANCE);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("virtualColumn name[__time] not allowed");
        VirtualColumns.create((List)ImmutableList.of((Object)expr));
    }

    @Test
    public void testDuplicateNameDetection() {
        ExpressionVirtualColumn expr = new ExpressionVirtualColumn("expr", "x + y", ColumnType.FLOAT, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn expr2 = new ExpressionVirtualColumn("expr", "x * 2", ColumnType.FLOAT, TestExprMacroTable.INSTANCE);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Duplicate virtualColumn name[expr]");
        VirtualColumns.create((List)ImmutableList.of((Object)expr, (Object)expr2));
    }

    @Test
    public void testCycleDetection() {
        ExpressionVirtualColumn expr = new ExpressionVirtualColumn("expr", "x + expr2", ColumnType.FLOAT, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn expr2 = new ExpressionVirtualColumn("expr2", "expr * 2", ColumnType.FLOAT, TestExprMacroTable.INSTANCE);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Self-referential column[expr]");
        VirtualColumns.create((List)ImmutableList.of((Object)expr, (Object)expr2));
    }

    @Test
    public void testGetCacheKey() {
        VirtualColumns virtualColumns = VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("expr", "x + y", ColumnType.FLOAT, TestExprMacroTable.INSTANCE)));
        VirtualColumns virtualColumns2 = VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("expr", "x + y", ColumnType.FLOAT, TestExprMacroTable.INSTANCE)));
        Assert.assertArrayEquals((byte[])virtualColumns.getCacheKey(), (byte[])virtualColumns2.getCacheKey());
        Assert.assertFalse((boolean)Arrays.equals(virtualColumns.getCacheKey(), VirtualColumns.EMPTY.getCacheKey()));
    }

    @Test
    public void testEqualsAndHashCode() {
        VirtualColumns virtualColumns = VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("expr", "x + y", ColumnType.FLOAT, TestExprMacroTable.INSTANCE)));
        VirtualColumns virtualColumns2 = VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("expr", "x + y", ColumnType.FLOAT, TestExprMacroTable.INSTANCE)));
        Assert.assertEquals((Object)virtualColumns, (Object)virtualColumns);
        Assert.assertEquals((Object)virtualColumns, (Object)virtualColumns2);
        Assert.assertNotEquals((Object)VirtualColumns.EMPTY, (Object)virtualColumns);
        Assert.assertNotEquals((Object)VirtualColumns.EMPTY, null);
        Assert.assertEquals((long)virtualColumns.hashCode(), (long)virtualColumns.hashCode());
        Assert.assertEquals((long)virtualColumns.hashCode(), (long)virtualColumns2.hashCode());
        Assert.assertNotEquals((long)VirtualColumns.EMPTY.hashCode(), (long)virtualColumns.hashCode());
    }

    @Test
    public void testSerde() throws Exception {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        ImmutableList theColumns = ImmutableList.of((Object)new ExpressionVirtualColumn("expr", "x + y", ColumnType.FLOAT, TestExprMacroTable.INSTANCE), (Object)new ExpressionVirtualColumn("expr2", "x + z", ColumnType.FLOAT, TestExprMacroTable.INSTANCE));
        VirtualColumns virtualColumns = VirtualColumns.create((List)theColumns);
        Assert.assertEquals((Object)virtualColumns, (Object)mapper.readValue(mapper.writeValueAsString((Object)virtualColumns), VirtualColumns.class));
        Assert.assertEquals((Object)theColumns, (Object)mapper.readValue(mapper.writeValueAsString((Object)virtualColumns), mapper.getTypeFactory().constructParametricType(List.class, new Class[]{VirtualColumn.class})));
    }

    @Test
    public void testCompositeVirtualColumnsCycles() {
        ExpressionVirtualColumn expr1 = new ExpressionVirtualColumn("v1", "1 + x", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn expr2 = new ExpressionVirtualColumn("v2", "1 + y", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn expr0 = new ExpressionVirtualColumn("v0", "case_searched(notnull(1 + x), v1, v2)", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        VirtualColumns virtualColumns = VirtualColumns.create((List)ImmutableList.of((Object)expr0, (Object)expr1, (Object)expr2));
        Assert.assertTrue((boolean)virtualColumns.exists("v0"));
        Assert.assertTrue((boolean)virtualColumns.exists("v1"));
        Assert.assertTrue((boolean)virtualColumns.exists("v2"));
    }

    @Test
    public void testCompositeVirtualColumnsCyclesSiblings() {
        ExpressionVirtualColumn expr1 = new ExpressionVirtualColumn("v1", "1 + x", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn expr2 = new ExpressionVirtualColumn("v2", "1 + y", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn expr0 = new ExpressionVirtualColumn("v0", "case_searched(notnull(v1), v1, v2)", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        VirtualColumns virtualColumns = VirtualColumns.create((List)ImmutableList.of((Object)expr0, (Object)expr1, (Object)expr2));
        Assert.assertTrue((boolean)virtualColumns.exists("v0"));
        Assert.assertTrue((boolean)virtualColumns.exists("v1"));
        Assert.assertTrue((boolean)virtualColumns.exists("v2"));
    }

    @Test
    public void testCompositeVirtualColumnsCyclesTree() {
        ExpressionVirtualColumn expr1 = new ExpressionVirtualColumn("v1", "1 + x", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn expr2 = new ExpressionVirtualColumn("v2", "1 + v1", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn expr0 = new ExpressionVirtualColumn("v0", "v1 + v2", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        VirtualColumns virtualColumns = VirtualColumns.create((List)ImmutableList.of((Object)expr0, (Object)expr1, (Object)expr2));
        Assert.assertTrue((boolean)virtualColumns.exists("v0"));
        Assert.assertTrue((boolean)virtualColumns.exists("v1"));
        Assert.assertTrue((boolean)virtualColumns.exists("v2"));
    }

    @Test
    public void testCompositeVirtualColumnsCapabilitiesHasAccessToOtherVirtualColumns() {
        ColumnInspector baseInspector = new ColumnInspector(){

            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                if ("x".equals(column)) {
                    return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.LONG);
                }
                if ("n".equals(column)) {
                    return ColumnCapabilitiesImpl.createDefault().setType(NestedDataComplexTypeSerde.TYPE);
                }
                return null;
            }
        };
        NestedFieldVirtualColumn v0 = new NestedFieldVirtualColumn("n", "$.x", "v0", ColumnType.STRING);
        NestedFieldVirtualColumn v1 = new NestedFieldVirtualColumn("n", "$.y", "v1", ColumnType.LONG);
        ExpressionVirtualColumn expr1 = new ExpressionVirtualColumn("v2", "v0 * v1", null, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn expr2 = new ExpressionVirtualColumn("v3", "v0 * x", null, TestExprMacroTable.INSTANCE);
        VirtualColumns virtualColumns = VirtualColumns.create((List)ImmutableList.of((Object)v0, (Object)v1, (Object)expr1, (Object)expr2));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)virtualColumns.getColumnCapabilities(baseInspector, "v0").toColumnType());
        Assert.assertEquals((Object)ColumnType.LONG, (Object)virtualColumns.getColumnCapabilities(baseInspector, "v1").toColumnType());
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)virtualColumns.getColumnCapabilities(baseInspector, "v2").toColumnType());
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)virtualColumns.getColumnCapabilities(baseInspector, "v3").toColumnType());
        Assert.assertTrue((boolean)virtualColumns.canVectorize(baseInspector));
    }

    private VirtualColumns makeVirtualColumns() {
        ExpressionVirtualColumn expr = new ExpressionVirtualColumn("expr", "1", ColumnType.FLOAT, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn expr2i = new ExpressionVirtualColumn("expr2i", "2", ColumnType.LONG, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn expr2 = new ExpressionVirtualColumn("expr2", "expr2i + real_column", null, TestExprMacroTable.INSTANCE);
        DottyVirtualColumn dotty = new DottyVirtualColumn("foo");
        return VirtualColumns.create((List)ImmutableList.of((Object)expr, (Object)expr2i, (Object)expr2, (Object)dotty));
    }

    static class DottyVirtualColumn
    implements VirtualColumn {
        private final String name;

        public DottyVirtualColumn(String name) {
            this.name = name;
        }

        public String getOutputName() {
            return this.name;
        }

        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
            ColumnValueSelector<?> selector = this.makeColumnValueSelector(dimensionSpec.getDimension(), factory);
            ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
            DimensionSelector dimensionSelector = new DimensionSelector((BaseLongColumnValueSelector)selector, extractionFn){
                final /* synthetic */ BaseLongColumnValueSelector val$selector;
                final /* synthetic */ ExtractionFn val$extractionFn;
                {
                    this.val$selector = baseLongColumnValueSelector;
                    this.val$extractionFn = extractionFn;
                }

                public IndexedInts getRow() {
                    return ZeroIndexedInts.instance();
                }

                public int getValueCardinality() {
                    return -1;
                }

                public String lookupName(int id) {
                    String stringValue = String.valueOf(this.val$selector.getLong());
                    return this.val$extractionFn == null ? stringValue : this.val$extractionFn.apply(stringValue);
                }

                public ValueMatcher makeValueMatcher(String value) {
                    return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, (String)value);
                }

                public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                    return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
                }

                public boolean nameLookupPossibleInAdvance() {
                    return false;
                }

                @Nullable
                public IdLookup idLookup() {
                    return new IdLookup(){

                        public int lookupId(String name) {
                            return 0;
                        }
                    };
                }

                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }

                @Nullable
                public Object getObject() {
                    return this.lookupName(0);
                }

                public Class classOfObject() {
                    return String.class;
                }

                public boolean isNull() {
                    return this.val$selector.isNull();
                }
            };
            return dimensionSpec.decorate(dimensionSelector);
        }

        public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
            String subColumn = (String)VirtualColumns.splitColumnName((String)columnName).rhs;
            Long boxed = subColumn == null ? null : Longs.tryParse((String)subColumn);
            final long theLong = boxed == null ? -1L : boxed;
            return new TestLongColumnSelector(){

                public long getLong() {
                    return theLong;
                }

                public boolean isNull() {
                    return false;
                }
            };
        }

        public ColumnCapabilities capabilities(String columnName) {
            return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.LONG);
        }

        public List<String> requiredColumns() {
            return ImmutableList.of();
        }

        public boolean usesDotNotation() {
            return true;
        }

        public byte[] getCacheKey() {
            throw new UnsupportedOperationException();
        }
    }
}

