/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.google.common.primitives.Ints;
import java.util.List;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.key.ByteRowKeyComparator;
import org.apache.druid.frame.key.FrameComparisonWidget;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.key.RowKeyReader;
import org.apache.druid.frame.key.SortColumn;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.read.FrameReaderUtils;
import org.apache.druid.frame.write.FrameWriterUtils;

public class FrameComparisonWidgetImpl
implements FrameComparisonWidget {
    private final Frame frame;
    private final FrameReader frameReader;
    private final Memory rowOffsetRegion;
    private final Memory dataRegion;
    private final int keyFieldCount;
    private final long firstFieldPosition;
    private final int[] ascDescRunLengths;

    private FrameComparisonWidgetImpl(Frame frame, FrameReader frameReader, Memory rowOffsetRegion, Memory dataRegion, int keyFieldCount, long firstFieldPosition, int[] ascDescRunLengths) {
        this.frame = frame;
        this.frameReader = frameReader;
        this.rowOffsetRegion = rowOffsetRegion;
        this.dataRegion = dataRegion;
        this.keyFieldCount = keyFieldCount;
        this.firstFieldPosition = firstFieldPosition;
        this.ascDescRunLengths = ascDescRunLengths;
    }

    public static FrameComparisonWidgetImpl create(Frame frame, FrameReader frameReader, List<SortColumn> sortColumns) {
        FrameWriterUtils.verifySortColumns(sortColumns, frameReader.signature());
        return new FrameComparisonWidgetImpl(FrameType.ROW_BASED.ensureType(frame), frameReader, frame.region(0), frame.region(1), sortColumns.size(), ByteRowKeyComparator.computeFirstFieldPosition(frameReader.signature().size()), ByteRowKeyComparator.computeAscDescRunLengths(sortColumns));
    }

    @Override
    public RowKey readKey(int row) {
        int i;
        int keyFieldPointersEndInRow = this.keyFieldCount * 4;
        if (this.keyFieldCount == 0) {
            return RowKey.empty();
        }
        long rowPosition = this.getRowPositionInDataRegion(row);
        int keyEndInRow = this.dataRegion.getInt(rowPosition + (long)(this.keyFieldCount - 1) * 4L);
        long keyLength = (long)keyEndInRow - this.firstFieldPosition;
        byte[] keyBytes = new byte[Ints.checkedCast((long)((long)(keyFieldPointersEndInRow + keyEndInRow) - this.firstFieldPosition))];
        int headerSizeAdjustment = (this.frameReader.signature().size() - this.keyFieldCount) * 4;
        for (i = 0; i < this.keyFieldCount; ++i) {
            int fieldEndPosition = this.dataRegion.getInt(rowPosition + 4L * (long)i);
            int adjustedFieldEndPosition = fieldEndPosition - headerSizeAdjustment;
            keyBytes[4 * i] = (byte)adjustedFieldEndPosition;
            keyBytes[4 * i + 1] = (byte)(adjustedFieldEndPosition >> 8);
            keyBytes[4 * i + 2] = (byte)(adjustedFieldEndPosition >> 16);
            keyBytes[4 * i + 3] = (byte)(adjustedFieldEndPosition >> 24);
        }
        i = 0;
        while ((long)i < keyLength) {
            keyBytes[keyFieldPointersEndInRow + i] = this.dataRegion.getByte(rowPosition + this.firstFieldPosition + (long)i);
            ++i;
        }
        return RowKey.wrap(keyBytes);
    }

    @Override
    public int compare(int row, RowKey key) {
        byte[] keyArray = key.array();
        long rowPosition = this.getRowPositionInDataRegion(row);
        long comparableBytesStartPositionInRow = this.firstFieldPosition;
        int keyComparableBytesStartPosition = 4 * this.keyFieldCount;
        boolean ascending = true;
        int field = 0;
        for (int numFields : this.ascDescRunLengths) {
            if (numFields > 0) {
                int keyComparableBytesEndPosition;
                int keyComparableBytesLength;
                int nextField = field + numFields;
                long comparableBytesEndPositionInRow = this.getFieldEndPositionInRow(rowPosition, nextField - 1);
                long comparableBytesLength = comparableBytesEndPositionInRow - comparableBytesStartPositionInRow;
                int cmp = FrameReaderUtils.compareMemoryToByteArrayUnsigned(this.dataRegion, rowPosition + comparableBytesStartPositionInRow, comparableBytesLength, keyArray, keyComparableBytesStartPosition, keyComparableBytesLength = (keyComparableBytesEndPosition = RowKeyReader.fieldEndPosition(keyArray, nextField - 1)) - keyComparableBytesStartPosition);
                if (cmp != 0) {
                    return ascending ? cmp : -cmp;
                }
                field += numFields;
                comparableBytesStartPositionInRow += comparableBytesLength;
                keyComparableBytesStartPosition += keyComparableBytesLength;
            }
            ascending = !ascending;
        }
        return 0;
    }

    @Override
    public int compare(int row, FrameComparisonWidget otherWidget, int otherRow) {
        FrameComparisonWidgetImpl otherWidgetImpl = (FrameComparisonWidgetImpl)otherWidget;
        long rowPosition = this.getRowPositionInDataRegion(row);
        long otherRowPosition = otherWidgetImpl.getRowPositionInDataRegion(otherRow);
        long comparableBytesStartPositionInRow = this.firstFieldPosition;
        long otherComparableBytesStartPositionInRow = this.firstFieldPosition;
        boolean ascending = true;
        int field = 0;
        for (int numFields : this.ascDescRunLengths) {
            if (numFields > 0) {
                int nextField = field + numFields;
                long comparableBytesEndPositionInRow = this.getFieldEndPositionInRow(rowPosition, nextField - 1);
                long otherComparableBytesEndPositionInRow = otherWidgetImpl.getFieldEndPositionInRow(otherRowPosition, nextField - 1);
                long comparableBytesLength = comparableBytesEndPositionInRow - comparableBytesStartPositionInRow;
                long otherComparableBytesLength = otherComparableBytesEndPositionInRow - otherComparableBytesStartPositionInRow;
                int cmp = FrameReaderUtils.compareMemoryUnsigned(this.dataRegion, rowPosition + comparableBytesStartPositionInRow, comparableBytesLength, otherWidgetImpl.getDataRegion(), otherRowPosition + otherComparableBytesStartPositionInRow, otherComparableBytesLength);
                if (cmp != 0) {
                    return ascending ? cmp : -cmp;
                }
                field += numFields;
                comparableBytesStartPositionInRow += comparableBytesLength;
                otherComparableBytesStartPositionInRow += otherComparableBytesLength;
            }
            ascending = !ascending;
        }
        return 0;
    }

    long getRowPositionInDataRegion(int logicalRow) {
        int physicalRowNumber = this.frame.physicalRow(logicalRow);
        if (physicalRowNumber == 0) {
            return 0L;
        }
        return this.rowOffsetRegion.getLong(8L * (long)(physicalRowNumber - 1));
    }

    long getFieldEndPositionInRow(long rowPosition, int fieldNumber) {
        assert (fieldNumber >= 0 && fieldNumber < this.frameReader.signature().size());
        return this.dataRegion.getInt(rowPosition + (long)fieldNumber * 4L);
    }

    Memory getDataRegion() {
        return this.dataRegion;
    }
}

