/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.FieldReaders;
import org.apache.druid.frame.field.RowMemoryFieldPointer;
import org.apache.druid.frame.field.RowReader;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.segment.row.ConstantFrameRowPointer;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;

public class RowKeyReader {
    private final RowSignature signature;
    private final RowReader rowReader;

    private RowKeyReader(RowSignature signature, RowReader rowReader) {
        this.signature = signature;
        this.rowReader = rowReader;
    }

    public static RowKeyReader create(RowSignature signature) {
        ArrayList<FieldReader> fieldReaders = new ArrayList<FieldReader>(signature.size());
        for (String columnName : signature.getColumnNames()) {
            ColumnCapabilities capabilities = signature.getColumnCapabilities(columnName);
            ColumnType columnType = ((ColumnCapabilities)Preconditions.checkNotNull((Object)capabilities, (String)"Type for column [%s]", (Object[])new Object[]{columnName})).toColumnType();
            fieldReaders.add(FieldReaders.create(columnName, columnType));
        }
        return new RowKeyReader(signature, new RowReader(fieldReaders));
    }

    public Object read(RowKey key, int fieldNumber) {
        return this.rowReader.readField(Memory.wrap((byte[])key.array()), 0L, key.array().length, fieldNumber);
    }

    public List<Object> read(RowKey key) {
        return this.rowReader.readRow(Memory.wrap((byte[])key.array()), 0L, key.array().length);
    }

    public boolean hasMultipleValues(RowKey key, int fieldNumber) {
        ColumnType columnType = this.signature.getColumnType(fieldNumber).get();
        if (columnType.isNumeric() || columnType.is((TypeDescriptor)ValueType.COMPLEX)) {
            return false;
        }
        Memory keyMemory = Memory.wrap((byte[])key.array());
        RowMemoryFieldPointer fieldPointer = new RowMemoryFieldPointer(keyMemory, new ConstantFrameRowPointer(0L, keyMemory.getCapacity()), fieldNumber, this.rowReader.fieldCount());
        if (columnType.is((TypeDescriptor)ValueType.STRING)) {
            DimensionSelector selector = this.rowReader.fieldReader(fieldNumber).makeDimensionSelector(keyMemory, fieldPointer, null);
            return selector.getRow().size() > 1;
        }
        ColumnValueSelector<?> selector = this.rowReader.fieldReader(fieldNumber).makeColumnValueSelector(keyMemory, fieldPointer);
        return selector.getObject() instanceof List;
    }

    public RowKeyReader trimmedKeyReader(int trimmedFieldCount) {
        RowSignature.Builder newSignature = RowSignature.builder();
        if (trimmedFieldCount > this.signature.size()) {
            throw new IAE("Cannot trim to [%,d] fields, only have [%,d] fields", new Object[]{trimmedFieldCount, this.signature});
        }
        for (int i = 0; i < trimmedFieldCount; ++i) {
            String columnName = this.signature.getColumnName(i);
            ColumnType columnType = (ColumnType)Preconditions.checkNotNull(this.signature.getColumnType(i).orElse(null), (String)"Type for column [%s]", (Object[])new Object[]{columnName});
            newSignature.add(columnName, columnType);
        }
        return RowKeyReader.create(newSignature.build());
    }

    public RowKey trim(RowKey key, int trimmedFieldCount) {
        if (trimmedFieldCount == 0) {
            return RowKey.empty();
        }
        if (trimmedFieldCount == this.rowReader.fieldCount()) {
            return key;
        }
        if (trimmedFieldCount > this.rowReader.fieldCount()) {
            throw new IAE("Cannot trim to [%,d] fields, only have [%,d] fields", new Object[]{trimmedFieldCount, this.rowReader.fieldCount()});
        }
        byte[] keyBytes = key.array();
        int headerSize = 4 * this.rowReader.fieldCount();
        int trimmedHeaderSize = 4 * trimmedFieldCount;
        int trimmedFieldsSize = RowKeyReader.fieldEndPosition(keyBytes, trimmedFieldCount - 1) - headerSize;
        byte[] trimmedBytes = new byte[trimmedHeaderSize + trimmedFieldsSize];
        for (int i = 0; i < trimmedFieldCount; ++i) {
            int fieldEndPosition = RowKeyReader.fieldEndPosition(keyBytes, i) - (headerSize - trimmedHeaderSize);
            trimmedBytes[4 * i] = (byte)fieldEndPosition;
            trimmedBytes[4 * i + 1] = (byte)(fieldEndPosition >> 8);
            trimmedBytes[4 * i + 2] = (byte)(fieldEndPosition >> 16);
            trimmedBytes[4 * i + 3] = (byte)(fieldEndPosition >> 24);
        }
        System.arraycopy(keyBytes, headerSize, trimmedBytes, trimmedHeaderSize, trimmedFieldsSize);
        return RowKey.wrap(trimmedBytes);
    }

    public static int fieldEndPosition(byte[] keyBytes, int fieldNumber) {
        return Ints.fromBytes((byte)keyBytes[fieldNumber * 4 + 3], (byte)keyBytes[fieldNumber * 4 + 2], (byte)keyBytes[fieldNumber * 4 + 1], (byte)keyBytes[fieldNumber * 4]);
    }
}

