/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.AppendableMemory;
import org.apache.druid.frame.allocation.MemoryRange;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.key.SortColumn;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.write.FrameSort;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.utils.CloseableUtils;

public class RowBasedFrameWriter
implements FrameWriter {
    public static final int ROW_OFFSET_REGION = 0;
    public static final int ROW_DATA_REGION = 1;
    public static final int NUM_REGIONS = 2;
    static final int BASE_DATA_ALLOCATION_SIZE = 8192;
    private final RowSignature signature;
    private final List<SortColumn> sortColumns;
    private final List<FieldWriter> fieldWriters;
    private final Supplier<MemoryRange<Memory>> rowMemorySupplier;
    @Nullable
    private final AppendableMemory rowOrderMemory;
    private final AppendableMemory rowOffsetMemory;
    private final AppendableMemory dataMemory;
    private int numRows = 0;
    private boolean written = false;

    public RowBasedFrameWriter(RowSignature signature, List<SortColumn> sortColumns, List<FieldWriter> fieldWriters, @Nullable Supplier<MemoryRange<Memory>> rowMemorySupplier, @Nullable AppendableMemory rowOrderMemory, AppendableMemory rowOffsetMemory, AppendableMemory dataMemory) {
        this.signature = signature;
        this.sortColumns = sortColumns;
        this.rowMemorySupplier = rowMemorySupplier;
        this.fieldWriters = fieldWriters;
        this.rowOrderMemory = rowOrderMemory;
        this.rowOffsetMemory = rowOffsetMemory;
        this.dataMemory = dataMemory;
        FrameWriterUtils.verifySortColumns(sortColumns, signature);
        Set<String> disallowedFieldNames = FrameWriterUtils.findDisallowedFieldNames(signature);
        if (!disallowedFieldNames.isEmpty()) {
            throw new IAE("Disallowed field names: %s", new Object[]{disallowedFieldNames});
        }
    }

    @Override
    public boolean addSelection() {
        if (this.written) {
            throw new ISE("Cannot modify after writing", new Object[0]);
        }
        if (this.numRows == Integer.MAX_VALUE) {
            return false;
        }
        if (this.rowOrderMemory != null && !this.rowOrderMemory.reserveAdditional(4)) {
            return false;
        }
        if (!this.rowOffsetMemory.reserveAdditional(8)) {
            return false;
        }
        try {
            if (!this.writeData()) {
                return false;
            }
        }
        catch (Exception e) {
            throw new ParseException("", (Throwable)e, "Unable to add the row to the frame. Type conversion might be required.", new Object[0]);
        }
        MemoryRange<WritableMemory> rowOffsetCursor = this.rowOffsetMemory.cursor();
        rowOffsetCursor.memory().putLong(rowOffsetCursor.start(), this.dataMemory.size());
        this.rowOffsetMemory.advanceCursor(8);
        if (this.rowOrderMemory != null) {
            MemoryRange<WritableMemory> rowOrderCursor = this.rowOrderMemory.cursor();
            rowOrderCursor.memory().putInt(rowOrderCursor.start(), this.numRows);
            this.rowOrderMemory.advanceCursor(4);
        }
        ++this.numRows;
        return true;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public long getTotalSize() {
        return 18L + this.computeRowOrderSize() + 16L + this.rowOffsetMemory.size() + this.dataMemory.size();
    }

    @Override
    public long writeTo(WritableMemory memory, long startPosition) {
        if (this.written) {
            throw new ISE("Cannot write twice", new Object[0]);
        }
        long totalSize = this.getTotalSize();
        long currentPosition = startPosition;
        currentPosition += FrameWriterUtils.writeFrameHeader(memory, startPosition, FrameType.ROW_BASED, totalSize, this.numRows, 2, this.mustSort());
        if (this.mustSort()) {
            currentPosition += this.rowOrderMemory.writeTo(memory, currentPosition);
        }
        long regionsStart = 18L + this.computeRowOrderSize() + 16L;
        memory.putLong(currentPosition, regionsStart + this.rowOffsetMemory.size());
        memory.putLong(currentPosition + 8L, regionsStart + this.rowOffsetMemory.size() + this.dataMemory.size());
        currentPosition += 16L;
        currentPosition += this.rowOffsetMemory.writeTo(memory, currentPosition);
        currentPosition += this.dataMemory.writeTo(memory, currentPosition);
        if (currentPosition != totalSize) {
            throw new ISE("Expected to write [%,d] bytes, but wrote [%,d] bytes.", new Object[]{totalSize, currentPosition});
        }
        if (this.mustSort()) {
            FrameSort.sort(Frame.wrap((Memory)memory), FrameReader.create(this.signature), this.sortColumns);
        }
        this.written = true;
        return totalSize;
    }

    @Override
    public void close() {
        CloseableUtils.closeAndWrapExceptions(() -> {
            Closer closer = Closer.create();
            closer.register((Closeable)this.rowOrderMemory);
            closer.register((Closeable)this.rowOffsetMemory);
            closer.register((Closeable)this.dataMemory);
            if (this.fieldWriters != null) {
                closer.registerAll(this.fieldWriters);
            }
            closer.close();
        });
    }

    private long computeRowOrderSize() {
        return this.mustSort() ? this.rowOrderMemory.size() : 0L;
    }

    private boolean mustSort() {
        return this.rowOrderMemory != null;
    }

    private boolean writeData() {
        MemoryRange<Memory> rowMemory;
        if (this.rowMemorySupplier != null && (rowMemory = this.rowMemorySupplier.get()) != null) {
            return this.writeDataUsingRowMemory(rowMemory);
        }
        return this.writeDataUsingFieldWriters();
    }

    private boolean writeDataUsingRowMemory(MemoryRange<Memory> rowMemory) {
        if (!this.dataMemory.reserveAdditional(Ints.checkedCast((long)rowMemory.length()))) {
            return false;
        }
        MemoryRange<WritableMemory> cursor = this.dataMemory.cursor();
        rowMemory.memory().copyTo(rowMemory.start(), cursor.memory(), cursor.start(), rowMemory.length());
        this.dataMemory.advanceCursor(Ints.checkedCast((long)rowMemory.length()));
        return true;
    }

    private boolean writeDataUsingFieldWriters() {
        assert (this.fieldWriters != null);
        long fieldPositionBytes = (long)this.fieldWriters.size() * 4L;
        if (this.numRows == 0 && !this.dataMemory.reserveAdditional(Ints.checkedCast((long)Math.max(fieldPositionBytes, 8192L)))) {
            return false;
        }
        MemoryRange<WritableMemory> dataCursor = this.dataMemory.cursor();
        long remainingInBlock = dataCursor.length();
        long bytesWritten = fieldPositionBytes;
        int reserveMultiple = 1;
        for (int i = 0; i < this.fieldWriters.size(); ++i) {
            FieldWriter fieldWriter = this.fieldWriters.get(i);
            long writeResult = fieldWriter.writeTo(dataCursor.memory(), dataCursor.start() + bytesWritten, remainingInBlock - bytesWritten);
            if (writeResult < 0L) {
                i = -1;
                if (!this.dataMemory.reserveAdditional(Ints.checkedCast((long)(8192L * (long)(reserveMultiple *= 2))))) {
                    return false;
                }
                dataCursor = this.dataMemory.cursor();
                remainingInBlock = dataCursor.length();
                bytesWritten = fieldPositionBytes;
                continue;
            }
            dataCursor.memory().putInt(dataCursor.start() + (long)i * 4L, Ints.checkedCast((long)(bytesWritten += writeResult)));
        }
        this.dataMemory.advanceCursor(Ints.checkedCast((long)bytesWritten));
        return true;
    }
}

