/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.columnar;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.AppendableMemory;
import org.apache.druid.frame.allocation.MemoryRange;
import org.apache.druid.frame.key.SortColumn;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.write.FrameSort;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.frame.write.columnar.FrameColumnWriter;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.segment.column.RowSignature;

public class ColumnarFrameWriter
implements FrameWriter {
    private final RowSignature signature;
    private final List<SortColumn> sortColumns;
    @Nullable
    private final AppendableMemory rowOrderMemory;
    private final List<FrameColumnWriter> columnWriters;
    private int numRows = 0;
    private boolean written = false;

    public ColumnarFrameWriter(RowSignature signature, List<SortColumn> sortColumns, @Nullable AppendableMemory rowOrderMemory, List<FrameColumnWriter> columnWriters) {
        this.signature = signature;
        this.sortColumns = sortColumns;
        this.rowOrderMemory = rowOrderMemory;
        this.columnWriters = columnWriters;
    }

    @Override
    public boolean addSelection() {
        int i;
        if (this.written) {
            throw new ISE("Cannot modify after writing", new Object[0]);
        }
        if (this.numRows == Integer.MAX_VALUE) {
            return false;
        }
        if (this.rowOrderMemory != null && !this.rowOrderMemory.reserveAdditional(4)) {
            return false;
        }
        try {
            for (i = 0; i < this.columnWriters.size() && this.columnWriters.get(i).addSelection(); ++i) {
            }
        }
        catch (Exception e) {
            throw new ParseException("", (Throwable)e, "Unable to add the row to the frame. Type conversion might be required.", new Object[0]);
        }
        if (i < this.columnWriters.size()) {
            for (int j = 0; j < i; ++j) {
                this.columnWriters.get(j).undo();
            }
            return false;
        }
        if (this.rowOrderMemory != null) {
            MemoryRange<WritableMemory> rowOrderCursor = this.rowOrderMemory.cursor();
            rowOrderCursor.memory().putInt(rowOrderCursor.start(), this.numRows);
            this.rowOrderMemory.advanceCursor(4);
        }
        ++this.numRows;
        return true;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public long getTotalSize() {
        return 18L + this.computeRowOrderSize() + this.computeRegionMapSize() + this.computeDataSize();
    }

    @Override
    public long writeTo(WritableMemory memory, long startPosition) {
        if (this.written) {
            throw new ISE("Cannot write twice", new Object[0]);
        }
        long totalSize = this.getTotalSize();
        long currentPosition = startPosition;
        currentPosition += FrameWriterUtils.writeFrameHeader(memory, startPosition, FrameType.COLUMNAR, totalSize, this.numRows, this.columnWriters.size(), this.mustSort());
        if (this.mustSort()) {
            currentPosition += this.rowOrderMemory.writeTo(memory, currentPosition);
        }
        long columnEndPosition = 18L + this.computeRowOrderSize() + this.computeRegionMapSize();
        for (FrameColumnWriter writer : this.columnWriters) {
            memory.putLong(currentPosition, columnEndPosition += writer.size());
            currentPosition += 8L;
        }
        for (FrameColumnWriter writer : this.columnWriters) {
            currentPosition += writer.writeTo(memory, currentPosition);
        }
        if (currentPosition != totalSize) {
            throw new ISE("Expected to write [%,d] bytes, but wrote [%,d] bytes.", new Object[]{totalSize, currentPosition});
        }
        if (this.mustSort()) {
            FrameSort.sort(Frame.wrap((Memory)memory), FrameReader.create(this.signature), this.sortColumns);
        }
        this.written = true;
        return totalSize;
    }

    @Override
    public void close() {
        if (this.rowOrderMemory != null) {
            this.rowOrderMemory.close();
        }
        this.columnWriters.forEach(FrameColumnWriter::close);
    }

    private long computeRowOrderSize() {
        return this.mustSort() ? this.rowOrderMemory.size() : 0L;
    }

    private long computeRegionMapSize() {
        return (long)this.columnWriters.size() * 8L;
    }

    private long computeDataSize() {
        return this.columnWriters.stream().mapToLong(FrameColumnWriter::size).sum();
    }

    private boolean mustSort() {
        return this.rowOrderMemory != null;
    }
}

