/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.segment.SegmentReference;

public class LookupDataSource
implements DataSource {
    private final String lookupName;

    @JsonCreator
    public LookupDataSource(@JsonProperty(value="lookup") String lookupName) {
        this.lookupName = (String)Preconditions.checkNotNull((Object)lookupName, (Object)"lookup");
    }

    @Override
    public Set<String> getTableNames() {
        return Collections.emptySet();
    }

    @JsonProperty(value="lookup")
    public String getLookupName() {
        return this.lookupName;
    }

    @Override
    public List<DataSource> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public DataSource withChildren(List<DataSource> children) {
        if (!children.isEmpty()) {
            throw new IAE("Cannot accept children", new Object[0]);
        }
        return this;
    }

    @Override
    public boolean isCacheable(boolean isBroker) {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean isConcrete() {
        return true;
    }

    @Override
    public Function<SegmentReference, SegmentReference> createSegmentMapFunction(Query query, AtomicLong cpuTime) {
        return Function.identity();
    }

    @Override
    public DataSource withUpdatedDataSource(DataSource newSource) {
        return newSource;
    }

    @Override
    public byte[] getCacheKey() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupDataSource that = (LookupDataSource)o;
        return Objects.equals(this.lookupName, that.lookupName);
    }

    public int hashCode() {
        return Objects.hash(this.lookupName);
    }

    public String toString() {
        return "LookupDataSource{lookupName='" + this.lookupName + '\'' + '}';
    }
}

