/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.dimension;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.dimension.BaseFilteredDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ForwardingFilteredDimensionSelector;
import org.apache.druid.query.dimension.PredicateFilteredDimensionSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.IdMapping;

public class ListFilteredDimensionSpec
extends BaseFilteredDimensionSpec {
    private static final byte CACHE_TYPE_ID = 3;
    private final Set<String> values;
    private final boolean isWhitelist;

    public ListFilteredDimensionSpec(@JsonProperty(value="delegate") DimensionSpec delegate, @JsonProperty(value="values") Set<String> values, @JsonProperty(value="isWhitelist") Boolean isWhitelist) {
        super(delegate);
        Preconditions.checkArgument((values != null && values.size() > 0 ? 1 : 0) != 0, (Object)"values list must be non-empty");
        this.values = values;
        this.isWhitelist = isWhitelist == null ? true : isWhitelist;
    }

    @JsonProperty
    public Set<String> getValues() {
        return this.values;
    }

    @JsonProperty(value="isWhitelist")
    public boolean isWhitelist() {
        return this.isWhitelist;
    }

    @Override
    public DimensionSelector decorate(DimensionSelector selector) {
        if (selector == null) {
            return null;
        }
        if (this.isWhitelist) {
            return ListFilteredDimensionSpec.filterAllowList(this.values, selector);
        }
        return ListFilteredDimensionSpec.filterDenyList(this.values, selector);
    }

    public static IdMapping buildAllowListIdMapping(Set<String> values, int cardinality, @Nullable IdLookup idLookup, IndexedGetter<String> fn) {
        IdMapping.Builder builder = IdMapping.Builder.ofCardinality(values.size());
        if (idLookup != null) {
            for (String value : values) {
                int i = idLookup.lookupId(value);
                if (i < 0) continue;
                builder.addMapping(i);
            }
        } else {
            for (int i = 0; i < cardinality; ++i) {
                if (!values.contains(NullHandling.nullToEmptyIfNeeded((String)fn.get(i)))) continue;
                builder.addMapping(i);
            }
        }
        return builder.build();
    }

    public static IdMapping buildDenyListIdMapping(Set<String> values, int cardinality, IndexedGetter<String> fn) {
        IdMapping.Builder builder = IdMapping.Builder.ofCardinality(cardinality);
        for (int i = 0; i < cardinality; ++i) {
            if (values.contains(NullHandling.nullToEmptyIfNeeded((String)fn.get(i)))) continue;
            builder.addMapping(i);
        }
        return builder.build();
    }

    public static DimensionSelector filterAllowList(Set<String> values, DimensionSelector selector) {
        if (selector.getValueCardinality() < 0 || !selector.nameLookupPossibleInAdvance()) {
            return new PredicateFilteredDimensionSelector(selector, (Predicate<String>)Predicates.in(values));
        }
        IdMapping idMapping = ListFilteredDimensionSpec.buildAllowListIdMapping(values, selector.getValueCardinality(), selector.idLookup(), selector::lookupName);
        return new ForwardingFilteredDimensionSelector(selector, idMapping);
    }

    public static DimensionSelector filterDenyList(Set<String> values, DimensionSelector selector) {
        if (selector.getValueCardinality() < 0 || !selector.nameLookupPossibleInAdvance()) {
            return new PredicateFilteredDimensionSelector(selector, (Predicate<String>)((Predicate)input -> !values.contains(input)));
        }
        IdMapping idMapping = ListFilteredDimensionSpec.buildDenyListIdMapping(values, selector.getValueCardinality(), selector::lookupName);
        return new ForwardingFilteredDimensionSelector(selector, idMapping);
    }

    public byte[] getCacheKey() {
        byte[] delegateCacheKey = this.delegate.getCacheKey();
        byte[][] valuesBytes = new byte[this.values.size()][];
        int valuesBytesSize = 0;
        int index = 0;
        for (String value : this.values) {
            valuesBytes[index] = StringUtils.toUtf8((String)value);
            valuesBytesSize += valuesBytes[index].length + 1;
            ++index;
        }
        ByteBuffer filterCacheKey = ByteBuffer.allocate(3 + delegateCacheKey.length + valuesBytesSize).put((byte)3).put(delegateCacheKey).put((byte)(this.isWhitelist ? 1 : 0)).put((byte)-1);
        for (byte[] bytes : valuesBytes) {
            filterCacheKey.put(bytes).put((byte)-1);
        }
        return filterCacheKey.array();
    }

    @Override
    public DimensionSpec withDimension(String newDimension) {
        return new ListFilteredDimensionSpec(this.delegate.withDimension(newDimension), this.values, this.isWhitelist);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListFilteredDimensionSpec that = (ListFilteredDimensionSpec)o;
        return Objects.equals(this.getDelegate(), that.getDelegate()) && this.isWhitelist == that.isWhitelist && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.getDelegate(), this.values, this.isWhitelist);
    }

    public String toString() {
        return "ListFilteredDimensionSpec{values=" + this.values + ", isWhitelist=" + this.isWhitelist + '}';
    }

    @FunctionalInterface
    public static interface IndexedGetter<T> {
        @Nullable
        public T get(int var1);
    }
}

