/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.lookup.LookupExtractor;

@JsonTypeName(value="map")
public class MapLookupExtractor
extends LookupExtractor {
    private static final long HEAP_ENTRY_OVERHEAD = 80L;
    private final Map<String, String> map;
    private final boolean isOneToOne;

    @JsonCreator
    public MapLookupExtractor(@JsonProperty(value="map") Map<String, String> map, @JsonProperty(value="isOneToOne") boolean isOneToOne) {
        this.map = (Map)Preconditions.checkNotNull(map, (Object)"map");
        this.isOneToOne = isOneToOne;
    }

    public static <K, V> long estimateHeapFootprint(@Nullable Map<K, V> map) {
        if (map == null) {
            return 0L;
        }
        int numEntries = map.size();
        long numChars = 0L;
        for (Map.Entry<K, V> sEntry : map.entrySet()) {
            K key = sEntry.getKey();
            V value = sEntry.getValue();
            if (key instanceof String) {
                numChars += (long)((String)key).length();
            }
            if (!(value instanceof String)) continue;
            numChars += (long)((String)value).length();
        }
        return 80L * (long)numEntries + numChars * 2L;
    }

    @JsonProperty
    public Map<String, String> getMap() {
        return ImmutableMap.copyOf(this.map);
    }

    @Override
    @Nullable
    public String apply(@Nullable String key) {
        String keyEquivalent = NullHandling.nullToEmptyIfNeeded((String)key);
        if (keyEquivalent == null) {
            return null;
        }
        return NullHandling.emptyToNullIfNeeded((String)this.map.get(keyEquivalent));
    }

    @Override
    public List<String> unapply(@Nullable String value) {
        String valueToLookup = NullHandling.nullToEmptyIfNeeded((String)value);
        if (valueToLookup == null) {
            return Collections.emptyList();
        }
        return this.map.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(valueToLookup)).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="isOneToOne")
    public boolean isOneToOne() {
        return this.isOneToOne;
    }

    @Override
    public byte[] getCacheKey() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                if (!Strings.isNullOrEmpty((String)key)) {
                    outputStream.write(StringUtils.toUtf8((String)key));
                }
                outputStream.write(-1);
                if (!Strings.isNullOrEmpty((String)val)) {
                    outputStream.write(StringUtils.toUtf8((String)val));
                }
                outputStream.write(-1);
            }
            return outputStream.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean canIterate() {
        return true;
    }

    @Override
    public boolean canGetKeySet() {
        return true;
    }

    @Override
    public Iterable<Map.Entry<String, String>> iterable() {
        return this.map.entrySet();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public long estimateHeapFootprint() {
        return MapLookupExtractor.estimateHeapFootprint(this.map);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapLookupExtractor that = (MapLookupExtractor)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }
}

