/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.MappedSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.SubqueryQueryRunner;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.aggregation.MetricManipulatorFns;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.groupby.DefaultGroupByQueryMetricsFactory;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryMetrics;
import org.apache.druid.query.groupby.GroupByQueryMetricsFactory;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.resource.GroupByQueryResource;
import org.apache.druid.query.groupby.strategy.GroupByStrategy;
import org.apache.druid.query.groupby.strategy.GroupByStrategySelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.joda.time.DateTime;

public class GroupByQueryQueryToolChest
extends QueryToolChest<ResultRow, GroupByQuery> {
    private static final byte GROUPBY_QUERY = 20;
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private static final TypeReference<ResultRow> TYPE_REFERENCE = new TypeReference<ResultRow>(){};
    public static final String GROUP_BY_MERGE_KEY = "groupByMerge";
    private final GroupByStrategySelector strategySelector;
    private final GroupByQueryConfig queryConfig;
    private final GroupByQueryMetricsFactory queryMetricsFactory;

    @VisibleForTesting
    public GroupByQueryQueryToolChest(GroupByStrategySelector strategySelector) {
        this(strategySelector, (Supplier<GroupByQueryConfig>)((Supplier)GroupByQueryConfig::new), DefaultGroupByQueryMetricsFactory.instance());
    }

    @Inject
    public GroupByQueryQueryToolChest(GroupByStrategySelector strategySelector, Supplier<GroupByQueryConfig> queryConfigSupplier, GroupByQueryMetricsFactory queryMetricsFactory) {
        this.strategySelector = strategySelector;
        this.queryConfig = (GroupByQueryConfig)queryConfigSupplier.get();
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public QueryRunner<ResultRow> mergeResults(QueryRunner<ResultRow> runner) {
        return (queryPlus, responseContext) -> {
            if (queryPlus.getQuery().context().isBySegment()) {
                return runner.run(queryPlus, responseContext);
            }
            GroupByQuery groupByQuery = (GroupByQuery)queryPlus.getQuery();
            if (this.strategySelector.strategize(groupByQuery).doMergeResults(groupByQuery)) {
                return this.initAndMergeGroupByResults(groupByQuery, runner, responseContext);
            }
            return runner.run(queryPlus, responseContext);
        };
    }

    @Override
    public BinaryOperator<ResultRow> createMergeFn(Query<ResultRow> query) {
        return this.strategySelector.strategize((GroupByQuery)query).createMergeFn(query);
    }

    @Override
    public Comparator<ResultRow> createResultComparator(Query<ResultRow> query) {
        return this.strategySelector.strategize((GroupByQuery)query).createResultComparator(query);
    }

    private Sequence<ResultRow> initAndMergeGroupByResults(GroupByQuery query, QueryRunner<ResultRow> runner, ResponseContext context) {
        GroupByStrategy groupByStrategy = this.strategySelector.strategize(query);
        GroupByQueryResource resource = groupByStrategy.prepareResource(query);
        try {
            Sequence<ResultRow> mergedSequence = this.mergeGroupByResults(groupByStrategy, query, resource, runner, context);
            return Sequences.withBaggage(mergedSequence, (Closeable)resource);
        }
        catch (Exception e) {
            resource.close();
            throw e;
        }
    }

    private Sequence<ResultRow> mergeGroupByResults(GroupByStrategy groupByStrategy, GroupByQuery query, GroupByQueryResource resource, QueryRunner<ResultRow> runner, ResponseContext context) {
        if (GroupByQueryQueryToolChest.isNestedQueryPushDown(query, groupByStrategy)) {
            return this.mergeResultsWithNestedQueryPushDown(groupByStrategy, query, resource, runner, context);
        }
        return this.mergeGroupByResultsWithoutPushDown(groupByStrategy, query, resource, runner, context);
    }

    private Sequence<ResultRow> mergeGroupByResultsWithoutPushDown(GroupByStrategy groupByStrategy, GroupByQuery query, GroupByQueryResource resource, QueryRunner<ResultRow> runner, ResponseContext context) {
        DataSource dataSource = query.getDataSource();
        if (dataSource instanceof QueryDataSource) {
            GroupByQuery subquery;
            try {
                TreeMap<String, Object> subqueryContext = new TreeMap<String, Object>();
                if (query.getContext() != null) {
                    for (Map.Entry<String, Object> entry : query.getContext().entrySet()) {
                        if (entry.getValue() == null) continue;
                        subqueryContext.put(entry.getKey(), entry.getValue());
                    }
                }
                if (((QueryDataSource)dataSource).getQuery().getContext() != null) {
                    subqueryContext.putAll(((QueryDataSource)dataSource).getQuery().getContext());
                }
                subqueryContext.put("sortByDimsFirst", false);
                subquery = (GroupByQuery)((QueryDataSource)dataSource).getQuery().withOverriddenContext(subqueryContext);
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Subqueries must be of type 'group by'");
            }
            Sequence<ResultRow> subqueryResult = this.mergeGroupByResults(groupByStrategy, (GroupByQuery)subquery.withOverriddenContext((Map)ImmutableMap.of((Object)"sortResults", (Object)false)), resource, runner, context);
            Sequence<ResultRow> finalizingResults = this.finalizeSubqueryResults(subqueryResult, subquery);
            if (query.getSubtotalsSpec() != null) {
                return groupByStrategy.processSubtotalsSpec(query, resource, groupByStrategy.processSubqueryResult(subquery, query, resource, finalizingResults, false));
            }
            return groupByStrategy.applyPostProcessing(groupByStrategy.processSubqueryResult(subquery, query, resource, finalizingResults, false), query);
        }
        if (query.getSubtotalsSpec() != null) {
            return groupByStrategy.processSubtotalsSpec(query, resource, groupByStrategy.mergeResults(runner, query.withSubtotalsSpec(null), context));
        }
        return groupByStrategy.applyPostProcessing(groupByStrategy.mergeResults(runner, query, context), query);
    }

    private Sequence<ResultRow> mergeResultsWithNestedQueryPushDown(GroupByStrategy groupByStrategy, GroupByQuery query, GroupByQueryResource resource, QueryRunner<ResultRow> runner, ResponseContext context) {
        Sequence<ResultRow> pushDownQueryResults = groupByStrategy.mergeResults(runner, query, context);
        Sequence<ResultRow> finalizedResults = this.finalizeSubqueryResults(pushDownQueryResults, query);
        GroupByQuery rewrittenQuery = this.rewriteNestedQueryForPushDown(query);
        return groupByStrategy.applyPostProcessing(groupByStrategy.processSubqueryResult(query, rewrittenQuery, resource, finalizedResults, true), query);
    }

    @VisibleForTesting
    GroupByQuery rewriteNestedQueryForPushDown(GroupByQuery query) {
        return query.withAggregatorSpecs(Lists.transform(query.getAggregatorSpecs(), agg -> agg.getCombiningFactory())).withDimensionSpecs(Lists.transform(query.getDimensions(), dim -> new DefaultDimensionSpec(dim.getOutputName(), dim.getOutputName(), dim.getOutputType())));
    }

    private Sequence<ResultRow> finalizeSubqueryResults(Sequence<ResultRow> subqueryResult, GroupByQuery subquery) {
        MappedSequence finalizingResults = subquery.context().isFinalize(false) ? new MappedSequence(subqueryResult, arg_0 -> this.makePreComputeManipulatorFn(subquery, MetricManipulatorFns.finalizing()).apply(arg_0)) : subqueryResult;
        return finalizingResults;
    }

    public static boolean isNestedQueryPushDown(GroupByQuery q, GroupByStrategy strategy) {
        return q.getDataSource() instanceof QueryDataSource && q.context().getBoolean("forcePushDownNestedQuery", false) && q.getSubtotalsSpec() == null && strategy.supportsNestedQueryPushDown();
    }

    public GroupByQueryMetrics makeMetrics(GroupByQuery query) {
        GroupByQueryMetrics queryMetrics = this.queryMetricsFactory.makeMetrics();
        queryMetrics.query(query);
        return queryMetrics;
    }

    @Override
    public Function<ResultRow, ResultRow> makePreComputeManipulatorFn(GroupByQuery query, MetricManipulationFn fn) {
        if (MetricManipulatorFns.identity().equals(fn)) {
            return Functions.identity();
        }
        return row -> {
            ResultRow newRow = row.copy();
            List<AggregatorFactory> aggregatorSpecs = query.getAggregatorSpecs();
            int aggregatorStart = query.getResultRowAggregatorStart();
            for (int i = 0; i < aggregatorSpecs.size(); ++i) {
                AggregatorFactory agg = aggregatorSpecs.get(i);
                newRow.set(aggregatorStart + i, fn.manipulate(agg, row.get(aggregatorStart + i)));
            }
            return newRow;
        };
    }

    @Override
    public Function<ResultRow, ResultRow> makePostComputeManipulatorFn(GroupByQuery query, MetricManipulationFn fn) {
        BitSet optimizedDims = GroupByQueryQueryToolChest.extractionsToRewrite(query);
        Function<ResultRow, ResultRow> preCompute = this.makePreComputeManipulatorFn(query, fn);
        if (optimizedDims.isEmpty()) {
            return preCompute;
        }
        List<DimensionSpec> dimensions = query.getDimensions();
        ArrayList<ExtractionFn> extractionFns = new ArrayList<ExtractionFn>(dimensions.size());
        for (int i = 0; i < dimensions.size(); ++i) {
            DimensionSpec dimensionSpec = dimensions.get(i);
            ExtractionFn extractionFnToAdd = optimizedDims.get(i) ? dimensionSpec.getExtractionFn() : null;
            extractionFns.add(extractionFnToAdd);
        }
        int dimensionStart = query.getResultRowDimensionStart();
        return row -> {
            ResultRow newRow = (ResultRow)preCompute.apply(row);
            if (newRow == row) {
                newRow = row.copy();
            }
            int i = optimizedDims.nextSetBit(0);
            while (i >= 0) {
                newRow.set(dimensionStart + i, ((ExtractionFn)extractionFns.get(i)).apply(newRow.get(dimensionStart + i)));
                i = optimizedDims.nextSetBit(i + 1);
            }
            return newRow;
        };
    }

    @Override
    public TypeReference<ResultRow> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public ObjectMapper decorateObjectMapper(ObjectMapper objectMapper, final GroupByQuery query) {
        final boolean resultAsArray = query.context().getBoolean("resultAsArray", false);
        if (resultAsArray && !this.queryConfig.isIntermediateResultAsMapCompat()) {
            return objectMapper;
        }
        JsonSerializer<ResultRow> serializer = new JsonSerializer<ResultRow>(){

            public void serialize(ResultRow resultRow, JsonGenerator jg, SerializerProvider serializers) throws IOException {
                if (resultAsArray) {
                    JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)jg, (SerializerProvider)serializers, (Object)resultRow.getArray());
                } else {
                    JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)jg, (SerializerProvider)serializers, (Object)resultRow.toMapBasedRow(query));
                }
            }
        };
        JsonDeserializer<ResultRow> deserializer = new JsonDeserializer<ResultRow>(){

            public ResultRow deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                if (jp.isExpectedStartObjectToken()) {
                    Row row = (Row)jp.readValueAs(Row.class);
                    return ResultRow.fromLegacyRow(row, query);
                }
                return ResultRow.of((Object[])jp.readValueAs(Object[].class));
            }
        };
        ObjectMapper newObjectMapper = objectMapper.copy();
        class GroupByResultRowModule
        extends SimpleModule {
            final /* synthetic */ JsonSerializer val$serializer;
            final /* synthetic */ JsonDeserializer val$deserializer;

            GroupByResultRowModule() {
                this.val$serializer = jsonSerializer;
                this.val$deserializer = jsonDeserializer;
                this.addSerializer(ResultRow.class, this.val$serializer);
                this.addDeserializer(ResultRow.class, this.val$deserializer);
            }
        }
        newObjectMapper.registerModule((Module)new GroupByResultRowModule());
        return newObjectMapper;
    }

    @Override
    public QueryRunner<ResultRow> preMergeQueryDecoration(final QueryRunner<ResultRow> runner) {
        return new SubqueryQueryRunner<ResultRow>(new QueryRunner<ResultRow>(){

            @Override
            public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
                GroupByQuery groupByQuery = (GroupByQuery)queryPlus.getQuery();
                ArrayList<DimensionSpec> dimensionSpecs = new ArrayList<DimensionSpec>();
                BitSet optimizedDimensions = GroupByQueryQueryToolChest.extractionsToRewrite(groupByQuery);
                List<DimensionSpec> dimensions = groupByQuery.getDimensions();
                for (int i = 0; i < dimensions.size(); ++i) {
                    DimensionSpec dimensionSpec = dimensions.get(i);
                    if (optimizedDimensions.get(i)) {
                        dimensionSpecs.add(new DefaultDimensionSpec(dimensionSpec.getDimension(), dimensionSpec.getOutputName()));
                        continue;
                    }
                    dimensionSpecs.add(dimensionSpec);
                }
                return runner.run(queryPlus.withQuery(groupByQuery.withDimensionSpecs(dimensionSpecs)), responseContext);
            }
        });
    }

    @Override
    public CacheStrategy<ResultRow, Object, GroupByQuery> getCacheStrategy(final GroupByQuery query) {
        return new CacheStrategy<ResultRow, Object, GroupByQuery>(){
            private static final byte CACHE_STRATEGY_VERSION = 1;
            private final List<AggregatorFactory> aggs;
            private final List<DimensionSpec> dims;
            {
                this.aggs = query.getAggregatorSpecs();
                this.dims = query.getDimensions();
            }

            @Override
            public boolean isCacheable(GroupByQuery query2, boolean willMergeRunners) {
                return GroupByQueryQueryToolChest.this.strategySelector.strategize(query2).isCacheable(willMergeRunners);
            }

            @Override
            public byte[] computeCacheKey(GroupByQuery query2) {
                CacheKeyBuilder builder = new CacheKeyBuilder(20).appendByte((byte)1).appendCacheable((Cacheable)query2.getGranularity()).appendCacheable((Cacheable)query2.getDimFilter()).appendCacheables(query2.getAggregatorSpecs()).appendCacheables(query2.getDimensions()).appendCacheable((Cacheable)query2.getVirtualColumns());
                if (query2.isApplyLimitPushDown()) {
                    builder.appendCacheable((Cacheable)query2.getLimitSpec());
                }
                return builder.build();
            }

            @Override
            public byte[] computeResultLevelCacheKey(GroupByQuery query2) {
                CacheKeyBuilder builder = new CacheKeyBuilder(20).appendByte((byte)1).appendCacheable((Cacheable)query2.getGranularity()).appendCacheable((Cacheable)query2.getDimFilter()).appendCacheables(query2.getAggregatorSpecs()).appendCacheables(query2.getDimensions()).appendCacheable((Cacheable)query2.getVirtualColumns()).appendCacheable((Cacheable)query2.getHavingSpec()).appendCacheable((Cacheable)query2.getLimitSpec()).appendCacheables(query2.getPostAggregatorSpecs());
                if (query2.getSubtotalsSpec() != null && !query2.getSubtotalsSpec().isEmpty()) {
                    for (List<String> subTotalSpec : query2.getSubtotalsSpec()) {
                        builder.appendStrings(subTotalSpec);
                    }
                }
                return builder.build();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<ResultRow, Object> prepareForCache(final boolean isResultLevelCache) {
                final boolean resultRowHasTimestamp = query.getResultRowHasTimestamp();
                return new Function<ResultRow, Object>(){

                    public Object apply(ResultRow resultRow) {
                        int i;
                        ArrayList<Object> retVal = new ArrayList<Object>(1 + dims.size() + aggs.size());
                        int inPos = 0;
                        if (resultRowHasTimestamp) {
                            retVal.add(resultRow.getLong(inPos++));
                        } else {
                            retVal.add(query.getUniversalTimestamp().getMillis());
                        }
                        for (i = 0; i < dims.size(); ++i) {
                            retVal.add(resultRow.get(inPos++));
                        }
                        for (i = 0; i < aggs.size(); ++i) {
                            retVal.add(resultRow.get(inPos++));
                        }
                        if (isResultLevelCache) {
                            for (i = 0; i < query.getPostAggregatorSpecs().size(); ++i) {
                                retVal.add(resultRow.get(inPos++));
                            }
                        }
                        return retVal;
                    }
                };
            }

            @Override
            public Function<Object, ResultRow> pullFromCache(final boolean isResultLevelCache) {
                final boolean resultRowHasTimestamp = query.getResultRowHasTimestamp();
                final int dimensionStart = query.getResultRowDimensionStart();
                final int aggregatorStart = query.getResultRowAggregatorStart();
                final int postAggregatorStart = query.getResultRowPostAggregatorStart();
                return new Function<Object, ResultRow>(){
                    private final Granularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    public ResultRow apply(Object input) {
                        Iterator<Object> results = ((List)input).iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)results.next()).longValue());
                        int size = isResultLevelCache ? query.getResultRowSizeWithPostAggregators() : query.getResultRowSizeWithoutPostAggregators();
                        ResultRow resultRow = ResultRow.create(size);
                        if (resultRowHasTimestamp) {
                            resultRow.set(0, timestamp.getMillis());
                        }
                        Iterator dimsIter = dims.iterator();
                        int dimPos = 0;
                        while (dimsIter.hasNext() && results.hasNext()) {
                            DimensionSpec dimensionSpec = (DimensionSpec)dimsIter.next();
                            resultRow.set(dimensionStart + dimPos, DimensionHandlerUtils.convertObjectToType(results.next(), (TypeSignature<ValueType>)dimensionSpec.getOutputType()));
                            ++dimPos;
                        }
                        CacheStrategy.fetchAggregatorsFromCache(aggs, results, isResultLevelCache, (aggName, aggPosition, aggValueObject) -> resultRow.set(aggregatorStart + aggPosition, aggValueObject));
                        if (isResultLevelCache) {
                            Iterator<PostAggregator> postItr = query.getPostAggregatorSpecs().iterator();
                            int postPos = 0;
                            while (postItr.hasNext() && results.hasNext()) {
                                resultRow.set(postAggregatorStart + postPos, results.next());
                            }
                        }
                        if (dimsIter.hasNext() || results.hasNext()) {
                            throw new ISE("Found left over objects while reading from cache!! dimsIter[%s] results[%s]", new Object[]{dimsIter.hasNext(), results.hasNext()});
                        }
                        return resultRow;
                    }
                };
            }
        };
    }

    @Override
    public boolean canPerformSubquery(Query<?> subquery) {
        Query current = subquery;
        while (current != null) {
            if (!(current instanceof GroupByQuery)) {
                return false;
            }
            if (current.getDataSource() instanceof QueryDataSource) {
                current = ((QueryDataSource)current.getDataSource()).getQuery();
                continue;
            }
            current = null;
        }
        return true;
    }

    @Override
    public RowSignature resultArraySignature(GroupByQuery query) {
        return query.getResultRowSignature();
    }

    @Override
    public Sequence<Object[]> resultsAsArrays(GroupByQuery query, Sequence<ResultRow> resultSequence) {
        return resultSequence.map(ResultRow::getArray);
    }

    private static BitSet extractionsToRewrite(GroupByQuery query) {
        BitSet retVal = new BitSet();
        List<DimensionSpec> dimensions = query.getDimensions();
        for (int i = 0; i < dimensions.size(); ++i) {
            DimensionSpec dimensionSpec = dimensions.get(i);
            if (dimensionSpec.getExtractionFn() == null || !ExtractionFn.ExtractionType.ONE_TO_ONE.equals((Object)dimensionSpec.getExtractionFn().getExtractionType())) continue;
            retVal.set(i);
        }
        return retVal;
    }
}

