/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.apache.druid.segment.SortedDimensionDictionary;

public abstract class DimensionDictionary<T extends Comparable<T>> {
    public static final int ABSENT_VALUE_ID = -1;
    private final Class<T> cls;
    @Nullable
    private T minValue = null;
    @Nullable
    private T maxValue = null;
    private volatile int idForNull = -1;
    private final AtomicLong sizeInBytes = new AtomicLong(0L);
    private final Object2IntMap<T> valueToId = new Object2IntOpenHashMap();
    private final List<T> idToValue = new ArrayList<T>();
    private final ReentrantReadWriteLock lock;

    public DimensionDictionary(Class<T> cls) {
        this.cls = cls;
        this.lock = new ReentrantReadWriteLock();
        this.valueToId.defaultReturnValue(-1);
    }

    public int getId(@Nullable T value) {
        this.lock.readLock().lock();
        try {
            if (value == null) {
                int n = this.idForNull;
                return n;
            }
            int n = this.valueToId.getInt(value);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Nullable
    public T getValue(int id) {
        this.lock.readLock().lock();
        try {
            if (id == this.idForNull) {
                T t = null;
                return t;
            }
            Comparable comparable = (Comparable)this.idToValue.get(id);
            return (T)comparable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] getValues(int[] ids) {
        Comparable[] values = (Comparable[])Array.newInstance(this.cls, ids.length);
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < ids.length; ++i) {
                values[i] = ids[i] == this.idForNull ? null : (Comparable)this.idToValue.get(ids[i]);
            }
            Comparable[] comparableArray = values;
            return comparableArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.idToValue.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long sizeInBytes() {
        if (!this.computeOnHeapSize()) {
            throw new IllegalStateException("On-heap size computation is disabled");
        }
        return this.sizeInBytes.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(@Nullable T originalValue) {
        this.lock.writeLock().lock();
        try {
            if (originalValue == null) {
                if (this.idForNull == -1) {
                    this.idForNull = this.idToValue.size();
                    this.idToValue.add(null);
                }
                int n = this.idForNull;
                return n;
            }
            int prev = this.valueToId.getInt(originalValue);
            if (prev >= 0) {
                int n = prev;
                return n;
            }
            int index = this.idToValue.size();
            this.valueToId.put(originalValue, index);
            this.idToValue.add(originalValue);
            if (this.computeOnHeapSize()) {
                this.sizeInBytes.addAndGet(this.estimateSizeOfValue(originalValue) + 16L);
            }
            this.minValue = this.minValue == null || this.minValue.compareTo(originalValue) > 0 ? originalValue : this.minValue;
            this.maxValue = this.maxValue == null || this.maxValue.compareTo(originalValue) < 0 ? originalValue : this.maxValue;
            int n = index;
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public T getMinValue() {
        this.lock.readLock().lock();
        try {
            T t = this.minValue;
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public T getMaxValue() {
        this.lock.readLock().lock();
        try {
            T t = this.maxValue;
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getIdForNull() {
        return this.idForNull;
    }

    public SortedDimensionDictionary<T> sort() {
        this.lock.readLock().lock();
        try {
            SortedDimensionDictionary<T> sortedDimensionDictionary = new SortedDimensionDictionary<T>(this.idToValue, this.idToValue.size());
            return sortedDimensionDictionary;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public abstract long estimateSizeOfValue(T var1);

    public abstract boolean computeOnHeapSize();
}

