/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.EncodedKeyComponent;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.LongWrappingDimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexRowHolder;

public class LongDimensionIndexer
implements DimensionIndexer<Long, Long, Long> {
    public static final Comparator<Long> LONG_COMPARATOR = Comparators.naturalNullsFirst();
    private volatile boolean hasNulls = false;

    @Override
    public EncodedKeyComponent<Long> processRowValsToUnsortedEncodedKeyComponent(@Nullable Object dimValues, boolean reportParseExceptions) {
        Long l = DimensionHandlerUtils.convertObjectToLong(dimValues, reportParseExceptions);
        if (l == null) {
            this.hasNulls = NullHandling.sqlCompatible();
        }
        return new EncodedKeyComponent<Long>(l, 8L);
    }

    @Override
    public void setSparseIndexed() {
        this.hasNulls = NullHandling.sqlCompatible();
    }

    @Override
    public Long getUnsortedEncodedValueFromSorted(Long sortedIntermediateValue) {
        return sortedIntermediateValue;
    }

    @Override
    public CloseableIndexed<Long> getSortedIndexedValues() {
        throw new UnsupportedOperationException("Numeric columns do not support value dictionaries.");
    }

    @Override
    public Long getMinValue() {
        return Long.MIN_VALUE;
    }

    @Override
    public Long getMaxValue() {
        return Long.MAX_VALUE;
    }

    @Override
    public int getCardinality() {
        return -1;
    }

    @Override
    public ColumnCapabilities getColumnCapabilities() {
        ColumnCapabilitiesImpl builder = ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature<ValueType>)ColumnType.LONG);
        if (this.hasNulls) {
            builder.setHasNulls(this.hasNulls);
        }
        return builder;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec spec, IncrementalIndexRowHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        return new LongWrappingDimensionSelector(this.makeColumnValueSelector(currEntry, desc), spec.getExtractionFn());
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final IncrementalIndexRowHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final int dimIndex = desc.getIndex();
        class IndexerLongColumnSelector
        implements LongColumnSelector {
            IndexerLongColumnSelector() {
            }

            @Override
            public boolean isNull() {
                Object[] dims = currEntry.get().getDims();
                return LongDimensionIndexer.this.hasNulls && (dimIndex >= dims.length || dims[dimIndex] == null);
            }

            @Override
            public long getLong() {
                Object[] dims = currEntry.get().getDims();
                if (dimIndex >= dims.length || dims[dimIndex] == null) {
                    assert (NullHandling.replaceWithDefault());
                    return 0L;
                }
                return (Long)dims[dimIndex];
            }

            @Override
            @Nullable
            public Long getObject() {
                Object[] dims = currEntry.get().getDims();
                if (dimIndex >= dims.length || dims[dimIndex] == null) {
                    return NullHandling.defaultLongValue();
                }
                return (Long)dims[dimIndex];
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
        return new IndexerLongColumnSelector();
    }

    @Override
    public int compareUnsortedEncodedKeyComponents(@Nullable Long lhs, @Nullable Long rhs) {
        return LONG_COMPARATOR.compare(lhs, rhs);
    }

    @Override
    public boolean checkUnsortedEncodedKeyComponentsEqual(@Nullable Long lhs, @Nullable Long rhs) {
        return Objects.equals(lhs, rhs);
    }

    @Override
    public int getUnsortedEncodedKeyComponentHashCode(@Nullable Long key) {
        return DimensionHandlerUtils.nullToZero(key).hashCode();
    }

    @Override
    public Object convertUnsortedEncodedKeyComponentToActualList(Long key) {
        return key;
    }

    @Override
    public ColumnValueSelector convertUnsortedValuesToSorted(ColumnValueSelector selectorWithUnsortedValues) {
        return selectorWithUnsortedValues;
    }

    @Override
    public void fillBitmapsFromUnsortedEncodedKeyComponent(Long key, int rowNum, MutableBitmap[] bitmapIndexes, BitmapFactory factory) {
        throw new UnsupportedOperationException("Numeric columns do not support bitmaps.");
    }
}

