/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnCache;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexColumnSelectorFactory;
import org.apache.druid.segment.RowPointer;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.TimeAndDimsPointer;
import org.apache.druid.segment.TransformableRowIterator;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.DictionaryEncodedValueIndex;
import org.apache.druid.segment.data.BitmapValues;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.data.ImmutableBitmapValues;
import org.apache.druid.segment.data.IndexedIterable;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableLongColumnValueSelector;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.Interval;

public class QueryableIndexIndexableAdapter
implements IndexableAdapter {
    private final int numRows;
    private final QueryableIndex input;
    private final ImmutableList<String> availableDimensions;
    private final Metadata metadata;

    public QueryableIndexIndexableAdapter(QueryableIndex input) {
        this.input = input;
        this.numRows = input.getNumRows();
        this.availableDimensions = ImmutableList.copyOf(input.getAvailableDimensions());
        this.metadata = input.getMetadata();
    }

    public QueryableIndex getQueryableIndex() {
        return this.input;
    }

    @Override
    public Interval getDataInterval() {
        return this.input.getDataInterval();
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public List<String> getDimensionNames() {
        return this.availableDimensions;
    }

    @Override
    public List<String> getMetricNames() {
        LinkedHashSet columns = Sets.newLinkedHashSet(this.input.getColumnNames());
        HashSet dimensions = Sets.newHashSet(this.getDimensionNames());
        return ImmutableList.copyOf((Collection)Sets.difference((Set)columns, (Set)dimensions));
    }

    @Override
    @Nullable
    public <T extends Comparable<? super T>> CloseableIndexed<T> getDimValueLookup(String dimension) {
        ColumnHolder columnHolder = this.input.getColumnHolder(dimension);
        if (columnHolder == null) {
            return null;
        }
        BaseColumn col = columnHolder.getColumn();
        if (!(col instanceof DictionaryEncodedColumn)) {
            return null;
        }
        final DictionaryEncodedColumn dict = (DictionaryEncodedColumn)col;
        return new CloseableIndexed<T>(){

            @Override
            public int size() {
                return dict.getCardinality();
            }

            @Override
            public T get(int index) {
                return dict.lookupName(index);
            }

            @Override
            public int indexOf(T value) {
                return dict.lookupId(value);
            }

            @Override
            public Iterator<T> iterator() {
                return IndexedIterable.create(this).iterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("dict", dict);
            }

            @Override
            public void close() throws IOException {
                dict.close();
            }
        };
    }

    @Override
    public RowIteratorImpl getRows() {
        return new RowIteratorImpl();
    }

    @Override
    public String getMetricType(String metric) {
        ColumnHolder columnHolder = this.input.getColumnHolder(metric);
        switch (columnHolder.getCapabilities().getType()) {
            case FLOAT: {
                return "float";
            }
            case LONG: {
                return "long";
            }
            case DOUBLE: {
                return "double";
            }
            case COMPLEX: {
                try (ComplexColumn complexColumn = (ComplexColumn)columnHolder.getColumn();){
                    String string = complexColumn.getTypeName();
                    return string;
                }
            }
        }
        throw new ISE("Unknown type[%s]", new Object[]{columnHolder.getCapabilities().asTypeString()});
    }

    @Override
    public ColumnCapabilities getCapabilities(String column) {
        return this.input.getColumnHolder(column).getCapabilities();
    }

    @Override
    public BitmapValues getBitmapValues(String dimension, int dictId) {
        ColumnHolder columnHolder = this.input.getColumnHolder(dimension);
        if (columnHolder == null) {
            return BitmapValues.EMPTY;
        }
        ColumnIndexSupplier indexSupplier = columnHolder.getIndexSupplier();
        if (indexSupplier == null) {
            return BitmapValues.EMPTY;
        }
        DictionaryEncodedValueIndex bitmaps = indexSupplier.as(DictionaryEncodedValueIndex.class);
        if (bitmaps == null) {
            return BitmapValues.EMPTY;
        }
        if (dictId >= 0) {
            return new ImmutableBitmapValues(bitmaps.getBitmap(dictId));
        }
        return BitmapValues.EMPTY;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    class RowIteratorImpl
    implements TransformableRowIterator {
        private final Closer closer;
        private final ColumnCache columnCache;
        private final SimpleAscendingOffset offset;
        private final int maxValidOffset;
        private final ColumnValueSelector<?> offsetTimestampSelector;
        private final ColumnValueSelector<?>[] offsetDimensionValueSelectors;
        private final ColumnValueSelector<?>[] offsetMetricSelectors;
        private final SettableLongColumnValueSelector rowTimestampSelector;
        private final SettableColumnValueSelector<?>[] rowDimensionValueSelectors;
        private final SettableColumnValueSelector<?>[] rowMetricSelectors;
        private final RowPointer rowPointer;
        private final SettableLongColumnValueSelector markedTimestampSelector;
        private final SettableColumnValueSelector<?>[] markedDimensionValueSelectors;
        private final SettableColumnValueSelector<?>[] markedMetricSelectors;
        private final TimeAndDimsPointer markedRowPointer;
        boolean first;

        RowIteratorImpl() {
            this.offset = new SimpleAscendingOffset(QueryableIndexIndexableAdapter.this.numRows);
            this.maxValidOffset = QueryableIndexIndexableAdapter.this.numRows - 1;
            this.rowTimestampSelector = new SettableLongColumnValueSelector();
            this.markedTimestampSelector = new SettableLongColumnValueSelector();
            this.first = true;
            this.closer = Closer.create();
            this.columnCache = new ColumnCache(QueryableIndexIndexableAdapter.this.input, this.closer);
            QueryableIndexColumnSelectorFactory columnSelectorFactory = new QueryableIndexColumnSelectorFactory(VirtualColumns.EMPTY, false, this.offset, this.columnCache);
            this.offsetTimestampSelector = columnSelectorFactory.makeColumnValueSelector("__time");
            ArrayList<DimensionHandler> dimensionHandlers = new ArrayList<DimensionHandler>(QueryableIndexIndexableAdapter.this.input.getDimensionHandlers().values());
            this.offsetDimensionValueSelectors = (ColumnValueSelector[])dimensionHandlers.stream().map(DimensionHandler::getDimensionName).map(columnSelectorFactory::makeColumnValueSelector).toArray(ColumnValueSelector[]::new);
            List<String> metricNames = QueryableIndexIndexableAdapter.this.getMetricNames();
            this.offsetMetricSelectors = (ColumnValueSelector[])metricNames.stream().map(columnSelectorFactory::makeColumnValueSelector).toArray(ColumnValueSelector[]::new);
            this.rowDimensionValueSelectors = (SettableColumnValueSelector[])dimensionHandlers.stream().map(DimensionHandler::makeNewSettableEncodedValueSelector).toArray(SettableColumnValueSelector[]::new);
            this.rowMetricSelectors = (SettableColumnValueSelector[])metricNames.stream().map(metric -> QueryableIndexIndexableAdapter.this.input.getColumnHolder((String)metric).makeNewSettableColumnValueSelector()).toArray(SettableColumnValueSelector[]::new);
            this.rowPointer = new RowPointer(this.rowTimestampSelector, this.rowDimensionValueSelectors, dimensionHandlers, this.rowMetricSelectors, metricNames, this.offset::getOffset);
            this.markedDimensionValueSelectors = (SettableColumnValueSelector[])dimensionHandlers.stream().map(DimensionHandler::makeNewSettableEncodedValueSelector).toArray(SettableColumnValueSelector[]::new);
            this.markedMetricSelectors = (SettableColumnValueSelector[])metricNames.stream().map(metric -> QueryableIndexIndexableAdapter.this.input.getColumnHolder((String)metric).makeNewSettableColumnValueSelector()).toArray(SettableColumnValueSelector[]::new);
            this.markedRowPointer = new TimeAndDimsPointer(this.markedTimestampSelector, this.markedDimensionValueSelectors, dimensionHandlers, this.markedMetricSelectors, metricNames);
        }

        @Override
        public TimeAndDimsPointer getMarkedPointer() {
            return this.markedRowPointer;
        }

        @Override
        public boolean hasTimeAndDimsChangedSinceMark() {
            return this.markedRowPointer.compareTo(this.rowPointer) != 0;
        }

        @Override
        public void close() {
            CloseableUtils.closeAndWrapExceptions((Closeable)this.closer);
        }

        @Override
        public RowPointer getPointer() {
            return this.rowPointer;
        }

        @Override
        public boolean moveToNext() {
            if (this.first) {
                this.first = false;
                if (this.offset.withinBounds()) {
                    this.setRowPointerValues();
                    return true;
                }
                return false;
            }
            if (this.offset.getOffset() < this.maxValidOffset) {
                this.offset.increment();
                this.setRowPointerValues();
                return true;
            }
            return false;
        }

        private void setRowPointerValues() {
            int i;
            this.rowTimestampSelector.setValue(this.offsetTimestampSelector.getLong());
            for (i = 0; i < this.offsetDimensionValueSelectors.length; ++i) {
                this.rowDimensionValueSelectors[i].setValueFrom(this.offsetDimensionValueSelectors[i]);
            }
            for (i = 0; i < this.offsetMetricSelectors.length; ++i) {
                this.rowMetricSelectors[i].setValueFrom(this.offsetMetricSelectors[i]);
            }
        }

        @Override
        public void mark() {
            int i;
            this.markedTimestampSelector.setValue(this.rowTimestampSelector.getLong());
            for (i = 0; i < this.rowDimensionValueSelectors.length; ++i) {
                this.markedDimensionValueSelectors[i].setValueFrom(this.rowDimensionValueSelectors[i]);
            }
            for (i = 0; i < this.rowMetricSelectors.length; ++i) {
                this.markedMetricSelectors[i].setValueFrom(this.rowMetricSelectors[i]);
            }
        }
    }
}

