/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.column.DruidPredicateIndex;
import org.apache.druid.segment.column.SimpleImmutableBitmapIterableIndex;
import org.apache.druid.segment.data.Indexed;

public final class IndexedStringDruidPredicateIndex<TDictionary extends Indexed<String>>
implements DruidPredicateIndex {
    private final BitmapFactory bitmapFactory;
    private final TDictionary dictionary;
    private final Indexed<ImmutableBitmap> bitmaps;

    public IndexedStringDruidPredicateIndex(BitmapFactory bitmapFactory, TDictionary dictionary, Indexed<ImmutableBitmap> bitmaps) {
        this.bitmapFactory = bitmapFactory;
        this.dictionary = dictionary;
        this.bitmaps = bitmaps;
    }

    @Override
    public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
        return new SimpleImmutableBitmapIterableIndex(){

            @Override
            public Iterable<ImmutableBitmap> getBitmapIterable() {
                return () -> new Iterator<ImmutableBitmap>(){
                    @Nullable
                    String next;
                    boolean nextSet;
                    final Predicate stringPredicate;
                    final Iterator iterator;
                    {
                        this.stringPredicate = matcherFactory.makeStringPredicate();
                        this.iterator = IndexedStringDruidPredicateIndex.this.dictionary.iterator();
                        this.next = null;
                        this.nextSet = false;
                    }

                    @Override
                    public boolean hasNext() {
                        if (!this.nextSet) {
                            this.findNext();
                        }
                        return this.nextSet;
                    }

                    @Override
                    public ImmutableBitmap next() {
                        if (!this.nextSet) {
                            this.findNext();
                            if (!this.nextSet) {
                                throw new NoSuchElementException();
                            }
                        }
                        this.nextSet = false;
                        int idx = IndexedStringDruidPredicateIndex.this.dictionary.indexOf(this.next);
                        if (idx < 0) {
                            return IndexedStringDruidPredicateIndex.this.bitmapFactory.makeEmptyImmutableBitmap();
                        }
                        ImmutableBitmap bitmap = (ImmutableBitmap)IndexedStringDruidPredicateIndex.this.bitmaps.get(idx);
                        return bitmap == null ? IndexedStringDruidPredicateIndex.this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
                    }

                    private void findNext() {
                        while (!this.nextSet && this.iterator.hasNext()) {
                            String nextValue = (String)this.iterator.next();
                            this.nextSet = this.stringPredicate.apply((Object)nextValue);
                            if (!this.nextSet) continue;
                            this.next = nextValue;
                        }
                    }
                };
            }
        };
    }
}

