/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.IntListUtils;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.column.LexicographicalRangeIndex;
import org.apache.druid.segment.column.SimpleImmutableBitmapIterableIndex;
import org.apache.druid.segment.data.Indexed;

public final class IndexedUtf8LexicographicalRangeIndex<TDictionary extends Indexed<ByteBuffer>>
implements LexicographicalRangeIndex {
    private final BitmapFactory bitmapFactory;
    private final TDictionary dictionary;
    private final Indexed<ImmutableBitmap> bitmaps;
    private final boolean hasNull;

    public IndexedUtf8LexicographicalRangeIndex(BitmapFactory bitmapFactory, TDictionary dictionary, Indexed<ImmutableBitmap> bitmaps, boolean hasNull) {
        Preconditions.checkArgument((boolean)dictionary.isSorted(), (Object)"Dictionary must be sorted");
        this.bitmapFactory = bitmapFactory;
        this.dictionary = dictionary;
        this.bitmaps = bitmaps;
        this.hasNull = hasNull;
    }

    @Override
    public BitmapColumnIndex forRange(final @Nullable String startValue, final boolean startStrict, final @Nullable String endValue, final boolean endStrict) {
        return new SimpleImmutableBitmapIterableIndex(){

            @Override
            public Iterable<ImmutableBitmap> getBitmapIterable() {
                IntIntPair range = IndexedUtf8LexicographicalRangeIndex.this.getRange(startValue, startStrict, endValue, endStrict);
                final int start = range.leftInt();
                final int end = range.rightInt();
                return () -> new Iterator<ImmutableBitmap>(){
                    final IntIterator rangeIterator;
                    {
                        this.rangeIterator = IntListUtils.fromTo(start, end).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.rangeIterator.hasNext();
                    }

                    @Override
                    public ImmutableBitmap next() {
                        return IndexedUtf8LexicographicalRangeIndex.this.getBitmap(this.rangeIterator.nextInt());
                    }
                };
            }
        };
    }

    @Override
    public BitmapColumnIndex forRange(final @Nullable String startValue, final boolean startStrict, final @Nullable String endValue, final boolean endStrict, final Predicate<String> matcher) {
        return new SimpleImmutableBitmapIterableIndex(){

            @Override
            public Iterable<ImmutableBitmap> getBitmapIterable() {
                IntIntPair range = IndexedUtf8LexicographicalRangeIndex.this.getRange(startValue, startStrict, endValue, endStrict);
                final int start = range.leftInt();
                final int end = range.rightInt();
                return () -> new Iterator<ImmutableBitmap>(){
                    int currIndex;
                    int found;
                    {
                        this.currIndex = start;
                        this.found = this.findNext();
                    }

                    private int findNext() {
                        while (this.currIndex < end && !this.applyMatcher((ByteBuffer)IndexedUtf8LexicographicalRangeIndex.this.dictionary.get(this.currIndex))) {
                            ++this.currIndex;
                        }
                        if (this.currIndex < end) {
                            return this.currIndex++;
                        }
                        return -1;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.found != -1;
                    }

                    @Override
                    public ImmutableBitmap next() {
                        int cur = this.found;
                        if (cur == -1) {
                            throw new NoSuchElementException();
                        }
                        this.found = this.findNext();
                        return IndexedUtf8LexicographicalRangeIndex.this.getBitmap(cur);
                    }
                };
            }

            private boolean applyMatcher(@Nullable ByteBuffer valueUtf8) {
                if (valueUtf8 == null) {
                    return matcher.apply(null);
                }
                return matcher.apply((Object)StringUtils.fromUtf8((ByteBuffer)valueUtf8.duplicate()));
            }
        };
    }

    private IntIntPair getRange(@Nullable String startValue, boolean startStrict, @Nullable String endValue, boolean endStrict) {
        String endValueToUse;
        String startValueToUse;
        int found;
        int firstValue;
        int n = firstValue = this.hasNull ? 1 : 0;
        int startIndex = startValue == null ? firstValue : ((found = this.dictionary.indexOf((ByteBuffer)StringUtils.toUtf8ByteBuffer((String)(startValueToUse = NullHandling.emptyToNullIfNeeded((String)startValue))))) >= firstValue ? (startStrict ? found + 1 : found) : -(found + 1));
        int endIndex = endValue == null ? this.dictionary.size() : ((found = this.dictionary.indexOf((ByteBuffer)StringUtils.toUtf8ByteBuffer((String)(endValueToUse = NullHandling.emptyToNullIfNeeded((String)endValue))))) >= firstValue ? (endStrict ? found : found + 1) : -(found + 1));
        endIndex = Math.max(startIndex, endIndex);
        return new IntIntImmutablePair(startIndex, endIndex);
    }

    private ImmutableBitmap getBitmap(int idx) {
        if (idx < 0) {
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        ImmutableBitmap bitmap = this.bitmaps.get(idx);
        return bitmap == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
    }
}

