/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.column.SimpleBitmapColumnIndex;
import org.apache.druid.segment.column.SimpleImmutableBitmapIterableIndex;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.column.Utf8ValueSetIndex;
import org.apache.druid.segment.data.Indexed;

public final class IndexedUtf8ValueSetIndex<TDictionary extends Indexed<ByteBuffer>>
implements StringValueSetIndex,
Utf8ValueSetIndex {
    private static final double SORTED_MERGE_RATIO_THRESHOLD = 0.12;
    private static final int SIZE_WORTH_CHECKING_MIN = 8;
    private static final Comparator<ByteBuffer> COMPARATOR = ByteBufferUtils.utf8Comparator();
    private final BitmapFactory bitmapFactory;
    private final TDictionary dictionary;
    private final Indexed<ImmutableBitmap> bitmaps;

    public IndexedUtf8ValueSetIndex(BitmapFactory bitmapFactory, TDictionary dictionary, Indexed<ImmutableBitmap> bitmaps) {
        Preconditions.checkArgument((boolean)dictionary.isSorted(), (Object)"Dictionary must be sorted");
        this.bitmapFactory = bitmapFactory;
        this.dictionary = dictionary;
        this.bitmaps = bitmaps;
    }

    @Override
    public BitmapColumnIndex forValue(final @Nullable String value) {
        return new SimpleBitmapColumnIndex(){

            @Override
            public double estimateSelectivity(int totalRows) {
                return Math.min(1.0, (double)this.getBitmapForValue().size() / (double)totalRows);
            }

            @Override
            public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory) {
                return bitmapResultFactory.wrapDimensionValue(this.getBitmapForValue());
            }

            private ImmutableBitmap getBitmapForValue() {
                ByteBuffer valueUtf8 = value == null ? null : ByteBuffer.wrap(StringUtils.toUtf8((String)value));
                int idx = IndexedUtf8ValueSetIndex.this.dictionary.indexOf(valueUtf8);
                return IndexedUtf8ValueSetIndex.this.getBitmap(idx);
            }
        };
    }

    @Override
    public BitmapColumnIndex forSortedValues(SortedSet<String> values) {
        return this.getBitmapColumnIndexForSortedIterableUtf8(Iterables.transform(values, input -> input != null ? ByteBuffer.wrap(StringUtils.toUtf8((String)input)) : null), values.size());
    }

    @Override
    public BitmapColumnIndex forSortedValuesUtf8(SortedSet<ByteBuffer> valuesUtf8) {
        SortedSet<ByteBuffer> tailSet;
        if (valuesUtf8.size() >= 8) {
            ByteBuffer minValueInColumn = (ByteBuffer)this.dictionary.get(0);
            tailSet = valuesUtf8.tailSet(minValueInColumn);
        } else {
            tailSet = valuesUtf8;
        }
        return this.getBitmapColumnIndexForSortedIterableUtf8(tailSet, tailSet.size());
    }

    private ImmutableBitmap getBitmap(int idx) {
        if (idx < 0) {
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        ImmutableBitmap bitmap = this.bitmaps.get(idx);
        return bitmap == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
    }

    private BitmapColumnIndex getBitmapColumnIndexForSortedIterableUtf8(final Iterable<ByteBuffer> valuesUtf8, int size) {
        if ((double)size > 0.12 * (double)this.dictionary.size()) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        int next;
                        int idx;
                        final PeekingIterator valuesIterator;
                        final PeekingIterator dictionaryIterator;
                        {
                            this.valuesIterator = Iterators.peekingIterator(valuesUtf8.iterator());
                            this.dictionaryIterator = Iterators.peekingIterator(IndexedUtf8ValueSetIndex.this.dictionary.iterator());
                            this.next = -1;
                            this.idx = 0;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return IndexedUtf8ValueSetIndex.this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.valuesIterator.hasNext() && this.dictionaryIterator.hasNext()) {
                                ByteBuffer nextValue = (ByteBuffer)this.valuesIterator.peek();
                                ByteBuffer nextDictionaryKey = (ByteBuffer)this.dictionaryIterator.peek();
                                int comparison = COMPARATOR.compare(nextValue, nextDictionaryKey);
                                if (comparison == 0) {
                                    this.next = this.idx;
                                    this.valuesIterator.next();
                                    break;
                                }
                                if (comparison < 0) {
                                    this.valuesIterator.next();
                                    continue;
                                }
                                this.dictionaryIterator.next();
                                ++this.idx;
                            }
                        }
                    };
                }
            };
        }
        return new SimpleImmutableBitmapIterableIndex(){

            @Override
            public Iterable<ImmutableBitmap> getBitmapIterable() {
                return () -> new Iterator<ImmutableBitmap>(){
                    final int dictionarySize;
                    int next;
                    final Iterator iterator;
                    {
                        this.dictionarySize = IndexedUtf8ValueSetIndex.this.dictionary.size();
                        this.iterator = valuesUtf8.iterator();
                        this.next = -1;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next < 0) {
                            this.findNext();
                        }
                        return this.next >= 0;
                    }

                    @Override
                    public ImmutableBitmap next() {
                        if (this.next < 0) {
                            this.findNext();
                            if (this.next < 0) {
                                throw new NoSuchElementException();
                            }
                        }
                        int swap = this.next;
                        this.next = -1;
                        return IndexedUtf8ValueSetIndex.this.getBitmap(swap);
                    }

                    private void findNext() {
                        while (this.next < 0 && this.iterator.hasNext()) {
                            ByteBuffer nextValue = (ByteBuffer)this.iterator.next();
                            this.next = IndexedUtf8ValueSetIndex.this.dictionary.indexOf(nextValue);
                            if (this.next != -this.dictionarySize - 1) continue;
                            break;
                        }
                    }
                };
            }
        };
    }
}

