/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.ObjectStrategy;

public class ObjectStrategyComplexTypeStrategy<T>
implements TypeStrategy<T> {
    private final ObjectStrategy<T> objectStrategy;
    private final TypeSignature<?> typeSignature;

    public ObjectStrategyComplexTypeStrategy(ObjectStrategy<T> objectStrategy, TypeSignature<?> signature) {
        this.objectStrategy = objectStrategy;
        this.typeSignature = signature;
    }

    public int estimateSizeBytes(@Nullable T value) {
        byte[] bytes = this.objectStrategy.toBytes(value);
        return bytes == null ? 0 : bytes.length;
    }

    public T read(ByteBuffer buffer) {
        int complexLength = buffer.getInt();
        ByteBuffer dupe = buffer.duplicate();
        dupe.order(buffer.order());
        dupe.limit(dupe.position() + complexLength);
        return this.objectStrategy.fromByteBuffer(dupe, complexLength);
    }

    public boolean readRetainsBufferReference() {
        return true;
    }

    public int write(ByteBuffer buffer, T value, int maxSizeBytes) {
        TypeStrategies.checkMaxSize((int)buffer.remaining(), (int)maxSizeBytes, this.typeSignature);
        byte[] bytes = this.objectStrategy.toBytes(value);
        int sizeBytes = 4 + bytes.length;
        int remaining = maxSizeBytes - sizeBytes;
        if (remaining >= 0) {
            buffer.putInt(bytes.length);
            buffer.put(bytes, 0, bytes.length);
            return sizeBytes;
        }
        return remaining;
    }

    public int compare(T o1, T o2) {
        return this.objectStrategy.compare(o1, o2);
    }

    public T fromBytes(byte[] value) {
        return this.objectStrategy.fromByteBufferSafe(ByteBuffer.wrap(value), value.length);
    }
}

