/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import java.nio.ByteBuffer;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.EncodedStringDictionaryWriter;
import org.apache.druid.segment.data.FrontCodedIndexedWriter;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class StringEncodingStrategies {
    public static DictionaryWriter<String> getStringDictionaryWriter(StringEncodingStrategy encodingStrategy, SegmentWriteOutMedium writeoutMedium, String fileName) {
        if ("utf8".equals(encodingStrategy.getType())) {
            return new GenericIndexedWriter<String>(writeoutMedium, fileName, GenericIndexed.STRING_STRATEGY);
        }
        if (!"frontCoded".equals(encodingStrategy.getType())) {
            throw new ISE("Unknown encoding strategy: %s", new Object[]{encodingStrategy.getType()});
        }
        FrontCodedIndexedWriter writer = new FrontCodedIndexedWriter(writeoutMedium, IndexIO.BYTE_ORDER, ((StringEncodingStrategy.FrontCoded)encodingStrategy).getBucketSize());
        return new EncodedStringDictionaryWriter(writer, encodingStrategy);
    }

    public static final class Utf8ToStringIndexed
    implements Indexed<String> {
        private final Indexed<ByteBuffer> delegate;

        public Utf8ToStringIndexed(Indexed<ByteBuffer> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        @Nullable
        public String get(int index) {
            return StringUtils.fromUtf8Nullable((ByteBuffer)this.delegate.get(index));
        }

        @Override
        public int indexOf(@Nullable String value) {
            return this.delegate.indexOf(StringUtils.toUtf8ByteBuffer((String)value));
        }

        @Override
        public Iterator<String> iterator() {
            final Iterator delegateIterator = this.delegate.iterator();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return delegateIterator.hasNext();
                }

                @Override
                public String next() {
                    return StringUtils.fromUtf8Nullable((ByteBuffer)((ByteBuffer)delegateIterator.next()));
                }
            };
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("delegateIndex", this.delegate);
        }
    }
}

