/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.StringDictionaryEncodedColumn;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.ColumnarMultiInts;
import org.apache.druid.segment.data.FrontCodedIndexed;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.SingleIndexedInt;
import org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.druid.segment.historical.HistoricalDimensionSelector;
import org.apache.druid.segment.historical.SingleValueHistoricalDimensionSelector;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.utils.CloseableUtils;

public class StringFrontCodedDictionaryEncodedColumn
implements DictionaryEncodedColumn<String> {
    @Nullable
    private final ColumnarInts column;
    @Nullable
    private final ColumnarMultiInts multiValueColumn;
    private final FrontCodedIndexed utf8Dictionary;

    public StringFrontCodedDictionaryEncodedColumn(@Nullable ColumnarInts singleValueColumn, @Nullable ColumnarMultiInts multiValueColumn, FrontCodedIndexed utf8Dictionary) {
        this.column = singleValueColumn;
        this.multiValueColumn = multiValueColumn;
        this.utf8Dictionary = utf8Dictionary;
    }

    @Override
    public int length() {
        return this.hasMultipleValues() ? this.multiValueColumn.size() : this.column.size();
    }

    @Override
    public boolean hasMultipleValues() {
        return this.column == null;
    }

    @Override
    public int getSingleValueRow(int rowNum) {
        return this.column.get(rowNum);
    }

    @Override
    public IndexedInts getMultiValueRow(int rowNum) {
        return this.multiValueColumn.get(rowNum);
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        ByteBuffer buffer = this.utf8Dictionary.get(id);
        if (buffer == null) {
            return null;
        }
        return StringUtils.fromUtf8((ByteBuffer)buffer);
    }

    @Override
    public int lookupId(String name) {
        return this.utf8Dictionary.indexOf(StringUtils.toUtf8ByteBuffer((String)name));
    }

    @Override
    public int getCardinality() {
        return this.utf8Dictionary.size();
    }

    @Override
    public HistoricalDimensionSelector makeDimensionSelector(final ReadableOffset offset, final @Nullable ExtractionFn extractionFn) {
        if (this.hasMultipleValues()) {
            class MultiValueDimensionSelector
            extends 1QueryableDimensionSelector {
                MultiValueDimensionSelector() {
                    abstract class QueryableDimensionSelector
                    extends AbstractDimensionSelector
                    implements HistoricalDimensionSelector,
                    IdLookup {
                        final /* synthetic */ ExtractionFn val$extractionFn;

                        QueryableDimensionSelector() {
                            this.val$extractionFn = extractionFn;
                        }

                        @Override
                        public int getValueCardinality() {
                            return StringFrontCodedDictionaryEncodedColumn.this.getCardinality();
                        }

                        @Override
                        public String lookupName(int id) {
                            String value = StringFrontCodedDictionaryEncodedColumn.this.lookupName(id);
                            return this.val$extractionFn == null ? value : this.val$extractionFn.apply(value);
                        }

                        @Override
                        @Nullable
                        public ByteBuffer lookupNameUtf8(int id) {
                            return StringFrontCodedDictionaryEncodedColumn.this.utf8Dictionary.get(id);
                        }

                        @Override
                        public boolean supportsLookupNameUtf8() {
                            return true;
                        }

                        @Override
                        public boolean nameLookupPossibleInAdvance() {
                            return true;
                        }

                        @Override
                        @Nullable
                        public IdLookup idLookup() {
                            return this.val$extractionFn == null ? this : null;
                        }

                        @Override
                        public int lookupId(String name) {
                            if (this.val$extractionFn != null) {
                                throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                            }
                            return StringFrontCodedDictionaryEncodedColumn.this.lookupId(name);
                        }
                    }
                    super(StringFrontCodedDictionaryEncodedColumn.this, extractionFn2);
                }

                @Override
                public IndexedInts getRow() {
                    return StringFrontCodedDictionaryEncodedColumn.this.multiValueColumn.get(offset.getOffset());
                }

                @Override
                public IndexedInts getRow(int offset2) {
                    return StringFrontCodedDictionaryEncodedColumn.this.multiValueColumn.get(offset2);
                }

                @Override
                public ValueMatcher makeValueMatcher(@Nullable String value) {
                    return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
                }

                @Override
                public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                    return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
                }

                @Override
                @Nullable
                public Object getObject() {
                    return this.defaultGetObject();
                }

                @Override
                public Class classOfObject() {
                    return Object.class;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("multiValueColumn", StringFrontCodedDictionaryEncodedColumn.this.multiValueColumn);
                    inspector.visit("offset", offset);
                    inspector.visit("extractionFn", extractionFn);
                }
            }
            return new MultiValueDimensionSelector();
        }
        class SingleValueQueryableDimensionSelector
        extends 1QueryableDimensionSelector
        implements SingleValueHistoricalDimensionSelector {
            private final SingleIndexedInt row;

            SingleValueQueryableDimensionSelector() {
                super(StringFrontCodedDictionaryEncodedColumn.this, extractionFn2);
                this.row = new SingleIndexedInt();
            }

            @Override
            public IndexedInts getRow() {
                this.row.setValue(this.getRowValue());
                return this.row;
            }

            public int getRowValue() {
                return StringFrontCodedDictionaryEncodedColumn.this.column.get(offset.getOffset());
            }

            @Override
            public IndexedInts getRow(int offset2) {
                this.row.setValue(this.getRowValue(offset2));
                return this.row;
            }

            @Override
            public int getRowValue(int offset2) {
                return StringFrontCodedDictionaryEncodedColumn.this.column.get(offset2);
            }

            @Override
            public ValueMatcher makeValueMatcher(@Nullable String value) {
                if (extractionFn == null) {
                    final int valueId = super.lookupId(value);
                    if (valueId >= 0) {
                        return new ValueMatcher(){

                            @Override
                            public boolean matches() {
                                return this.getRowValue() == valueId;
                            }

                            @Override
                            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                                inspector.visit("column", StringFrontCodedDictionaryEncodedColumn.this);
                            }
                        };
                    }
                    return BooleanValueMatcher.of(false);
                }
                return this.makeValueMatcher((Predicate<String>)Predicates.equalTo((Object)value));
            }

            @Override
            public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
                final BitSet checkedIds = new BitSet(StringFrontCodedDictionaryEncodedColumn.this.getCardinality());
                final BitSet matchingIds = new BitSet(StringFrontCodedDictionaryEncodedColumn.this.getCardinality());
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        int id = this.getRowValue();
                        if (checkedIds.get(id)) {
                            return matchingIds.get(id);
                        }
                        boolean matches = predicate.apply((Object)this.lookupName(id));
                        checkedIds.set(id);
                        if (matches) {
                            matchingIds.set(id);
                        }
                        return matches;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("column", StringFrontCodedDictionaryEncodedColumn.this);
                    }
                };
            }

            @Override
            public Object getObject() {
                return super.lookupName(this.getRowValue());
            }

            @Override
            public Class classOfObject() {
                return String.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", StringFrontCodedDictionaryEncodedColumn.this.column);
                inspector.visit("offset", offset);
                inspector.visit("extractionFn", extractionFn);
            }
        }
        return new SingleValueQueryableDimensionSelector();
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(final ReadableVectorOffset offset) {
        final class StringVectorSelector
        extends StringDictionaryEncodedColumn.StringSingleValueDimensionVectorSelector {
            public StringVectorSelector() {
                super(StringFrontCodedDictionaryEncodedColumn.this.column, readableVectorOffset);
            }

            @Override
            public int getValueCardinality() {
                return StringFrontCodedDictionaryEncodedColumn.this.getCardinality();
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return StringFrontCodedDictionaryEncodedColumn.this.lookupName(id);
            }

            @Override
            @Nullable
            public ByteBuffer lookupNameUtf8(int id) {
                return StringFrontCodedDictionaryEncodedColumn.this.utf8Dictionary.get(id);
            }

            @Override
            public int lookupId(@Nullable String name) {
                return StringFrontCodedDictionaryEncodedColumn.this.lookupId(name);
            }
        }
        return new StringVectorSelector();
    }

    @Override
    public MultiValueDimensionVectorSelector makeMultiValueDimensionVectorSelector(final ReadableVectorOffset offset) {
        final class MultiStringVectorSelector
        extends StringDictionaryEncodedColumn.StringMultiValueDimensionVectorSelector {
            public MultiStringVectorSelector() {
                super(StringFrontCodedDictionaryEncodedColumn.this.multiValueColumn, readableVectorOffset);
            }

            @Override
            public int getValueCardinality() {
                return StringFrontCodedDictionaryEncodedColumn.this.getCardinality();
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return StringFrontCodedDictionaryEncodedColumn.this.lookupName(id);
            }

            @Override
            @Nullable
            public ByteBuffer lookupNameUtf8(int id) {
                return StringFrontCodedDictionaryEncodedColumn.this.utf8Dictionary.get(id);
            }

            @Override
            public int lookupId(@Nullable String name) {
                return StringFrontCodedDictionaryEncodedColumn.this.lookupId(name);
            }
        }
        return new MultiStringVectorSelector();
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(final ReadableVectorOffset offset) {
        if (!this.hasMultipleValues()) {
            final class StringVectorSelector
            extends StringDictionaryEncodedColumn.StringVectorObjectSelector {
                public StringVectorSelector() {
                    super(StringFrontCodedDictionaryEncodedColumn.this.column, readableVectorOffset);
                }

                @Override
                @Nullable
                public String lookupName(int id) {
                    return StringFrontCodedDictionaryEncodedColumn.this.lookupName(id);
                }
            }
            return new StringVectorSelector();
        }
        final class MultiStringVectorSelector
        extends StringDictionaryEncodedColumn.MultiValueStringVectorObjectSelector {
            public MultiStringVectorSelector() {
                super(StringFrontCodedDictionaryEncodedColumn.this.multiValueColumn, readableVectorOffset);
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return StringFrontCodedDictionaryEncodedColumn.this.lookupName(id);
            }
        }
        return new MultiStringVectorSelector();
    }

    @Override
    public void close() throws IOException {
        CloseableUtils.closeAll((Closeable)this.column, (Closeable[])new Closeable[]{this.multiValueColumn});
    }
}

