/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.IndexedIterable;

public class FixedIndexed<T>
implements Indexed<T> {
    public static final byte IS_SORTED_MASK = 2;
    private final ByteBuffer buffer;
    private final TypeStrategy<T> typeStrategy;
    private final int width;
    private final int size;
    private final int valuesOffset;
    private final boolean hasNull;
    private final boolean isSorted;
    private final Comparator<T> comparator;

    public static <T> Supplier<FixedIndexed<T>> read(ByteBuffer bb, TypeStrategy<T> strategy, ByteOrder byteOrder, int width) {
        ByteBuffer buffer = bb.asReadOnlyBuffer().order(byteOrder);
        byte version = buffer.get();
        Preconditions.checkState((version == 0 ? 1 : 0) != 0, (String)"Unknown version [%s]", (Object[])new Object[]{version});
        byte flags = buffer.get();
        boolean hasNull = (flags & 1) == 1;
        boolean isSorted = (flags & 2) == 2;
        Preconditions.checkState((!hasNull || isSorted ? 1 : 0) != 0, (Object)"cannot have null values if not sorted");
        int size = buffer.getInt() + (hasNull ? 1 : 0);
        int valuesOffset = buffer.position();
        Supplier fixedIndexed = () -> new FixedIndexed(bb, byteOrder, strategy, hasNull, isSorted, width, size, valuesOffset);
        bb.position(buffer.position() + width * size);
        return fixedIndexed;
    }

    private FixedIndexed(ByteBuffer buffer, ByteOrder byteOrder, TypeStrategy<T> typeStrategy, boolean hasNull, boolean isSorted, int width, int size, int valuesOffset) {
        this.buffer = buffer.asReadOnlyBuffer().order(byteOrder);
        this.typeStrategy = typeStrategy;
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)"FixedIndexed requires a fixed width value type");
        this.width = width;
        this.size = size;
        this.valuesOffset = valuesOffset;
        this.hasNull = hasNull;
        this.isSorted = isSorted;
        this.comparator = Comparator.nullsFirst(typeStrategy);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @Nullable
    public T get(int index) {
        Indexed.checkIndex(index, this.size);
        if (this.hasNull) {
            if (index == 0) {
                return null;
            }
            return (T)this.typeStrategy.read(this.buffer, this.valuesOffset + (index - 1) * this.width);
        }
        return (T)this.typeStrategy.read(this.buffer, this.valuesOffset + index * this.width);
    }

    @Override
    public int indexOf(@Nullable T value) {
        if (!this.isSorted) {
            throw new UnsupportedOperationException("Reverse lookup not allowed.");
        }
        int minIndex = 0;
        int maxIndex = this.size - 1;
        while (minIndex <= maxIndex) {
            int currIndex = minIndex + maxIndex >>> 1;
            T currValue = this.get(currIndex);
            int comparison = this.comparator.compare(currValue, value);
            if (comparison == 0) {
                return currIndex;
            }
            if (comparison < 0) {
                minIndex = currIndex + 1;
                continue;
            }
            maxIndex = currIndex - 1;
        }
        return -(minIndex + 1);
    }

    @Override
    public boolean isSorted() {
        return this.isSorted;
    }

    @Override
    public Iterator<T> iterator() {
        return IndexedIterable.create(this).iterator();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("buffer", this.buffer);
        inspector.visit("typeStrategy", this.typeStrategy);
        inspector.visit("comparator", this.comparator);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FixedIndexed[");
        if (this.size() > 0) {
            for (int i = 0; i < this.size(); ++i) {
                T value = this.get(i);
                sb.append(value).append(',').append(' ');
            }
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb.toString();
    }
}

