/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.filter.BooleanFilter;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.RowOffsetMatcherFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.column.ColumnIndexCapabilities;
import org.apache.druid.segment.column.SimpleColumnIndexCapabilities;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class OrFilter
implements BooleanFilter {
    private static final Joiner OR_JOINER = Joiner.on((String)" || ");
    private final LinkedHashSet<Filter> filters;

    public OrFilter(LinkedHashSet<Filter> filters) {
        Preconditions.checkArgument((filters.size() > 0 ? 1 : 0) != 0, (Object)"Can't construct empty OrFilter (the universe does not exist)");
        this.filters = filters;
    }

    public OrFilter(List<Filter> filters) {
        this(new LinkedHashSet<Filter>(filters));
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(final ColumnIndexSelector selector) {
        if (this.filters.size() == 1) {
            return ((Filter)Iterables.getOnlyElement(this.filters)).getBitmapColumnIndex(selector);
        }
        final ArrayList<BitmapColumnIndex> bitmapColumnIndices = new ArrayList<BitmapColumnIndex>(this.filters.size());
        ColumnIndexCapabilities merged = new SimpleColumnIndexCapabilities(true, true);
        for (Filter filter : this.filters) {
            BitmapColumnIndex index = filter.getBitmapColumnIndex(selector);
            if (index == null) {
                return null;
            }
            merged = merged.merge(index.getIndexCapabilities());
            bitmapColumnIndices.add(index);
        }
        final SimpleColumnIndexCapabilities finalMerged = merged;
        return new BitmapColumnIndex(){

            @Override
            public ColumnIndexCapabilities getIndexCapabilities() {
                return finalMerged;
            }

            @Override
            public double estimateSelectivity(int totalRows) {
                double selectivity = 0.0;
                for (Filter filter : OrFilter.this.filters) {
                    selectivity += filter.estimateSelectivity(selector);
                }
                return Math.min(selectivity, 1.0);
            }

            @Override
            public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory) {
                return bitmapResultFactory.union(() -> bitmapColumnIndices.stream().map(x -> x.computeBitmapResult(bitmapResultFactory)).iterator());
            }
        };
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        ValueMatcher[] matchers = new ValueMatcher[this.filters.size()];
        int i = 0;
        for (Filter filter : this.filters) {
            matchers[i++] = filter.makeMatcher(factory);
        }
        return OrFilter.makeMatcher(matchers);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        VectorValueMatcher[] matchers = new VectorValueMatcher[this.filters.size()];
        int i = 0;
        for (Filter filter : this.filters) {
            matchers[i++] = filter.makeVectorMatcher(factory);
        }
        return OrFilter.makeVectorMatcher(matchers);
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return this.filters.stream().allMatch(filter -> filter.canVectorizeMatcher(inspector));
    }

    @Override
    public ValueMatcher makeMatcher(ColumnIndexSelector selector, ColumnSelectorFactory columnSelectorFactory, RowOffsetMatcherFactory rowOffsetMatcherFactory) {
        ArrayList<ValueMatcher> matchers = new ArrayList<ValueMatcher>();
        ArrayList<ImmutableBitmap> bitmaps = new ArrayList<ImmutableBitmap>();
        BitmapFactory bitmapFactory = selector.getBitmapFactory();
        DefaultBitmapResultFactory resultFactory = new DefaultBitmapResultFactory(bitmapFactory);
        for (Filter filter : this.filters) {
            BitmapColumnIndex columnIndex = filter.getBitmapColumnIndex(selector);
            if (columnIndex != null && columnIndex.getIndexCapabilities().isExact()) {
                bitmaps.add(columnIndex.computeBitmapResult(resultFactory));
                continue;
            }
            ValueMatcher matcher = filter.makeMatcher(columnSelectorFactory);
            matchers.add(matcher);
        }
        if (bitmaps.size() > 0) {
            ImmutableBitmap combinedBitmap = selector.getBitmapFactory().union(bitmaps);
            ValueMatcher offsetMatcher = rowOffsetMatcherFactory.makeRowOffsetMatcher(combinedBitmap);
            matchers.add(0, offsetMatcher);
        }
        return OrFilter.makeMatcher(matchers.toArray(BooleanFilter.EMPTY_VALUE_MATCHER_ARRAY));
    }

    @Override
    public LinkedHashSet<Filter> getFilters() {
        return this.filters;
    }

    public String toString() {
        return StringUtils.format((String)"(%s)", (Object[])new Object[]{OR_JOINER.join(this.filters)});
    }

    private static ValueMatcher makeMatcher(final ValueMatcher[] baseMatchers) {
        Preconditions.checkState((baseMatchers.length > 0 ? 1 : 0) != 0);
        if (baseMatchers.length == 1) {
            return baseMatchers[0];
        }
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                for (ValueMatcher matcher : baseMatchers) {
                    if (!matcher.matches()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("firstBaseMatcher", baseMatchers[0]);
                inspector.visit("secondBaseMatcher", baseMatchers[1]);
            }
        };
    }

    private static VectorValueMatcher makeVectorMatcher(final VectorValueMatcher[] baseMatchers) {
        Preconditions.checkState((baseMatchers.length > 0 ? 1 : 0) != 0);
        if (baseMatchers.length == 1) {
            return baseMatchers[0];
        }
        return new BaseVectorValueMatcher(baseMatchers[0]){
            final VectorMatch currentMask;
            final VectorMatch scratch;
            final VectorMatch retVal;
            {
                super(selector);
                this.currentMask = VectorMatch.wrap(new int[this.getMaxVectorSize()]);
                this.scratch = VectorMatch.wrap(new int[this.getMaxVectorSize()]);
                this.retVal = VectorMatch.wrap(new int[this.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                ReadableVectorMatch currentMatch = baseMatchers[0].match(mask);
                this.currentMask.copyFrom(mask);
                this.retVal.copyFrom(currentMatch);
                for (int i = 1; i < baseMatchers.length && !this.retVal.isAllTrue(this.getCurrentVectorSize()); ++i) {
                    this.currentMask.removeAll(currentMatch);
                    currentMatch = baseMatchers[i].match(this.currentMask);
                    this.retVal.addAll(currentMatch, this.scratch);
                    if (currentMatch == this.currentMask) break;
                }
                assert (this.retVal.isValid(mask));
                return this.retVal;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrFilter orFilter = (OrFilter)o;
        return Objects.equals(this.getFilters(), orFilter.getFilters());
    }

    public int hashCode() {
        return Objects.hash(this.getFilters());
    }
}

