/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableColumnValueSelector;
import org.apache.druid.segment.join.table.IndexedTableDimensionSelector;

public class IndexedTableColumnSelectorFactory
implements ColumnSelectorFactory {
    private final IndexedTable table;
    private final IntSupplier currentRow;
    private final Closer closer;

    IndexedTableColumnSelectorFactory(IndexedTable table, IntSupplier currentRow, Closer closer) {
        this.table = table;
        this.currentRow = currentRow;
        this.closer = closer;
    }

    @Nullable
    static ColumnCapabilities columnCapabilities(IndexedTable table, String columnName) {
        ColumnType valueType = table.rowSignature().getColumnType(columnName).orElse(null);
        if (valueType != null) {
            ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl().setType(valueType);
            if (valueType.is((TypeDescriptor)ValueType.STRING)) {
                capabilities.setDictionaryEncoded(true);
            }
            capabilities.setDictionaryValuesSorted(false);
            capabilities.setDictionaryValuesUnique(false);
            capabilities.setHasMultipleValues(false);
            return capabilities;
        }
        return null;
    }

    @Override
    @Nonnull
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        int columnNumber = this.table.rowSignature().indexOf(dimensionSpec.getDimension());
        if (columnNumber < 0) {
            return dimensionSpec.decorate(DimensionSelector.constant(null, dimensionSpec.getExtractionFn()));
        }
        IndexedTableDimensionSelector undecoratedSelector = new IndexedTableDimensionSelector(this.table, this.currentRow, columnNumber, dimensionSpec.getExtractionFn(), this.closer);
        return dimensionSpec.decorate(undecoratedSelector);
    }

    @Override
    @Nonnull
    public ColumnValueSelector makeColumnValueSelector(String columnName) {
        int columnNumber = this.table.rowSignature().indexOf(columnName);
        if (columnNumber < 0) {
            return NilColumnValueSelector.instance();
        }
        return new IndexedTableColumnValueSelector(this.table, this.currentRow, columnNumber, this.closer);
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return IndexedTableColumnSelectorFactory.columnCapabilities(this.table, column);
    }
}

