/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.ColumnarDoublesSerializer;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.nested.GlobalDictionaryEncodedFieldColumnWriter;
import org.apache.druid.segment.nested.GlobalDictionaryIdLookup;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public final class DoubleFieldColumnWriter
extends GlobalDictionaryEncodedFieldColumnWriter<Double> {
    private ColumnarDoublesSerializer doublesSerializer;

    protected DoubleFieldColumnWriter(String columnName, String fieldName, SegmentWriteOutMedium segmentWriteOutMedium, IndexSpec indexSpec, GlobalDictionaryIdLookup globalDictionaryIdLookup) {
        super(columnName, fieldName, segmentWriteOutMedium, indexSpec, globalDictionaryIdLookup);
    }

    @Override
    int lookupGlobalId(Double value) {
        return this.globalDictionaryIdLookup.lookupDouble(value);
    }

    @Override
    public void open() throws IOException {
        super.open();
        this.doublesSerializer = CompressionFactory.getDoubleSerializer(this.fieldName, this.segmentWriteOutMedium, StringUtils.format((String)"%s.double_column", (Object[])new Object[]{this.fieldName}), ByteOrder.nativeOrder(), this.indexSpec.getDimensionCompression());
        this.doublesSerializer.open();
    }

    @Override
    void writeValue(@Nullable Double value) throws IOException {
        if (value == null) {
            this.doublesSerializer.add(0.0);
        } else {
            this.doublesSerializer.add(value);
        }
    }

    @Override
    void writeColumnTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writeLongAndDoubleColumnLength(channel, 0, Ints.checkedCast((long)this.doublesSerializer.getSerializedSize()));
        this.doublesSerializer.writeTo(channel, smoosher);
        this.encodedValueSerializer.writeTo(channel, smoosher);
    }

    @Override
    long getSerializedColumnSize() throws IOException {
        return super.getSerializedColumnSize() + this.doublesSerializer.getSerializedSize();
    }
}

